/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.SimplexTableau;
import org.ojalgo.type.context.NumberContext;

public final class SimplexSolver
extends LinearSolver {
    private final SimplexTableau.IterationPoint myPoint;
    private final SimplexTableau myTableau;

    static SimplexTableau build(ConvexSolver.Builder convex) {
        int numbVars = convex.countVariables();
        int numbEqus = convex.countEqualityConstraints();
        int numbInes = convex.countInequalityConstraints();
        SimplexTableau retVal = SimplexTableau.make(numbEqus + numbInes, numbVars + numbVars, numbInes);
        Mutate1D obj = retVal.objective();
        MatrixStore<Double> convexC = convex.getC();
        for (int v = 0; v < numbVars; ++v) {
            double val = convexC.doubleValue(v);
            obj.set((long)v, -val);
            obj.set((long)(numbVars + v), val);
        }
        Mutate2D constrBody = retVal.constraintsBody();
        Mutate1D constrRHS = retVal.constraintsRHS();
        MatrixStore<Double> convexAE = convex.getAE();
        MatrixStore<Double> convexBE = convex.getBE();
        for (int i = 0; i < numbEqus; ++i) {
            double rhs = convexBE.doubleValue(i);
            boolean neg = NumberContext.compare(rhs, PrimitiveMath.ZERO) < 0;
            for (int j = 0; j < numbVars; ++j) {
                double val = convexAE.doubleValue(i, j);
                constrBody.set((long)i, (long)j, neg ? -val : val);
                constrBody.set((long)i, (long)(numbVars + j), neg ? val : -val);
            }
            constrRHS.set((long)i, neg ? -rhs : rhs);
        }
        RowsSupplier<Double> convexAI = convex.getAI();
        MatrixStore<Double> convexBI = convex.getBI();
        for (int i = 0; i < numbInes; ++i) {
            int r = i;
            SparseArray<Double> row = convexAI.getRow(r);
            double rhs = convexBI.doubleValue(r);
            boolean neg = NumberContext.compare(rhs, PrimitiveMath.ZERO) < 0;
            row.nonzeros().forEach(nz -> constrBody.set((long)(numbEqus + r), nz.index(), neg ? -nz.doubleValue() : nz.doubleValue()));
            row.nonzeros().forEach(nz -> constrBody.set((long)(numbEqus + r), (long)numbVars + nz.index(), neg ? nz.doubleValue() : -nz.doubleValue()));
            constrBody.set((long)(numbEqus + r), (long)(numbVars + numbVars + r), neg ? PrimitiveMath.NEG : PrimitiveMath.ONE);
            constrRHS.set((long)(numbEqus + i), neg ? -rhs : rhs);
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    static SimplexTableau build(ExpressionsBasedModel model) {
        void var27_48;
        int tmpNegInd;
        int tmpPosInd;
        int tmpNegInd2;
        int tmpPosInd2;
        int tmpNegInd3;
        List<Variable> tmpPosVariables = model.getPositiveVariables();
        List<Variable> tmpNegVariables = model.getNegativeVariables();
        Set<Structure1D.IntIndex> tmpFixVariables = model.getFixedVariables();
        Expression tmpObjFunc = model.objective().compensate(tmpFixVariables);
        List tmpExprsEq = model.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpExprsLo = model.constraints().filter(c -> c.isLowerConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpExprsUp = model.constraints().filter(c -> c.isUpperConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpVarsPosLo = model.bounds().filter(v -> v.isPositive() && v.isLowerConstraint() && v.getLowerLimit().signum() > 0).collect(Collectors.toList());
        List tmpVarsPosUp = model.bounds().filter(v -> v.isPositive() && v.isUpperConstraint() && v.getUpperLimit().signum() > 0).collect(Collectors.toList());
        List tmpVarsNegLo = model.bounds().filter(v -> v.isNegative() && v.isLowerConstraint() && v.getLowerLimit().signum() < 0).collect(Collectors.toList());
        List tmpVarsNegUp = model.bounds().filter(v -> v.isNegative() && v.isUpperConstraint() && v.getUpperLimit().signum() < 0).collect(Collectors.toList());
        int tmpConstraiCount = tmpExprsEq.size() + tmpExprsLo.size() + tmpExprsUp.size() + tmpVarsPosLo.size() + tmpVarsPosUp.size() + tmpVarsNegLo.size() + tmpVarsNegUp.size();
        int tmpProblVarCount = tmpPosVariables.size() + tmpNegVariables.size();
        int tmpSlackVarCount = tmpExprsLo.size() + tmpExprsUp.size() + tmpVarsPosLo.size() + tmpVarsPosUp.size() + tmpVarsNegLo.size() + tmpVarsNegUp.size();
        SimplexTableau retVal = SimplexTableau.make(tmpConstraiCount, tmpProblVarCount, tmpSlackVarCount);
        boolean tmpPosVarsBaseIndex = false;
        int tmpNegVarsBaseIndex = 0 + tmpPosVariables.size();
        int tmpSlaVarsBaseIndex = tmpNegVarsBaseIndex + tmpNegVariables.size();
        for (Structure1D.IntIndex tmpKey : tmpObjFunc.getLinearKeySet()) {
            int tmpNegInd4;
            double tmpFactor = model.isMaximisation() ? -tmpObjFunc.getAdjustedLinearFactor(tmpKey) : tmpObjFunc.getAdjustedLinearFactor(tmpKey);
            int tmpPosInd3 = model.indexOfPositiveVariable(tmpKey.index);
            if (tmpPosInd3 >= 0) {
                retVal.objective().set((long)tmpPosInd3, tmpFactor);
            }
            if ((tmpNegInd4 = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
            retVal.objective().set((long)(tmpNegVarsBaseIndex + tmpNegInd4), -tmpFactor);
        }
        int tmpConstrBaseIndex = 0;
        int tmpCurrentSlackVarIndex = tmpSlaVarsBaseIndex;
        int tmpExprsEqLength = tmpExprsEq.size();
        for (int c2 = 0; c2 < tmpExprsEqLength; ++c2) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsEq.get(c2)).compensate(tmpFixVariables);
            double tmpRHS = tmpExpr.getAdjustedLowerLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c2), -tmpRHS);
                for (Structure1D.IntIndex intIndex : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(intIndex);
                    int tmpPosInd3 = model.indexOfPositiveVariable(intIndex.index);
                    if (tmpPosInd3 >= 0) {
                        retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c2), (long)(0 + tmpPosInd3), -tmpFactor);
                    }
                    if ((tmpNegInd3 = model.indexOfNegativeVariable(intIndex.index)) < 0) continue;
                    retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c2), (long)(tmpNegVarsBaseIndex + tmpNegInd3), tmpFactor);
                }
                continue;
            }
            retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c2), tmpRHS);
            for (Structure1D.IntIndex intIndex : tmpExpr.getLinearKeySet()) {
                int tmpNegInd32;
                tmpFactor = tmpExpr.getAdjustedLinearFactor(intIndex);
                int tmpPosInd4 = model.indexOfPositiveVariable(intIndex.index);
                if (tmpPosInd4 >= 0) {
                    retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c2), (long)(0 + tmpPosInd4), tmpFactor);
                }
                if ((tmpNegInd32 = model.indexOfNegativeVariable(intIndex.index)) < 0) continue;
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c2), (long)(tmpNegVarsBaseIndex + tmpNegInd32), -tmpFactor);
            }
        }
        tmpConstrBaseIndex += tmpExprsEqLength;
        int tmpExprsLoLength = tmpExprsLo.size();
        for (int c3 = 0; c3 < tmpExprsLoLength; ++c3) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsLo.get(c3)).compensate(tmpFixVariables);
            double tmpRHS = tmpExpr.getAdjustedLowerLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c3), -tmpRHS);
                for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                    tmpPosInd2 = model.indexOfPositiveVariable(tmpKey.index);
                    if (tmpPosInd2 >= 0) {
                        retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c3), (long)(0 + tmpPosInd2), -tmpFactor);
                    }
                    if ((tmpNegInd2 = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                    retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c3), (long)(tmpNegVarsBaseIndex + tmpNegInd2), tmpFactor);
                }
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c3), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
                continue;
            }
            retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c3), tmpRHS);
            for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                int tmpNegInd22;
                tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                int tmpPosInd22 = model.indexOfPositiveVariable(tmpKey.index);
                if (tmpPosInd22 >= 0) {
                    retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c3), (long)(0 + tmpPosInd22), tmpFactor);
                }
                if ((tmpNegInd22 = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c3), (long)(tmpNegVarsBaseIndex + tmpNegInd22), -tmpFactor);
            }
            retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c3), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
        }
        tmpConstrBaseIndex += tmpExprsLoLength;
        int tmpExprsUpLength = tmpExprsUp.size();
        for (int c4 = 0; c4 < tmpExprsUpLength; ++c4) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsUp.get(c4)).compensate(tmpFixVariables);
            double tmpRHS = tmpExpr.getAdjustedUpperLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c4), -tmpRHS);
                for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                    tmpPosInd = model.indexOfPositiveVariable(tmpKey.index);
                    if (tmpPosInd >= 0) {
                        retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c4), (long)(0 + tmpPosInd), -tmpFactor);
                    }
                    if ((tmpNegInd = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                    retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c4), (long)(tmpNegVarsBaseIndex + tmpNegInd), tmpFactor);
                }
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c4), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
                continue;
            }
            retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c4), tmpRHS);
            for (Structure1D.IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                tmpPosInd = model.indexOfPositiveVariable(tmpKey.index);
                if (tmpPosInd >= 0) {
                    retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c4), (long)(0 + tmpPosInd), tmpFactor);
                }
                if ((tmpNegInd = model.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c4), (long)(tmpNegVarsBaseIndex + tmpNegInd), -tmpFactor);
            }
            retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c4), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
        }
        tmpConstrBaseIndex += tmpExprsUpLength;
        int tmpVarsPosLoLength = tmpVarsPosLo.size();
        for (int c5 = 0; c5 < tmpVarsPosLoLength; ++c5) {
            Variable tmpVar = (Variable)tmpVarsPosLo.get(c5);
            retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c5), tmpVar.getAdjustedLowerLimit());
            int n = model.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            int tmpPosInd5 = model.indexOfPositiveVariable(n);
            if (tmpPosInd5 >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c5), (long)(0 + tmpPosInd5), tmpFactor);
            }
            if ((tmpNegInd3 = model.indexOfNegativeVariable(n)) >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c5), (long)(tmpNegVarsBaseIndex + tmpNegInd3), -tmpFactor);
            }
            retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c5), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
        }
        tmpConstrBaseIndex += tmpVarsPosLoLength;
        int tmpVarsPosUpLength = tmpVarsPosUp.size();
        for (int c6 = 0; c6 < tmpVarsPosUpLength; ++c6) {
            Variable variable = (Variable)tmpVarsPosUp.get(c6);
            retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c6), variable.getAdjustedUpperLimit());
            int tmpKey = model.indexOf(variable);
            double tmpFactor = variable.getAdjustmentFactor();
            tmpPosInd2 = model.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd2 >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c6), (long)(0 + tmpPosInd2), tmpFactor);
            }
            if ((tmpNegInd2 = model.indexOfNegativeVariable(tmpKey)) >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c6), (long)(tmpNegVarsBaseIndex + tmpNegInd2), -tmpFactor);
            }
            retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c6), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
        }
        tmpConstrBaseIndex += tmpVarsPosUpLength;
        int tmpVarsNegLoLength = tmpVarsNegLo.size();
        boolean bl = false;
        while (var27_48 < tmpVarsNegLoLength) {
            Variable tmpVar = (Variable)tmpVarsNegLo.get((int)var27_48);
            retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + var27_48), -tmpVar.getAdjustedLowerLimit());
            int tmpKey = model.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            tmpPosInd = model.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + var27_48), (long)(0 + tmpPosInd), -tmpFactor);
            }
            if ((tmpNegInd = model.indexOfNegativeVariable(tmpKey)) >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + var27_48), (long)(tmpNegVarsBaseIndex + tmpNegInd), tmpFactor);
            }
            retVal.constraintsBody().set((long)(tmpConstrBaseIndex + var27_48), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
            ++var27_48;
        }
        tmpConstrBaseIndex += tmpVarsNegLoLength;
        int n = tmpVarsNegUp.size();
        for (int c8 = 0; c8 < n; ++c8) {
            int tmpNegInd5;
            Variable tmpVar = (Variable)tmpVarsNegUp.get(c8);
            retVal.constraintsRHS().set((long)(tmpConstrBaseIndex + c8), -tmpVar.getAdjustedUpperLimit());
            int tmpKey = model.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            int tmpPosInd6 = model.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd6 >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c8), (long)(0 + tmpPosInd6), -tmpFactor);
            }
            if ((tmpNegInd5 = model.indexOfNegativeVariable(tmpKey)) >= 0) {
                retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c8), (long)(tmpNegVarsBaseIndex + tmpNegInd5), tmpFactor);
            }
            retVal.constraintsBody().set((long)(tmpConstrBaseIndex + c8), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
        }
        tmpConstrBaseIndex += n;
        if ((long)retVal.getOvercapacity() <= OjAlgoUtils.ENVIRONMENT.getCacheElements(8L)) {
            return retVal.toDense();
        }
        return retVal;
    }

    SimplexSolver(SimplexTableau tableau, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myTableau = tableau;
        this.myPoint = new SimplexTableau.IterationPoint();
        if (this.isDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Tableau Created");
        }
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (this.isDebug() && this.isTableauPrintable()) {
            this.logDebugTableau("Initial Tableau");
        }
        while (this.needsAnotherIteration()) {
            this.performIteration(this.myPoint);
            if (!this.isDebug() || !this.isTableauPrintable()) continue;
            this.logDebugTableau("Tableau Iteration");
        }
        return this.buildResult();
    }

    private int getRowObjective() {
        return this.myPoint.isPhase1() ? this.myTableau.countConstraints() + 1 : this.myTableau.countConstraints();
    }

    private final boolean isTableauPrintable() {
        return this.myTableau.count() <= 512L;
    }

    private final void logDebugTableau(String message) {
        this.log(message + "; Basics: " + Arrays.toString(this.myTableau.getBasis()), this.myTableau);
    }

    private double objective() {
        return -this.myTableau.doubleValue(this.getRowObjective(), this.myTableau.countConstraints() + this.myTableau.countVariables());
    }

    private int phase() {
        return this.myPoint.isPhase2() ? 2 : 1;
    }

    @Override
    protected Optimisation.Result buildResult() {
        return super.buildResult().multipliers(this.myTableau.sliceDualVariables());
    }

    @Override
    protected double evaluateFunction(Access1D<?> solution) {
        return this.objective();
    }

    protected PhysicalStore<Double> extractSolution() {
        int colRHS = this.myTableau.countConstraints() + this.myTableau.countVariables();
        PrimitiveDenseStore solution = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.myTableau.countVariables(), 1L);
        int numberOfConstraints = this.myTableau.countConstraints();
        for (int row = 0; row < numberOfConstraints; ++row) {
            int variableIndex = this.myTableau.getBasis(row);
            if (variableIndex < 0) continue;
            solution.set((long)variableIndex, this.myTableau.doubleValue(row, colRHS));
        }
        return solution;
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        return false;
    }

    @Override
    protected boolean needsAnotherIteration() {
        if (this.isDebug()) {
            this.log("\nNeeds Another Iteration? Phase={} Artificials={} Objective={}", this.phase(), this.myTableau.countBasisDeficit(), this.objective());
        }
        boolean retVal = false;
        this.myPoint.reset();
        if (this.myPoint.isPhase1()) {
            double tmpPhaseOneValue = this.myTableau.doubleValue(this.getRowObjective(), this.myTableau.countConstraints() + this.myTableau.countVariables());
            if (!this.myTableau.isBasicArtificials() || this.options.feasibility.isZero(tmpPhaseOneValue)) {
                if (this.isDebug()) {
                    this.log("\nSwitching to Phase2 with {} artificial variable(s) still in the basis.\n", this.myTableau.countBasicArtificials());
                }
                this.myPoint.switchToPhase2();
            }
        }
        this.myPoint.col = this.findNextPivotCol();
        if (this.myPoint.col >= 0) {
            this.myPoint.row = this.findNextPivotRow();
            if (this.myPoint.row >= 0) {
                retVal = true;
            } else if (this.myPoint.isPhase2()) {
                this.setState(Optimisation.State.UNBOUNDED);
                retVal = false;
            } else {
                this.setState(Optimisation.State.INFEASIBLE);
                retVal = false;
            }
        } else if (this.myPoint.isPhase1()) {
            this.setState(Optimisation.State.INFEASIBLE);
            retVal = false;
        } else {
            this.setState(Optimisation.State.OPTIMAL);
            retVal = false;
        }
        if (this.isDebug()) {
            if (retVal) {
                this.log("\n==>>\tRow: {},\tExit: {},\tColumn/Enter: {}.\n", this.myPoint.row, this.myTableau.getBasis(this.myPoint.row), this.myPoint.col);
            } else {
                this.log("\n==>>\tNo more iterations needed/possible.\n", new Object[0]);
            }
        }
        return retVal;
    }

    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        return true;
    }

    int findNextPivotCol() {
        int[] tmpExcluded = this.myTableau.getExcluded();
        if (this.isDebug()) {
            if (this.options.validate) {
                this.log("\nfindNextPivotCol (index of most negative value) among these:\n{}", ((Array1D)Array1D.PRIMITIVE64.copy((Access1D)this.myTableau.sliceTableauRow(this.getRowObjective()))).copy(tmpExcluded));
            } else {
                this.log("\nfindNextPivotCol", new Object[0]);
            }
        }
        int retVal = -1;
        double tmpMinVal = this.myPoint.isPhase2() ? -this.options.feasibility.epsilon() : PrimitiveMath.ZERO;
        for (int e = 0; e < tmpExcluded.length; ++e) {
            int tmpCol = tmpExcluded[e];
            double tmpVal = this.myTableau.doubleValue(this.getRowObjective(), tmpCol);
            if (!(tmpVal < tmpMinVal)) continue;
            retVal = tmpCol;
            tmpMinVal = tmpVal;
            if (!this.isDebug()) continue;
            this.log("Col: {}\t=>\tReduced Contribution Weight: {}.", tmpCol, tmpVal);
        }
        return retVal;
    }

    int findNextPivotRow() {
        int tmpNumerCol = this.myTableau.countConstraints() + this.myTableau.countVariables();
        int tmpDenomCol = this.myPoint.col;
        if (this.isDebug()) {
            if (this.options.validate) {
                Access1D<Double> tmpNumerators = this.myTableau.sliceTableauColumn(tmpNumerCol);
                Access1D<Double> tmpDenominators = this.myTableau.sliceTableauColumn(tmpDenomCol);
                Structure1D tmpRatios = Array1D.PRIMITIVE64.copy((Access1D)tmpNumerators);
                ((Array1D)tmpRatios).modifyMatching(PrimitiveFunction.DIVIDE, tmpDenominators);
                this.log("\nfindNextPivotRow (smallest positive ratio) among these:\nNumerators={}\nDenominators={}\nRatios={}", tmpNumerators, tmpDenominators, tmpRatios);
            } else {
                this.log("\nfindNextPivotRow", new Object[0]);
            }
        }
        int retVal = -1;
        double tmpNumer = Double.NaN;
        double tmpDenom = Double.NaN;
        double tmpRatio = Double.NaN;
        double tmpMinRatio = Double.MAX_VALUE;
        int tmpConstraintsCount = this.myTableau.countConstraints();
        boolean tmpPhase2 = this.myPoint.isPhase2();
        for (int i = 0; i < tmpConstraintsCount; ++i) {
            boolean tmpSpecialCase = tmpPhase2 && this.myTableau.getBasis(i) < 0;
            tmpDenom = this.myTableau.doubleValue(i, tmpDenomCol);
            tmpNumer = PrimitiveFunction.ABS.invoke(this.myTableau.doubleValue(i, tmpNumerCol));
            tmpRatio = this.options.feasibility.isSmall(tmpNumer, tmpDenom) ? Double.MAX_VALUE : (tmpSpecialCase ? (this.options.feasibility.isSmall(tmpDenom, tmpNumer) ? PrimitiveMath.MACHINE_EPSILON : Double.MAX_VALUE) : tmpNumer / tmpDenom);
            if (!tmpSpecialCase && !(tmpDenom > PrimitiveMath.ZERO) || !(tmpRatio >= PrimitiveMath.ZERO) || !(tmpRatio < tmpMinRatio)) continue;
            retVal = i;
            tmpMinRatio = tmpRatio;
            if (!this.isDebug()) continue;
            this.log("Row: {}\t=>\tRatio: {},\tNumerator/RHS: {}, \tDenominator/Pivot: {}.", i, tmpRatio, tmpNumer, tmpDenom);
        }
        return retVal;
    }

    void performIteration(SimplexTableau.IterationPoint pivot) {
        double tmpPivotElement = this.myTableau.doubleValue(pivot.row, pivot.col);
        int tmpColRHS = this.myTableau.countConstraints() + this.myTableau.countVariables();
        double tmpPivotRHS = this.myTableau.doubleValue(pivot.row, tmpColRHS);
        this.myTableau.pivot(pivot);
        if (this.isDebug()) {
            this.log("Iteration Point <{},{}>\tPivot: {} => {}\tRHS: {} => {}.", pivot.row, pivot.col, tmpPivotElement, this.myTableau.doubleValue(pivot.row, pivot.col), tmpPivotRHS, this.myTableau.doubleValue(pivot.row, tmpColRHS));
        }
        if (this.options.validate) {
            Array1D<Double> tmpRHS = this.myTableau.sliceConstraintsRHS();
            AggregatorFunction<Double> tmpMinAggr = PrimitiveAggregator.getSet().minimum();
            tmpRHS.visitAll(tmpMinAggr);
            double tmpMinVal = tmpMinAggr.doubleValue();
            if (tmpMinVal < PrimitiveMath.ZERO && !this.options.feasibility.isZero(tmpMinVal)) {
                this.log("\nNegative RHS! {}", tmpMinVal);
                if (this.isDebug()) {
                    this.log("Entire RHS columns: {}\n", tmpRHS);
                }
            }
        }
    }

    static interface AlgorithmStore {
    }
}

