/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.net.URL;
import java.util.Hashtable;

public abstract class MenuItemDiverter
implements KeyListener,
PlugIn,
WindowFocusListener {
    protected static ImageJ ij;
    protected static Cursor cursor;
    protected static Cursor diversionCursor;
    protected static Hashtable actions;

    protected abstract String getTitle();

    protected abstract void action(String var1);

    protected URL getCursorPath() {
        return this.getClass().getResource("/help-cursor.gif");
    }

    public void run(String arg) {
        if (arg == null || arg.equals("")) {
            this.setActions();
        } else {
            this.resetActions();
            this.action(arg);
        }
    }

    protected String getAction(Object key) {
        return this.getClass().getName() + "(\"" + key + "\")";
    }

    public void setActions() {
        ij = IJ.getInstance();
        if (ij == null) {
            return;
        }
        actions = new Hashtable();
        Hashtable table = Menus.getCommands();
        if (table.size() == 0) {
            IJ.error((String)"No menu items found!");
            return;
        }
        if (!"ij.plugin.Commands(\"quit\")".equals(table.get("Quit"))) {
            IJ.error((String)"Cannot install another menu item diverter!");
            return;
        }
        for (Object key : table.keySet()) {
            actions.put(key, table.get(key));
            table.put(key, this.getAction(key));
        }
        cursor = ij.getCursor();
        if (diversionCursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            URL url = this.getCursorPath();
            Image diversion = toolkit.getImage(url);
            Point hotSpot = new Point(6, 7);
            diversionCursor = toolkit.createCustomCursor(diversion, hotSpot, "cursor-" + this.getTitle().replace(' ', '-'));
        }
        ij.setCursor(diversionCursor);
        ij.addKeyListener((KeyListener)this);
        for (Component component : ij.getComponents()) {
            component.addKeyListener(this);
        }
        ij.addWindowFocusListener((WindowFocusListener)this);
        IJ.showStatus((String)("Click menu entry for " + this.getTitle() + " (Esc to abort)"));
    }

    public void resetActions() {
        if (actions == null) {
            return;
        }
        Hashtable table = Menus.getCommands();
        for (Object key : table.keySet()) {
            if (!table.get(key).equals(this.getAction(key))) continue;
            table.put(key, actions.get(key));
        }
        actions = null;
        ij.setCursor(cursor);
        ij.removeKeyListener((KeyListener)this);
        for (Component component : ij.getComponents()) {
            component.removeKeyListener(this);
        }
        ij.removeWindowFocusListener((WindowFocusListener)this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.resetActions();
            IJ.showStatus((String)(this.getTitle() + " aborted"));
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.resetActions();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }
}

