/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.formats.APNGFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.services.OMEMetadataService;
import io.scif.ome.translators.FromOMETranslator;
import io.scif.ome.translators.ToOMETranslator;
import io.scif.util.FormatTools;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Time;
import org.scijava.plugin.Plugin;

public class APNGTranslator {

    @Plugin(type=ToOMETranslator.class, priority=100.0)
    public static class APNGOMETranslator
    extends ToOMETranslator<APNGFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return APNGFormat.Metadata.class;
        }

        public Class<? extends Metadata> dest() {
            return OMEMetadata.class;
        }

        protected void translateFormatMetadata(APNGFormat.Metadata source, OMEMetadata dest) {
            int sizeC = 1;
            switch (source.getIhdr().getColourType()) {
                case 2: {
                    sizeC = 3;
                    break;
                }
                case 4: {
                    sizeC = 2;
                    break;
                }
                case 6: {
                    sizeC = 4;
                    break;
                }
            }
            String dimOrder = "XYCTZ";
            int sizeX = source.getIhdr().getWidth();
            int sizeY = source.getIhdr().getHeight();
            int sizeT = source.getActl() == null ? 1 : source.getActl().getNumFrames();
            boolean sizeZ = true;
            String pixelType = null;
            try {
                pixelType = FormatTools.getPixelTypeString((int)FormatTools.pixelTypeFromBytes((int)(source.getIhdr().getBitDepth() / 8), (boolean)false, (boolean)false));
            }
            catch (FormatException e) {
                this.log().debug((Object)("Failed to find pixel type from bytes: " + source.getIhdr().getBitDepth() / 8), (Throwable)e);
            }
            boolean littleEndian = false;
            boolean series = false;
            boolean samplesPerPixel = true;
            String imageName = "";
            ((OMEMetadataService)this.getContext().getService(OMEMetadataService.class)).populateMetadata((MetadataStore)dest.getRoot(), 0, "", false, "XYCTZ", pixelType, sizeX, sizeY, 1, sizeC, sizeT, 1.0, 1.0, 1.0, 1.0, 1.0, 1);
            if (source.getFctl() != null && !source.getFctl().isEmpty()) {
                short delayNum = ((APNGFormat.FCTLChunk)source.getFctl().get(0)).getDelayNum();
                short delayDen = ((APNGFormat.FCTLChunk)source.getFctl().get(0)).getDelayDen();
                double timeIncrement = (double)delayNum / (double)delayDen;
                dest.getRoot().setPixelsTimeIncrement(new Time((Number)timeIncrement, UNITS.SECOND), 0);
            }
        }
    }

    @Plugin(type=FromOMETranslator.class, priority=100.0)
    public static class OMEAPNGTranslator
    extends FromOMETranslator<APNGFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return OMEMetadata.class;
        }

        public Class<? extends Metadata> dest() {
            return APNGFormat.Metadata.class;
        }

        protected void translateFormatMetadata(OMEMetadata source, APNGFormat.Metadata dest) {
            if (dest.getFctl() != null && !dest.getFctl().isEmpty()) {
                Time timeIncrement = source.getRoot().getPixelsTimeIncrement(0);
                short tIncrement = timeIncrement == null ? (short)1 : timeIncrement.value().shortValue();
                ((APNGFormat.FCTLChunk)dest.getFctl().get(0)).setDelayNum(tIncrement);
                ((APNGFormat.FCTLChunk)dest.getFctl().get(0)).setDelayDen((short)1);
            }
        }
    }
}

