/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;

public class StackedRealTransform
implements RealTransform {
    private final int nSourceDims;
    private final int nTargetDims;
    private final RealTransform[] transforms;
    protected double[] tmpSrc;
    protected double[] tmpTgt;

    public StackedRealTransform(RealTransform ... transforms) {
        this.transforms = transforms;
        int ns = 0;
        int nt = 0;
        int maxDim = -1;
        for (RealTransform t : transforms) {
            maxDim = (ns += t.numSourceDimensions()) > maxDim ? ns : maxDim;
            maxDim = nt > maxDim ? (nt += t.numTargetDimensions()) : maxDim;
        }
        this.tmpSrc = new double[maxDim];
        this.tmpTgt = new double[maxDim];
        this.nSourceDims = ns;
        this.nTargetDims = nt;
    }

    public int numSourceDimensions() {
        return this.nSourceDims;
    }

    public int numTargetDimensions() {
        return this.nTargetDims;
    }

    public void apply(double[] source, double[] target) {
        int startSrc = 0;
        int startTgt = 0;
        for (RealTransform t : this.transforms) {
            System.arraycopy(source, startSrc, this.tmpSrc, 0, t.numSourceDimensions());
            t.apply(this.tmpSrc, this.tmpTgt);
            System.arraycopy(this.tmpTgt, 0, target, startTgt, t.numTargetDimensions());
            startSrc += t.numSourceDimensions();
            startTgt += t.numTargetDimensions();
        }
    }

    protected void localizeFromIndex(RealLocalizable pt, double[] arr, int start, int N) {
        for (int j = 0; j < N; ++j) {
            arr[j] = pt.getDoublePosition(start + j);
        }
    }

    protected void positionFromIndex(RealPositionable pt, double[] arr, int start, int N) {
        for (int j = 0; j < N; ++j) {
            pt.setPosition(arr[j], start + j);
        }
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        int startSrc = 0;
        int startTgt = 0;
        for (RealTransform t : this.transforms) {
            this.localizeFromIndex(source, this.tmpSrc, startSrc, t.numSourceDimensions());
            t.apply(this.tmpSrc, this.tmpTgt);
            this.positionFromIndex(target, this.tmpTgt, startTgt, t.numTargetDimensions());
            startSrc += t.numSourceDimensions();
            startTgt += t.numTargetDimensions();
        }
    }

    public RealTransform copy() {
        return new StackedRealTransform((RealTransform[])Arrays.stream(this.transforms).map(RealTransform::copy).toArray(RealTransform[]::new));
    }
}

