/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class Find_PointRoi
implements PlugIn {
    public void run(String arg) {
        try {
            ImagePlus imp = IJ.getImage();
            PointRoi roi = (PointRoi)imp.getRoi();
            int[] x = roi.getXCoordinates();
            int[] y = roi.getYCoordinates();
            GenericDialog gd = new GenericDialog("Find PointRoi");
            gd.addNumericField("index :", 1.0, 0);
            gd.showDialog();
            if (gd.wasCanceled()) {
                imp.getCanvas().setDisplayList(null, null, null);
                return;
            }
            int index = (int)gd.getNextNumber();
            Rectangle boundingBox = roi.getBounds();
            int w = (int)(16.0 / imp.getCanvas().getMagnification() + 0.5);
            imp.getCanvas().setDisplayList((Shape)new Ellipse2D.Float(boundingBox.x + x[index - 1] - w, boundingBox.y + y[index - 1] - w, 2 * w, 2 * w), Toolbar.getForegroundColor(), new BasicStroke(3.0f));
        }
        catch (Throwable e) {
            IJ.error((String)"No PointRoi found.");
        }
    }
}

