/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.restructure;

import java.util.ArrayList;
import java.util.Map;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.plugins.commands.restructure.ColorTableRemapper;
import net.imagej.plugins.commands.restructure.RestructureUtils;
import net.imagej.space.SpaceUtils;
import net.imagej.space.TypedSpace;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.log.LogService;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Data", mnemonic=100), @Menu(label="Reorder Data...")}, headless=true, initializer="initAxes", attrs={@Attr(name="no-legacy")})
public class ReorderData
extends DynamicCommand {
    @Parameter
    private LogService log;
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    private int[] permutationAxisIndices;
    private AxisType[] desiredAxisOrder;

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public void setNewAxisIndex(int index, int fromPosition) {
        AxisType axis = ((CalibratedAxis)this.dataset.axis(fromPosition)).type();
        this.setInput(this.name(index), axis.getLabel());
    }

    public int getNewAxisIndex(int index) {
        String axisName = (String)this.getInput(this.name(index));
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            if (!axisName.equals(((CalibratedAxis)this.dataset.axis(i)).toString())) continue;
            return i;
        }
        throw new IllegalArgumentException("axis " + index + " not found");
    }

    public void run() {
        if (this.dataset == null) {
            return;
        }
        String[] axisNames = this.getAxisNamesInOrder();
        this.setupDesiredAxisOrder(axisNames);
        if (this.inputBad()) {
            return;
        }
        this.setupPermutationVars();
        ImgPlus<? extends RealType<?>> newImgPlus = this.getReorganizedData();
        RestructureUtils.allocateColorTables(newImgPlus);
        ColorTableRemapper remapper = new ColorTableRemapper(new RemapAlgorithm());
        remapper.remapColorTables(this.dataset.getImgPlus(), newImgPlus);
        int count = this.dataset.getCompositeChannelCount();
        this.dataset.setImgPlus(newImgPlus);
        this.dataset.setCompositeChannelCount(count);
    }

    protected void initAxes() {
        int i;
        ArrayList<String> choices = new ArrayList<String>();
        for (i = 0; i < this.dataset.numDimensions(); ++i) {
            choices.add(((CalibratedAxis)this.dataset.axis(i)).type().getLabel());
        }
        for (i = 0; i < this.dataset.numDimensions(); ++i) {
            DefaultMutableModuleItem axisItem = new DefaultMutableModuleItem((Module)this, this.name(i), String.class);
            axisItem.setChoices(choices);
            axisItem.setPersisted(false);
            axisItem.setValue((Module)this, (Object)((CalibratedAxis)this.dataset.axis(i)).type().getLabel());
            this.addInput((ModuleItem)axisItem);
        }
    }

    private String name(int i) {
        return "Axis #" + i;
    }

    private String[] getAxisNamesInOrder() {
        Map inputs = this.getInputs();
        String[] axisNames = new String[this.dataset.getImgPlus().numDimensions()];
        for (int i = 0; i < axisNames.length; ++i) {
            axisNames[i] = (String)inputs.get(this.name(i));
        }
        return axisNames;
    }

    private void setupDesiredAxisOrder(String[] axisNames) {
        this.desiredAxisOrder = new AxisType[axisNames.length];
        for (int i = 0; i < axisNames.length; ++i) {
            this.desiredAxisOrder[i] = Axes.get((String)axisNames[i]);
        }
    }

    private boolean inputBad() {
        for (int i = 0; i < this.desiredAxisOrder.length; ++i) {
            for (int j = i + 1; j < this.desiredAxisOrder.length; ++j) {
                if (this.desiredAxisOrder[i] != this.desiredAxisOrder[j]) continue;
                this.log.error((Object)"at least one axis preference is repeated: axis preferences must be mututally exclusive");
                return true;
            }
        }
        return false;
    }

    private AxisType[] getPermutedAxes(AxisType[] currAxes) {
        AxisType[] permuted = new AxisType[currAxes.length];
        int index = 0;
        block0: for (int i = 0; i < this.desiredAxisOrder.length; ++i) {
            for (int j = 0; j < currAxes.length; ++j) {
                if (currAxes[j] != this.desiredAxisOrder[i]) continue;
                permuted[index++] = currAxes[j];
                continue block0;
            }
        }
        return permuted;
    }

    private void setupPermutationVars() {
        AxisType[] currAxes = SpaceUtils.getAxisTypes((TypedSpace)this.dataset);
        AxisType[] permutedAxes = this.getPermutedAxes(currAxes);
        this.permutationAxisIndices = new int[currAxes.length];
        for (int i = 0; i < currAxes.length; ++i) {
            int newIndex;
            AxisType axis = currAxes[i];
            this.permutationAxisIndices[i] = newIndex = this.getNewAxisIndex(permutedAxes, axis);
        }
    }

    private ImgPlus<? extends RealType<?>> getReorganizedData() {
        RandomAccess inputAccessor = this.dataset.getImgPlus().randomAccess();
        long[] inputSpan = new long[this.dataset.getImgPlus().numDimensions()];
        this.dataset.getImgPlus().dimensions(inputSpan);
        HyperVolumePointSet volume = new HyperVolumePointSet(inputSpan);
        PointSetIterator iter = volume.iterator();
        long[] origDims = Intervals.dimensionsAsLongArray((Dimensions)this.dataset);
        AxisType[] origAxes = SpaceUtils.getAxisTypes((TypedSpace)this.dataset);
        long[] newDims = this.getNewDims(origDims);
        AxisType[] newAxes = this.getNewAxes(origAxes);
        ImgPlus<? extends RealType<?>> newImgPlus = RestructureUtils.createNewImgPlus(this.dataset, newDims, newAxes);
        newImgPlus.setCompositeChannelCount(this.dataset.getCompositeChannelCount());
        RandomAccess outputAccessor = newImgPlus.randomAccess();
        long[] permutedPos = new long[inputSpan.length];
        while (iter.hasNext()) {
            long[] currPos = (long[])iter.next();
            inputAccessor.setPosition(currPos);
            double value = ((RealType)inputAccessor.get()).getRealDouble();
            this.permute(currPos, permutedPos);
            outputAccessor.setPosition(permutedPos);
            ((RealType)outputAccessor.get()).setReal(value);
        }
        return newImgPlus;
    }

    private int getNewAxisIndex(AxisType[] permutedAxes, AxisType originalAxis) {
        for (int i = 0; i < permutedAxes.length; ++i) {
            if (permutedAxes[i] != originalAxis) continue;
            return i;
        }
        throw new IllegalArgumentException("axis not found!");
    }

    private long[] getNewDims(long[] origDims) {
        long[] newDims = new long[origDims.length];
        this.permute(origDims, newDims);
        return newDims;
    }

    private AxisType[] getNewAxes(AxisType[] origAxes) {
        AxisType[] newAxes = new AxisType[origAxes.length];
        this.permute(origAxes, newAxes);
        return newAxes;
    }

    private void permute(long[] origPos, long[] permutedPos) {
        for (int i = 0; i < origPos.length; ++i) {
            permutedPos[this.permutationAxisIndices[i]] = origPos[i];
        }
    }

    private void permute(AxisType[] origAxes, AxisType[] permutedAxes) {
        for (int i = 0; i < origAxes.length; ++i) {
            permutedAxes[this.permutationAxisIndices[i]] = origAxes[i];
        }
    }

    private class RemapAlgorithm
    implements ColorTableRemapper.RemapAlgorithm {
        private final long[] inputPos;
        private final long[] outputPos;

        private RemapAlgorithm() {
            this.inputPos = new long[ReorderData.this.permutationAxisIndices.length];
            this.outputPos = new long[ReorderData.this.permutationAxisIndices.length];
        }

        @Override
        public boolean isValidSourcePlane(long i) {
            return true;
        }

        @Override
        public void remapPlanePosition(long[] origPlaneDims, long[] origPlanePos, long[] newPlanePos) {
            int i;
            this.inputPos[0] = 0L;
            this.inputPos[1] = 0L;
            for (i = 0; i < origPlanePos.length; ++i) {
                this.inputPos[2 + i] = origPlanePos[i];
            }
            ReorderData.this.permute(this.inputPos, this.outputPos);
            for (i = 0; i < newPlanePos.length; ++i) {
                newPlanePos[i] = this.outputPos[i + 2];
            }
        }
    }
}

