/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.Frame;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class RecomputeFeatureAction
extends AbstractTMAction {
    public static final String NAME = "Recompute all features";
    public static final String KEY = "RECOMPUTE_FEATURES";
    public static final String INFO_TEXT = "<html>Calling this action causes the model to recompute all the features values for all spots, edges and tracks. All the feature analyzers discovered when running this action are added and computed. </html>";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        RecomputeFeatureAction.recompute(trackmate, this.logger);
    }

    public static void recompute(TrackMate trackmate, Logger logger) {
        logger.log("Recalculating all features.\n");
        Model model = trackmate.getModel();
        Logger oldLogger = model.getLogger();
        model.setLogger(logger);
        Settings settings = trackmate.getSettings();
        double dt = 0.0;
        if (null != settings && null != settings.imp && null != settings.imp.getCalibration()) {
            dt = settings.imp.getCalibration().frameInterval;
        }
        if (dt <= 0.0 && settings != null) {
            dt = settings.dt;
        }
        if (dt <= 0.0) {
            dt = 1.0;
        }
        settings.dt = dt;
        for (Spot spot : model.getSpots().iterable(false)) {
            spot.putFeature("POSITION_T", (double)spot.getFeature("FRAME").intValue() * dt);
        }
        settings.addAllAnalyzers();
        trackmate.computeSpotFeatures(true);
        trackmate.computeEdgeFeatures(true);
        trackmate.computeTrackFeatures(true);
        model.setLogger(oldLogger);
        logger.log("Done.\n");
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return RecomputeFeatureAction.INFO_TEXT;
        }

        @Override
        public String getName() {
            return RecomputeFeatureAction.NAME;
        }

        @Override
        public String getKey() {
            return RecomputeFeatureAction.KEY;
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.CALCULATOR_ICON;
        }

        @Override
        public TrackMateAction create() {
            return new RecomputeFeatureAction();
        }
    }
}

