/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.ManualDetectorConfigurationPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class ManualDetectorFactory<T extends RealType<T> & NativeType<T>>
implements SpotDetectorFactory<T> {
    public static final String DETECTOR_KEY = "MANUAL_DETECTOR";
    public static final String NAME = "Manual annotation";
    public static final String INFO_TEXT = "<html>Selecting this will skip the automatic detection phase, and jump directly <br>to manual segmentation. A default spot size will be asked for. </html>";
    protected String errorMessage;
    protected Map<String, Object> settings;

    @Override
    public boolean has2Dsegmentation() {
        return true;
    }

    @Override
    public SpotDetector<T> getDetector(Interval interval, int frame) {
        return new SpotDetector<T>(){

            public List<Spot> getResult() {
                return Collections.emptyList();
            }

            public boolean checkInput() {
                return true;
            }

            public boolean process() {
                return true;
            }

            public String getErrorMessage() {
                return null;
            }

            public long getProcessingTime() {
                return 0L;
            }
        };
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean setTarget(ImgPlus<T> img, Map<String, Object> settings) {
        this.settings = settings;
        return this.checkSettings(settings);
    }

    @Override
    public boolean checkSettings(Map<String, Object> lSettings) {
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = true;
        ok &= TMUtils.checkParameter(lSettings, "RADIUS", Double.class, errorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("RADIUS");
        if (!(ok &= TMUtils.checkMapKeys(lSettings, mandatoryKeys, null, errorHolder))) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean marshall(Map<String, Object> lSettings, Element element) {
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = IOUtils.writeRadius(lSettings, element, errorHolder);
        if (!ok) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> lSettings) {
        lSettings.clear();
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = IOUtils.readDoubleAttribute(element, lSettings, "RADIUS", errorHolder);
        if (!ok) {
            this.errorMessage = errorHolder.toString();
            return false;
        }
        return this.checkSettings(lSettings);
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings settings, Model model) {
        return new ManualDetectorConfigurationPanel(INFO_TEXT, NAME);
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("RADIUS", 5.0);
        return lSettings;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public ManualDetectorFactory<T> copy() {
        return new ManualDetectorFactory<T>();
    }
}

