/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard;

public class AbstractAnimator {
    private final long duration;
    private long startTime;
    private boolean started;
    private double complete;

    public AbstractAnimator(long duration) {
        this.duration = duration;
        this.started = false;
        this.complete = 0.0;
    }

    private double cos(double t) {
        return 0.5 - 0.5 * Math.cos(Math.PI * t);
    }

    public void setTime(long time) {
        if (!this.started) {
            this.started = true;
            this.startTime = time;
        }
        this.complete = (double)(time - this.startTime) / (double)this.duration;
        this.complete = this.complete >= 1.0 ? 1.0 : this.cos(this.cos(this.complete));
    }

    public boolean isComplete() {
        return this.complete == 1.0;
    }

    public double ratioComplete() {
        return this.complete;
    }
}

