/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.ExportAllSpotsStatsAction;
import fiji.plugin.trackmate.action.ExportStatsTablesAction;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.ModelFeatureUpdater;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.FeatureDisplaySelector;
import fiji.plugin.trackmate.gui.components.LogPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.gui.wizard.WizardSequence;
import fiji.plugin.trackmate.gui.wizard.descriptors.ActionChooserDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.ChooseDetectorDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.ChooseTrackerDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.ConfigureViewsDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.ExecuteDetectionDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.ExecuteTrackingDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.GrapherDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.InitFilterDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.LogPanelDescriptor2;
import fiji.plugin.trackmate.gui.wizard.descriptors.SaveDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.SpotDetectorDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.SpotFilterDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.SpotTrackerDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.StartDialogDescriptor;
import fiji.plugin.trackmate.gui.wizard.descriptors.TrackFilterDescriptor;
import fiji.plugin.trackmate.providers.ActionProvider;
import fiji.plugin.trackmate.providers.DetectorProvider;
import fiji.plugin.trackmate.providers.TrackerProvider;
import fiji.plugin.trackmate.tracking.SpotImageTrackerFactory;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.util.Threads;
import fiji.plugin.trackmate.visualization.trackscheme.SpotImageUpdater;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;

public class TrackMateWizardSequence
implements WizardSequence {
    private final TrackMate trackmate;
    private final SelectionModel selectionModel;
    private final DisplaySettings displaySettings;
    private WizardPanelDescriptor current;
    private final StartDialogDescriptor startDialogDescriptor;
    private final Map<WizardPanelDescriptor, WizardPanelDescriptor> next;
    private final Map<WizardPanelDescriptor, WizardPanelDescriptor> previous;
    private final LogPanelDescriptor2 logDescriptor;
    private final ChooseDetectorDescriptor chooseDetectorDescriptor;
    private final ExecuteDetectionDescriptor executeDetectionDescriptor;
    private final InitFilterDescriptor initFilterDescriptor;
    private final SpotFilterDescriptor spotFilterDescriptor;
    private final ChooseTrackerDescriptor chooseTrackerDescriptor;
    private final ExecuteTrackingDescriptor executeTrackingDescriptor;
    private final TrackFilterDescriptor trackFilterDescriptor;
    private final ConfigureViewsDescriptor configureViewsDescriptor;
    private final GrapherDescriptor grapherDescriptor;
    private final ActionChooserDescriptor actionChooserDescriptor;
    private final SaveDescriptor saveDescriptor;
    private static final String TRACK_TABLES_BUTTON_TOOLTIP = "<html>Export the features of all tracks, edges and all <br>spots belonging to a track to ImageJ tables.</html>";
    private static final String SPOT_TABLE_BUTTON_TOOLTIP = "Export the features of all spots to ImageJ tables.";
    private static final String TRACKSCHEME_BUTTON_TOOLTIP = "<html>Launch a new instance of TrackScheme.</html>";

    public TrackMateWizardSequence(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings) {
        this.trackmate = trackmate;
        this.selectionModel = selectionModel;
        this.displaySettings = displaySettings;
        Settings settings = trackmate.getSettings();
        Model model = trackmate.getModel();
        ModelFeatureUpdater modelFeatureUpdater = new ModelFeatureUpdater(model, settings);
        modelFeatureUpdater.setNumThreads(trackmate.getNumThreads());
        LogPanel logPanel = new LogPanel();
        Logger logger = logPanel.getLogger();
        model.setLogger(logger);
        FeatureDisplaySelector featureSelector = new FeatureDisplaySelector(model, settings, displaySettings);
        FeatureFilter initialFilter = new FeatureFilter("QUALITY", settings.initialSpotFilterValue, true);
        List<FeatureFilter> spotFilters = settings.getSpotFilters();
        List<FeatureFilter> trackFilters = settings.getTrackFilters();
        this.logDescriptor = new LogPanelDescriptor2(logPanel);
        this.startDialogDescriptor = new StartDialogDescriptor(settings, logger);
        this.chooseDetectorDescriptor = new ChooseDetectorDescriptor(new DetectorProvider(), trackmate);
        this.executeDetectionDescriptor = new ExecuteDetectionDescriptor(trackmate, logPanel);
        this.initFilterDescriptor = new InitFilterDescriptor(trackmate, initialFilter);
        this.spotFilterDescriptor = new SpotFilterDescriptor(trackmate, spotFilters, featureSelector);
        this.chooseTrackerDescriptor = new ChooseTrackerDescriptor(new TrackerProvider(), trackmate);
        this.executeTrackingDescriptor = new ExecuteTrackingDescriptor(trackmate, logPanel);
        this.trackFilterDescriptor = new TrackFilterDescriptor(trackmate, trackFilters, featureSelector);
        this.configureViewsDescriptor = new ConfigureViewsDescriptor(displaySettings, featureSelector, new LaunchTrackSchemeAction(), new ShowTrackTablesAction(), new ShowSpotTableAction(), model.getSpaceUnits());
        this.grapherDescriptor = new GrapherDescriptor(trackmate, selectionModel, displaySettings);
        this.actionChooserDescriptor = new ActionChooserDescriptor(new ActionProvider(), trackmate, selectionModel, displaySettings);
        this.saveDescriptor = new SaveDescriptor(trackmate, displaySettings, this);
        this.next = this.getForwardSequence();
        this.previous = this.getBackwardSequence();
        this.current = this.startDialogDescriptor;
    }

    @Override
    public void onClose() {
        this.trackmate.getModel().setLogger(Logger.IJ_LOGGER);
    }

    @Override
    public WizardPanelDescriptor next() {
        if (this.current == this.chooseDetectorDescriptor) {
            this.getDetectorConfigDescriptor();
        }
        if (this.current == this.chooseTrackerDescriptor) {
            this.getTrackerConfigDescriptor();
        }
        this.current = this.next.get(this.current);
        return this.current;
    }

    @Override
    public WizardPanelDescriptor previous() {
        if (this.current == this.trackFilterDescriptor) {
            this.getTrackerConfigDescriptor();
        }
        if (this.current == this.spotFilterDescriptor) {
            this.getDetectorConfigDescriptor();
        }
        this.current = this.previous.get(this.current);
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.current != this.actionChooserDescriptor;
    }

    @Override
    public WizardPanelDescriptor current() {
        return this.current;
    }

    @Override
    public WizardPanelDescriptor logDescriptor() {
        return this.logDescriptor;
    }

    @Override
    public WizardPanelDescriptor configDescriptor() {
        return this.configureViewsDescriptor;
    }

    @Override
    public WizardPanelDescriptor save() {
        return this.saveDescriptor;
    }

    @Override
    public boolean hasPrevious() {
        return this.current != this.startDialogDescriptor;
    }

    private Map<WizardPanelDescriptor, WizardPanelDescriptor> getBackwardSequence() {
        HashMap<WizardPanelDescriptor, WizardPanelDescriptor> map = new HashMap<WizardPanelDescriptor, WizardPanelDescriptor>();
        map.put(this.startDialogDescriptor, null);
        map.put(this.chooseDetectorDescriptor, this.startDialogDescriptor);
        map.put(this.chooseTrackerDescriptor, this.spotFilterDescriptor);
        map.put(this.configureViewsDescriptor, this.trackFilterDescriptor);
        map.put(this.grapherDescriptor, this.configureViewsDescriptor);
        map.put(this.actionChooserDescriptor, this.grapherDescriptor);
        return map;
    }

    private Map<WizardPanelDescriptor, WizardPanelDescriptor> getForwardSequence() {
        HashMap<WizardPanelDescriptor, WizardPanelDescriptor> map = new HashMap<WizardPanelDescriptor, WizardPanelDescriptor>();
        map.put(this.startDialogDescriptor, this.chooseDetectorDescriptor);
        map.put(this.executeDetectionDescriptor, this.initFilterDescriptor);
        map.put(this.initFilterDescriptor, this.spotFilterDescriptor);
        map.put(this.spotFilterDescriptor, this.chooseTrackerDescriptor);
        map.put(this.executeTrackingDescriptor, this.trackFilterDescriptor);
        map.put(this.trackFilterDescriptor, this.configureViewsDescriptor);
        map.put(this.configureViewsDescriptor, this.grapherDescriptor);
        map.put(this.grapherDescriptor, this.actionChooserDescriptor);
        return map;
    }

    @Override
    public void setCurrent(String panelIdentifier) {
        if (panelIdentifier.equals("ConfigureDetector")) {
            this.current = this.getDetectorConfigDescriptor();
            return;
        }
        if (panelIdentifier.equals("ConfigureTracker")) {
            this.current = this.getTrackerConfigDescriptor();
            return;
        }
        if (panelIdentifier.equals("InitialFiltering")) {
            this.getDetectorConfigDescriptor();
            this.current = this.initFilterDescriptor;
            return;
        }
        List<WizardPanelDescriptor> descriptors = Arrays.asList(this.logDescriptor, this.chooseDetectorDescriptor, this.executeDetectionDescriptor, this.initFilterDescriptor, this.spotFilterDescriptor, this.chooseTrackerDescriptor, this.executeTrackingDescriptor, this.trackFilterDescriptor, this.configureViewsDescriptor, this.grapherDescriptor, this.actionChooserDescriptor, this.saveDescriptor);
        for (WizardPanelDescriptor w : descriptors) {
            if (!w.getPanelDescriptorIdentifier().equals(panelIdentifier)) continue;
            this.current = w;
            break;
        }
    }

    private SpotDetectorDescriptor getDetectorConfigDescriptor() {
        SpotDetectorFactoryBase<?> detectorFactory = this.trackmate.getSettings().detectorFactory;
        if (detectorFactory.getKey().equals("MANUAL_DETECTOR")) {
            this.next.put(this.chooseDetectorDescriptor, this.spotFilterDescriptor);
            this.previous.put(this.spotFilterDescriptor, this.chooseDetectorDescriptor);
            this.previous.put(this.executeDetectionDescriptor, this.chooseDetectorDescriptor);
            this.previous.put(this.initFilterDescriptor, this.chooseDetectorDescriptor);
            return null;
        }
        HashMap<String, Object> oldSettings1 = new HashMap<String, Object>(this.trackmate.getSettings().detectorSettings);
        HashMap<String, Object> oldSettings2 = new HashMap<String, Object>();
        WizardPanelDescriptor previousDescriptor = this.next.get(this.chooseDetectorDescriptor);
        if (previousDescriptor != null && previousDescriptor instanceof SpotDetectorDescriptor) {
            SpotDetectorDescriptor previousSpotDetectorDescriptor = (SpotDetectorDescriptor)previousDescriptor;
            ConfigurationPanel detectorConfigPanel = (ConfigurationPanel)previousSpotDetectorDescriptor.targetPanel;
            oldSettings2.putAll(detectorConfigPanel.getSettings());
        }
        Map<String, Object> defaultSettings = detectorFactory.getDefaultSettings();
        for (String skey : defaultSettings.keySet()) {
            Object previousValue = oldSettings2.get(skey);
            if (previousValue == null) {
                previousValue = oldSettings1.get(skey);
            }
            defaultSettings.put(skey, previousValue);
        }
        ConfigurationPanel detectorConfigurationPanel = detectorFactory.getDetectorConfigurationPanel(this.trackmate.getSettings(), this.trackmate.getModel());
        detectorConfigurationPanel.setSettings(defaultSettings);
        this.trackmate.getSettings().detectorSettings = defaultSettings;
        SpotDetectorDescriptor configDescriptor = new SpotDetectorDescriptor(this.trackmate.getSettings(), detectorConfigurationPanel, this.trackmate.getModel().getLogger());
        this.next.put(this.chooseDetectorDescriptor, configDescriptor);
        this.next.put(configDescriptor, this.executeDetectionDescriptor);
        this.previous.put(configDescriptor, this.chooseDetectorDescriptor);
        this.previous.put(this.executeDetectionDescriptor, configDescriptor);
        this.previous.put(this.initFilterDescriptor, configDescriptor);
        this.previous.put(this.spotFilterDescriptor, configDescriptor);
        return configDescriptor;
    }

    private SpotTrackerDescriptor getTrackerConfigDescriptor() {
        SpotTrackerFactory trackerFactory = this.trackmate.getSettings().trackerFactory;
        if (trackerFactory.getKey().equals("MANUAL_TRACKER")) {
            this.next.put(this.chooseTrackerDescriptor, this.trackFilterDescriptor);
            this.previous.put(this.executeTrackingDescriptor, this.chooseTrackerDescriptor);
            this.previous.put(this.trackFilterDescriptor, this.chooseTrackerDescriptor);
            return null;
        }
        HashMap<String, Object> oldSettings1 = new HashMap<String, Object>(this.trackmate.getSettings().trackerSettings);
        HashMap<String, Object> oldSettings2 = new HashMap<String, Object>();
        WizardPanelDescriptor previousDescriptor = this.next.get(this.chooseTrackerDescriptor);
        if (previousDescriptor != null && previousDescriptor instanceof SpotTrackerDescriptor) {
            SpotTrackerDescriptor previousTrackerDetectorDescriptor = (SpotTrackerDescriptor)previousDescriptor;
            ConfigurationPanel detectorConfigPanel = (ConfigurationPanel)previousTrackerDetectorDescriptor.targetPanel;
            oldSettings2.putAll(detectorConfigPanel.getSettings());
        }
        Map<String, Object> defaultSettings = trackerFactory.getDefaultSettings();
        for (String skey : defaultSettings.keySet()) {
            Object previousValue = oldSettings2.get(skey);
            if (previousValue == null) {
                previousValue = oldSettings1.get(skey);
            }
            defaultSettings.put(skey, previousValue);
        }
        ConfigurationPanel trackerConfigurationPanel = trackerFactory instanceof SpotImageTrackerFactory ? ((SpotImageTrackerFactory)trackerFactory).getTrackerConfigurationPanel(this.trackmate.getModel(), this.trackmate.getSettings().imp) : trackerFactory.getTrackerConfigurationPanel(this.trackmate.getModel());
        trackerConfigurationPanel.setSettings(defaultSettings);
        this.trackmate.getSettings().trackerSettings = defaultSettings;
        SpotTrackerDescriptor configDescriptor = new SpotTrackerDescriptor(this.trackmate.getSettings(), trackerConfigurationPanel, this.trackmate.getModel().getLogger());
        this.next.put(this.chooseTrackerDescriptor, configDescriptor);
        this.next.put(configDescriptor, this.executeTrackingDescriptor);
        this.previous.put(configDescriptor, this.chooseTrackerDescriptor);
        this.previous.put(this.executeTrackingDescriptor, configDescriptor);
        this.previous.put(this.trackFilterDescriptor, configDescriptor);
        return configDescriptor;
    }

    private void showTables(boolean showSpotTable) {
        Threads.run("TrackMate table thread.", () -> {
            AbstractTMAction action = showSpotTable ? new ExportAllSpotsStatsAction() : new ExportStatsTablesAction();
            action.execute(this.trackmate, this.selectionModel, this.displaySettings, null);
        });
    }

    private class ShowSpotTableAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ShowSpotTableAction() {
            super("Spots", Icons.SPOT_TABLE_ICON);
            this.putValue("ShortDescription", TrackMateWizardSequence.SPOT_TABLE_BUTTON_TOOLTIP);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TrackMateWizardSequence.this.showTables(true);
        }
    }

    private class ShowTrackTablesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ShowTrackTablesAction() {
            super("Tracks", Icons.TRACK_TABLES_ICON);
            this.putValue("ShortDescription", TrackMateWizardSequence.TRACK_TABLES_BUTTON_TOOLTIP);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TrackMateWizardSequence.this.showTables(false);
        }
    }

    private class LaunchTrackSchemeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private LaunchTrackSchemeAction() {
            super("TrackScheme", Icons.TRACK_SCHEME_ICON_16x16);
            this.putValue("ShortDescription", TrackMateWizardSequence.TRACKSCHEME_BUTTON_TOOLTIP);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Threads.run("Launching TrackScheme thread", () -> {
                TrackScheme trackscheme = new TrackScheme(TrackMateWizardSequence.this.trackmate.getModel(), TrackMateWizardSequence.this.selectionModel, TrackMateWizardSequence.this.displaySettings);
                SpotImageUpdater thumbnailUpdater = new SpotImageUpdater(TrackMateWizardSequence.this.trackmate.getSettings());
                trackscheme.setSpotImageUpdater(thumbnailUpdater);
                trackscheme.render();
            });
        }
    }
}

