/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.overlap;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.tracker.OverlapTrackerSettingsPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.tracking.overlap.OverlapTracker;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotTrackerFactory.class)
public class OverlapTrackerFactory
implements SpotTrackerFactory {
    static final String BASE_ERROR_MESSAGE = "[IoUTracker] ";
    public static final String KEY_SCALE_FACTOR = "SCALE_FACTOR";
    public static final Double DEFAULT_SCALE_FACTOR = 1.0;
    public static final String KEY_MIN_IOU = "MIN_IOU";
    public static final Double DEFAULT_MIN_IOU = 0.3;
    public static final String KEY_IOU_CALCULATION = "IOU_CALCULATION";
    public static final String FAST_CALCULATION = OverlapTracker.IoUCalculation.FAST.name();
    public static final String PRECISE_CALCULATION = OverlapTracker.IoUCalculation.PRECISE.name();
    public static final String TRACKER_KEY = "OVERLAP_TRACKER";
    public static final String TRACKER_NAME = "Overlap tracker";
    public static final String TRACKER_INFO_TEXT = "<html> This tracker is a simple extension of the Intersection - over - Union (IoU) tracker. <p> <p> It generates links between spots whose shapes overlap between consecutive frames. When several spots are eligible as a source for a target, the one with the largest IoU is chosen.<p> <p> The minimal IoU parameter sets a threshold below which links won't be created. The scale factor allows for enlarging (&gt;1) or shrinking (&lt;1) the spot shapes before computing their IoU. Two methods can be used to compute IoU: The <it>Fast</it> one approximates  the spot shapes by their rectangular bounding-box. The <it>Precise</it> one uses the actual spot polygon. <p> <p> This tracker works in 2D and 3D. However in 3D, the IoU is computed from the bounding-boxes regardless of the choice of the IoU computation method. The <it>Precise</it> method is not implemented.</html>";
    private String errorMessage;

    @Override
    public String getKey() {
        return TRACKER_KEY;
    }

    @Override
    public String getName() {
        return TRACKER_NAME;
    }

    @Override
    public String getInfoText() {
        return TRACKER_INFO_TEXT;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public SpotTracker create(SpotCollection spots, Map<String, Object> settings) {
        double pixelSize = (Double)settings.get(KEY_SCALE_FACTOR);
        double minIoU = (Double)settings.get(KEY_MIN_IOU);
        String methodStr = (String)settings.get(KEY_IOU_CALCULATION);
        OverlapTracker.IoUCalculation method = OverlapTracker.IoUCalculation.valueOf(methodStr);
        return new OverlapTracker(spots, method, minIoU, pixelSize);
    }

    @Override
    public ConfigurationPanel getTrackerConfigurationPanel(Model model) {
        return new OverlapTrackerSettingsPanel();
    }

    @Override
    public boolean marshall(Map<String, Object> settings, Element element) {
        boolean ok = true;
        StringBuilder str = new StringBuilder();
        ok &= IOUtils.writeAttribute(settings, element, KEY_SCALE_FACTOR, Double.class, str);
        ok &= IOUtils.writeAttribute(settings, element, KEY_MIN_IOU, Double.class, str);
        return ok &= IOUtils.writeAttribute(settings, element, KEY_IOU_CALCULATION, String.class, str);
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> settings) {
        settings.clear();
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = true;
        ok &= IOUtils.readDoubleAttribute(element, settings, KEY_SCALE_FACTOR, errorHolder);
        ok &= IOUtils.readDoubleAttribute(element, settings, KEY_MIN_IOU, errorHolder);
        return ok &= IOUtils.readStringAttribute(element, settings, KEY_IOU_CALCULATION, errorHolder);
    }

    @Override
    public String toString(Map<String, Object> settings) {
        if (!this.checkSettingsValidity(settings)) {
            return this.errorMessage;
        }
        double scale = (Double)settings.get(KEY_SCALE_FACTOR);
        double minIoU = (Double)settings.get(KEY_MIN_IOU);
        String methodStr = (String)settings.get(KEY_IOU_CALCULATION);
        OverlapTracker.IoUCalculation method = OverlapTracker.IoUCalculation.valueOf(methodStr);
        StringBuilder str = new StringBuilder();
        str.append(String.format("  - IoU calculation: %s\n", method.toString()));
        str.append(String.format("  - scale factor: %.2f\n", scale));
        str.append(String.format("  - min. IoU: %.2f\n", minIoU));
        return str.toString();
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put(KEY_IOU_CALCULATION, PRECISE_CALCULATION);
        settings.put(KEY_SCALE_FACTOR, DEFAULT_SCALE_FACTOR);
        settings.put(KEY_MIN_IOU, DEFAULT_MIN_IOU);
        return settings;
    }

    @Override
    public boolean checkSettingsValidity(Map<String, Object> settings) {
        if (null == settings) {
            this.errorMessage = "[IoUTracker] Settings map is null.\n";
            return false;
        }
        boolean ok = true;
        StringBuilder str = new StringBuilder();
        ok &= TMUtils.checkParameter(settings, KEY_SCALE_FACTOR, Double.class, str);
        ok &= TMUtils.checkParameter(settings, KEY_MIN_IOU, Double.class, str);
        if (!(ok &= TMUtils.checkParameter(settings, KEY_IOU_CALCULATION, String.class, str))) {
            this.errorMessage = str.toString();
            return false;
        }
        double scale = (Double)settings.get(KEY_SCALE_FACTOR);
        if (scale <= 0.0) {
            this.errorMessage = "[IoUTracker] Scale factor must be strictly positive, was " + scale;
            return false;
        }
        String methodStr = "";
        try {
            methodStr = (String)settings.get(KEY_IOU_CALCULATION);
            OverlapTracker.IoUCalculation.valueOf(methodStr);
        }
        catch (IllegalArgumentException e) {
            this.errorMessage = "[IoUTracker] Unknown IoU calculation method: " + methodStr;
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public OverlapTrackerFactory copy() {
        return new OverlapTrackerFactory();
    }
}

