/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import fiji.plugin.trackmate.visualization.PerEdgeFeatureColorGenerator;
import java.awt.Color;
import java.util.Set;
import org.jgrapht.graph.DefaultWeightedEdge;

public class SpotColorGeneratorPerEdgeFeature
implements FeatureColorGenerator<Spot> {
    private final Model model;
    private final Color missingValueColor;
    private final PerEdgeFeatureColorGenerator colorGenerator;

    public SpotColorGeneratorPerEdgeFeature(Model model, String edgeFeature, Color missingValueColor, Color undefinedValueColor, Colormap colormap, double min, double max) {
        this.model = model;
        this.missingValueColor = missingValueColor;
        this.colorGenerator = new PerEdgeFeatureColorGenerator(model, edgeFeature, missingValueColor, undefinedValueColor, colormap, min, max);
    }

    @Override
    public Color color(Spot spot) {
        Set<DefaultWeightedEdge> edges = this.model.getTrackModel().edgesOf(spot);
        DefaultWeightedEdge edge = null;
        for (DefaultWeightedEdge e : edges) {
            if (!this.model.getTrackModel().getEdgeTarget(e).equals(spot)) continue;
            edge = e;
            break;
        }
        if (edge == null) {
            return this.missingValueColor;
        }
        return this.colorGenerator.color(edge);
    }
}

