/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import java.awt.Color;

public class WholeTrackFeatureColorGenerator
implements FeatureColorGenerator<Integer> {
    private final Model model;
    private final String trackFeature;
    private final Color missingValueColor;
    private final Color undefinedValueColor;
    private final Colormap colormap;
    private final double min;
    private final double max;

    public WholeTrackFeatureColorGenerator(Model model, String trackFeature, Color missingValueColor, Color undefinedValueColor, Colormap colormap, double min, double max) {
        this.model = model;
        this.trackFeature = trackFeature;
        this.missingValueColor = missingValueColor;
        this.undefinedValueColor = undefinedValueColor;
        this.colormap = colormap;
        this.min = min;
        this.max = max;
    }

    @Override
    public Color color(Integer trackID) {
        Double feat = this.model.getFeatureModel().getTrackFeature(trackID, this.trackFeature);
        if (null == feat) {
            return this.missingValueColor;
        }
        if (feat.isNaN()) {
            return this.undefinedValueColor;
        }
        double val = feat;
        return this.colormap.getPaint((val - this.min) / (this.max - this.min));
    }
}

