/*
 * Decompiled with CFR 0.152.
 */
package io.scif.common;

import io.scif.common.IniList;
import io.scif.common.IniTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.scijava.log.LogService;
import org.scijava.log.StderrLogService;

public class IniParser {
    private String commentDelimiter = "#";
    private boolean slashContinues = true;
    private final LogService log;

    public IniParser() {
        this((LogService)new StderrLogService());
    }

    public IniParser(LogService log) {
        this.log = log;
    }

    public void setCommentDelimiter(String delimiter) {
        this.commentDelimiter = delimiter;
    }

    public void setBackslashContinuesLine(boolean slashContinues) {
        this.slashContinues = slashContinues;
    }

    public IniList parseINI(String path) throws IOException {
        return this.parseINI(this.openTextResource(path));
    }

    public IniList parseINI(String path, Class<?> c) throws IOException {
        return this.parseINI(this.openTextResource(path, c));
    }

    public IniList parseINI(BufferedReader in) throws IOException {
        int num;
        IniList list = new IniList();
        IniTable attrs = null;
        String chapter = null;
        int no = 1;
        StringBuffer sb = new StringBuffer();
        while ((num = this.readLine(in, sb)) != 0) {
            int end;
            String line = sb.toString();
            this.log.debug((Object)("Line " + no + ": " + line));
            if (line.equals("")) {
                no += num;
                continue;
            }
            if (line.startsWith("{")) {
                end = line.length();
                if (line.endsWith("}")) {
                    --end;
                }
                chapter = line.substring(1, end);
                continue;
            }
            if (line.startsWith("[")) {
                attrs = new IniTable();
                list.add(attrs);
                end = line.length();
                if (line.endsWith("]")) {
                    --end;
                }
                String header = line.substring(1, end);
                if (chapter != null) {
                    header = chapter + ": " + header;
                }
                attrs.put("header", header);
                no += num;
                continue;
            }
            int equals = line.indexOf("=");
            if (equals < 0 || attrs == null) {
                throw new IOException(no + ": bad line");
            }
            String key = line.substring(0, equals).trim();
            String value = line.substring(equals + 1).trim();
            attrs.put(key, value);
            no += num;
        }
        return list;
    }

    private BufferedReader openTextResource(String path) {
        return this.openTextResource(path, IniParser.class);
    }

    private BufferedReader openTextResource(String path, Class<?> c) {
        try {
            return new BufferedReader(new InputStreamReader(c.getResourceAsStream(path), "UTF-8"));
        }
        catch (IOException e) {
            this.log.error((Object)"Could not open BufferedReader", (Throwable)e);
            return null;
        }
    }

    private int readLine(BufferedReader in, StringBuffer sb) throws IOException {
        String line;
        int no = 0;
        sb.setLength(0);
        boolean blockText = false;
        while ((line = in.readLine()) != null) {
            int comment;
            ++no;
            if (this.commentDelimiter != null && (comment = line.indexOf(this.commentDelimiter)) >= 0) {
                line = line.substring(0, comment);
            }
            if (!blockText) {
                line = line.trim();
            }
            boolean slash = this.slashContinues && line.trim().endsWith("\\");
            boolean bl = blockText = this.slashContinues && line.trim().endsWith("\\n");
            if (blockText) {
                line = line.substring(0, line.length() - 2) + "\n";
            } else if (slash) {
                line = line.substring(0, line.length() - 1).trim() + " ";
            }
            sb.append(line);
            if (slash || blockText) continue;
            break;
        }
        return no;
    }
}

