/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Range
extends ArrayList<Long> {
    private static final String REGION_PATTERN = "\\d*(-\\d*(:\\d*)?)?(,\\d*(-\\d*(:\\d)?)?)*";
    private final Set<Long> setIndex = new HashSet<Long>();

    private Range() {
    }

    public Range(String range) {
        this();
        String[] intervals;
        if (!range.matches(REGION_PATTERN)) {
            throw new IllegalArgumentException("Invalid range pattern. Must match: \\d*(-\\d*(:\\d*)?)?(,\\d*(-\\d*(:\\d)?)?)*");
        }
        for (String interval : intervals = range.split(",")) {
            long start;
            String[] rangeTokens = interval.split("-");
            long end = start = Long.parseLong(rangeTokens[0]);
            long step = 1L;
            if (rangeTokens.length == 2) {
                String[] rangeTail = rangeTokens[1].split(":");
                end = Long.parseLong(rangeTail[0]);
                if (rangeTail.length == 2) {
                    step = Long.parseLong(rangeTail[1]);
                }
            }
            for (long j = start; j <= end; j += step) {
                this.setIndex.add(j);
                this.add(j);
            }
        }
    }

    public Range(Long index) {
        this();
        this.setIndex.add(index);
        this.add(index);
    }

    public Range(Long start, Long end) {
        this();
        for (long l = start.longValue(); l <= end; ++l) {
            this.setIndex.add(l);
            this.add(l);
        }
    }

    public Range(long[] values) {
        this();
        for (long l : values) {
            this.setIndex.add(l);
            this.add(l);
        }
    }

    @Override
    public boolean contains(Object l) {
        return this.setIndex.contains(l);
    }

    public Long head() {
        return (Long)this.get(0);
    }

    public Long tail() {
        return (Long)this.get(this.size() - 1);
    }
}

