/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.Reader;
import io.scif.filters.ReaderFilter;
import io.scif.img.ImageRegion;
import io.scif.img.cell.SCIFIOCellImg;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.img.cell.loaders.ByteArrayLoader;
import io.scif.img.cell.loaders.CharArrayLoader;
import io.scif.img.cell.loaders.DoubleArrayLoader;
import io.scif.img.cell.loaders.FloatArrayLoader;
import io.scif.img.cell.loaders.IntArrayLoader;
import io.scif.img.cell.loaders.LongArrayLoader;
import io.scif.img.cell.loaders.ShortArrayLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.CacheRemover;
import net.imglib2.cache.IoSync;
import net.imglib2.cache.img.AccessIo;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.DirtyDiskCellCache;
import net.imglib2.cache.img.DiskCachedCellImgOptions;
import net.imglib2.cache.img.DiskCellCache;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.cache.ref.GuardedStrongRefLoaderRemoverCache;
import net.imglib2.cache.ref.SoftRefLoaderRemoverCache;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class SCIFIOCellImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    private int index;
    private Reader reader;
    private ImageRegion subregion;
    private int[] defaultCellDimensions;
    private DiskCachedCellImgOptions factoryOptions;

    public SCIFIOCellImgFactory(T type) {
        this(type, DiskCachedCellImgOptions.options());
    }

    public SCIFIOCellImgFactory(T type, DiskCachedCellImgOptions optional) {
        super(type);
        this.factoryOptions = optional;
    }

    public SCIFIOCellImg<T, ?> create(long ... dimensions) {
        SCIFIOCellImg img = this.create(dimensions, (NativeType)this.type(), ((NativeType)this.type()).getNativeTypeFactory());
        return img;
    }

    public SCIFIOCellImg<T, ?> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray((Dimensions)dimensions));
    }

    public SCIFIOCellImg<T, ?> create(int[] dimensions) {
        return this.create(Util.int2long((int[])dimensions));
    }

    public Reader reader() {
        return this.reader;
    }

    public void setReader(Reader r, int imageIndex) {
        this.reader = r;
        this.index = imageIndex;
        if (r instanceof ReaderFilter) {
            r = ((ReaderFilter)r).getTail();
        }
        this.defaultCellDimensions = new int[]{(int)this.reader.getOptimalTileWidth(imageIndex), (int)this.reader.getOptimalTileHeight(imageIndex), 1, 1, 1};
    }

    public void setSubRegion(ImageRegion region) {
        this.subregion = region;
    }

    private <A extends ArrayDataAccess<A>> SCIFIOCellLoader<T, A> createCellLoader(NativeTypeFactory<T, A> typeFactory) {
        switch (typeFactory.getPrimitiveType()) {
            case BYTE: {
                return new SCIFIOCellLoader(new ByteArrayLoader(this.reader, this.subregion), o -> new ByteArray((byte[])o));
            }
            case CHAR: {
                return new SCIFIOCellLoader(new CharArrayLoader(this.reader, this.subregion), o -> new CharArray((char[])o));
            }
            case DOUBLE: {
                return new SCIFIOCellLoader(new DoubleArrayLoader(this.reader, this.subregion), o -> new DoubleArray((double[])o));
            }
            case FLOAT: {
                return new SCIFIOCellLoader(new FloatArrayLoader(this.reader, this.subregion), o -> new FloatArray((float[])o));
            }
            case INT: {
                return new SCIFIOCellLoader(new IntArrayLoader(this.reader, this.subregion), o -> new IntArray((int[])o));
            }
            case LONG: {
                return new SCIFIOCellLoader(new LongArrayLoader(this.reader, this.subregion), o -> new LongArray((long[])o));
            }
            case SHORT: {
                return new SCIFIOCellLoader(new ShortArrayLoader(this.reader, this.subregion), o -> new ShortArray((short[])o));
            }
        }
        throw new IllegalArgumentException();
    }

    private <A extends ArrayDataAccess<A>> SCIFIOCellImg<T, ? extends A> create(long[] dimensions, T type, NativeTypeFactory<T, A> typeFactory) {
        SoftRefLoaderRemoverCache listenableCache;
        CellLoader cellLoader = this.createCellLoader(typeFactory);
        ((SCIFIOCellLoader)cellLoader).loader.setIndex(this.index);
        DiskCachedCellImgOptions.Values options = this.factoryOptions.values;
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        CellGrid grid = this.createCellGrid(dimensions, entitiesPerPixel);
        CellLoader actualCellLoader = options.initializeCellsAsDirty() ? cell -> {
            cellLoader.load(cell);
            cell.setDirty();
        } : cellLoader;
        LoadedCellCacheLoader backingLoader = LoadedCellCacheLoader.get((CellGrid)grid, (CellLoader)actualCellLoader, type, (Set)options.accessFlags());
        Path blockcache = this.createBlockCachePath(options);
        DirtyDiskCellCache diskcache = options.dirtyAccesses() ? new DirtyDiskCellCache(blockcache, grid, (CacheLoader)backingLoader, AccessIo.get(type, (Set)options.accessFlags()), entitiesPerPixel) : new DiskCellCache(blockcache, grid, (CacheLoader)backingLoader, AccessIo.get(type, (Set)options.accessFlags()), entitiesPerPixel);
        IoSync iosync = new IoSync((CacheLoader)diskcache, options.numIoThreads(), options.maxIoQueueSize());
        switch (options.cacheType()) {
            case BOUNDED: {
                listenableCache = new GuardedStrongRefLoaderRemoverCache(options.maxCacheSize());
                break;
            }
            default: {
                listenableCache = new SoftRefLoaderRemoverCache();
            }
        }
        Cache cache = listenableCache.withRemover((CacheRemover)iosync).withLoader((CacheLoader)iosync);
        ArrayDataAccess accessType = ArrayDataAccessFactory.get(typeFactory, (Set)options.accessFlags());
        SCIFIOCellImg img = new SCIFIOCellImg(this, grid, entitiesPerPixel, cache, accessType, iosync);
        img.setLinkedType(typeFactory.createLinkedType(img));
        return img;
    }

    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new SCIFIOCellImgFactory<NativeType>((NativeType)type, this.factoryOptions);
        }
        throw new IncompatibleTypeException((Object)this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    private CellGrid createCellGrid(long[] dimensions, Fraction entitiesPerPixel) {
        CellImgFactory.verifyDimensions((long[])dimensions);
        int n = dimensions.length;
        int[] defaultDims = new int[dimensions.length];
        for (int d = 0; d < defaultDims.length; ++d) {
            defaultDims[d] = dimensions[d] < (long)this.defaultCellDimensions[d] ? (int)dimensions[d] : this.defaultCellDimensions[d];
        }
        int[] cellDimensions = CellImgFactory.getCellDimensions((int[])defaultDims, (int)n, (Fraction)entitiesPerPixel);
        return new CellGrid(dimensions, cellDimensions);
    }

    private Path createBlockCachePath(DiskCachedCellImgOptions.Values options) {
        try {
            Path cache = options.cacheDirectory();
            Path dir = options.tempDirectory();
            String prefix = options.tempDirectoryPrefix();
            boolean deleteOnExit = options.deleteCacheDirectoryOnExit();
            if (cache != null) {
                if (!Files.isDirectory(cache, new LinkOption[0])) {
                    Files.createDirectories(cache, new FileAttribute[0]);
                    if (deleteOnExit) {
                        DiskCellCache.addDeleteHook((Path)cache);
                    }
                }
                return cache;
            }
            if (dir != null) {
                return DiskCellCache.createTempDirectory((Path)dir, (String)prefix, (boolean)deleteOnExit);
            }
            return DiskCellCache.createTempDirectory((String)prefix, (boolean)deleteOnExit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public SCIFIOCellImgFactory() {
        this(10);
    }

    @Deprecated
    public SCIFIOCellImgFactory(int ... cellDimensions) {
        this.factoryOptions = DiskCachedCellImgOptions.options();
        this.defaultCellDimensions = (int[])cellDimensions.clone();
    }

    @Deprecated
    public SCIFIOCellImg<T, ?> create(long[] dim, T type) {
        if (this.reader == null) {
            throw new IllegalStateException("Tried to create a new SCIFIOCellImg without a Reader to use for opening planes.\nCall setReader(Reader) before invoking create()");
        }
        this.cache(type);
        SCIFIOCellImg img = this.create(dim, type, type.getNativeTypeFactory());
        return img;
    }

    private static class SCIFIOCellLoader<T extends NativeType<T>, A>
    implements CellLoader<T> {
        private final AbstractArrayLoader<A> loader;
        private final Function<Object, A> wrap;

        SCIFIOCellLoader(AbstractArrayLoader<A> loader, Function<Object, A> wrap) {
            this.loader = loader;
            this.wrap = wrap;
        }

        public void load(SingleCellArrayImg<T, ?> cell) throws Exception {
            A data = this.wrap.apply(cell.getStorageArray());
            this.loader.loadArray((Interval)cell, data);
        }
    }
}

