/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import net.imglib2.roi.AbstractRegionOfInterest;

@Deprecated
public class LineRegionOfInterest
extends AbstractRegionOfInterest {
    private static final double SLOPE_TOLERANCE = 0.01;
    private static final double UNIT_TOLERANCE = 0.5;
    private final double[] p1;
    private final double[] p2;
    private final double[] tmpMin;
    private final double[] tmpMax;
    private final double[] lineVector;
    private final double[] tmpVector;

    public LineRegionOfInterest(double[] pt1, double[] pt2) {
        super(pt1.length);
        assert (pt1.length == pt2.length);
        this.p1 = (double[])pt1.clone();
        this.p2 = (double[])pt2.clone();
        this.tmpMin = new double[pt1.length];
        this.tmpMax = new double[pt1.length];
        this.lineVector = new double[pt1.length];
        this.tmpVector = new double[pt1.length];
        this.invalidateCachedState();
        this.calcLineVector();
    }

    public void getPoint1(double[] pt) {
        System.arraycopy(this.p1, 0, pt, 0, this.p1.length);
    }

    public void getPoint2(double[] pt) {
        System.arraycopy(this.p2, 0, pt, 0, this.p2.length);
    }

    public void setPoint1(double[] pt) {
        System.arraycopy(pt, 0, this.p1, 0, this.p1.length);
        this.invalidateCachedState();
        this.calcLineVector();
    }

    public void setPoint2(double[] pt) {
        System.arraycopy(pt, 0, this.p2, 0, this.p2.length);
        this.invalidateCachedState();
        this.calcLineVector();
    }

    public double getPoint1(int dim) {
        return this.p1[dim];
    }

    public double getPoint2(int dim) {
        return this.p2[dim];
    }

    public void setPoint1(double val, int dim) {
        this.p1[dim] = val;
        this.invalidateCachedState();
        this.calcLineVector();
    }

    public void setPoint2(double val, int dim) {
        this.p2[dim] = val;
        this.invalidateCachedState();
        this.calcLineVector();
    }

    @Override
    public void move(double displacement, int d) {
        int n = d;
        this.p1[n] = this.p1[n] + displacement;
        int n2 = d;
        this.p2[n2] = this.p2[n2] + displacement;
        this.invalidateCachedState();
        this.calcLineVector();
    }

    @Override
    public boolean contains(double[] position) {
        boolean nearCos180;
        if (this.dist(this.p1, position) < 0.5) {
            return true;
        }
        if (this.dist(this.p2, position) < 0.5) {
            return true;
        }
        for (int i = 0; i < this.p1.length; ++i) {
            this.tmpVector[i] = position[i] - this.p1[1];
        }
        double dotProduct = this.dot(this.lineVector, this.tmpVector);
        double magnitudeProduct = this.dist(this.p1, this.p2);
        double cosTheta = dotProduct / (magnitudeProduct *= this.dist(this.p1, position));
        boolean nearCos0 = cosTheta > 0.99 && cosTheta < 1.01;
        boolean bl = nearCos180 = cosTheta > -1.01 && cosTheta < -0.99;
        if (!nearCos0 && !nearCos180) {
            return false;
        }
        this.realMin(this.tmpMin);
        this.realMax(this.tmpMax);
        return !this.outOfBounds(this.tmpMin, this.tmpMax, position);
    }

    @Override
    protected void getRealExtrema(double[] minima, double[] maxima) {
        for (int i = 0; i < this.p1.length; ++i) {
            minima[i] = Math.min(this.p1[i], this.p2[i]);
            maxima[i] = Math.max(this.p1[i], this.p2[i]);
        }
    }

    private void calcLineVector() {
        for (int i = 0; i < this.p1.length; ++i) {
            this.lineVector[i] = this.p2[i] - this.p1[i];
        }
    }

    private double dist(double[] pt1, double[] pt2) {
        double sum = 0.0;
        for (int i = 0; i < this.p1.length; ++i) {
            double term = pt2[i] - pt1[i];
            sum += term * term;
        }
        return Math.sqrt(sum);
    }

    private double dot(double[] vec1, double[] vec2) {
        double sum = 0.0;
        for (int i = 0; i < this.p1.length; ++i) {
            sum += vec1[i] * vec2[i];
        }
        return sum;
    }

    private boolean outOfBounds(double[] mn, double[] mx, double[] pt) {
        for (int i = 0; i < this.p1.length; ++i) {
            if (pt[i] < mn[i]) {
                return true;
            }
            if (!(pt[i] > mx[i])) continue;
            return true;
        }
        return false;
    }
}

