/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import net.imglib2.AbstractWrappedPositionableLocalizable;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.outofbounds.OutOfBoundsConstantValue;
import net.imglib2.roi.PositionableIterableInterval;
import net.imglib2.roi.PositionableIterableRegion;
import net.imglib2.roi.labeling.LabelRegionCursor;
import net.imglib2.roi.labeling.LabelRegionRandomAccess;
import net.imglib2.roi.labeling.LabelRegions;
import net.imglib2.roi.util.PositionableInterval;
import net.imglib2.roi.util.PositionableLocalizable;
import net.imglib2.type.logic.BoolType;
import net.imglib2.util.Intervals;

public class LabelRegion<T>
extends PositionableInterval
implements PositionableIterableRegion<BoolType> {
    final LabelRegions<T> regions;
    private final LabelRegions.LabelRegionProperties regionProperties;
    private final T label;
    private final ArrayList<TIntArrayList> itcodes;
    private long insideSize;
    private final RealPoint centerOfMass;
    private int expectedGeneration;
    private final LabelRegionIterable inside;

    public LabelRegion(LabelRegions<T> regions, LabelRegions.LabelRegionProperties regionProperties, T label) {
        super((Interval)new FinalInterval(regionProperties.getBoundingBoxMin(), regionProperties.getBoundingBoxMax()));
        this.regions = regions;
        this.regionProperties = regionProperties;
        this.label = label;
        this.expectedGeneration = regionProperties.update();
        this.insideSize = regionProperties.getSize();
        this.itcodes = regionProperties.getItcodes();
        this.centerOfMass = RealPoint.wrap((double[])regionProperties.getCenterOfMass());
        this.inside = new LabelRegionIterable();
    }

    protected LabelRegion(LabelRegion<T> other) {
        super(other);
        this.regions = other.regions;
        this.regionProperties = other.regionProperties;
        this.label = other.label;
        this.expectedGeneration = other.expectedGeneration;
        this.insideSize = other.insideSize;
        this.itcodes = other.itcodes;
        this.centerOfMass = other.centerOfMass;
        this.inside = new LabelRegionIterable();
    }

    @Override
    public LabelRegion<T> copy() {
        return new LabelRegion<T>(this);
    }

    @Override
    public PositionableLocalizable origin() {
        this.update();
        return super.origin();
    }

    public T getLabel() {
        return this.label;
    }

    private void update() {
        int generation = this.regionProperties.update();
        if (generation != this.expectedGeneration) {
            this.expectedGeneration = generation;
            long[] bbmin = this.regionProperties.getBoundingBoxMin();
            long[] bbmax = this.regionProperties.getBoundingBoxMax();
            for (int d = 0; d < this.n; ++d) {
                this.initialMin[d] = bbmin[d];
                this.initialMax[d] = bbmax[d];
            }
            this.insideSize = this.regionProperties.getSize();
        }
    }

    public RealLocalizable getCenterOfMass() {
        this.update();
        return this.centerOfMass;
    }

    public LabelRegionRandomAccess<T> randomAccess() {
        this.update();
        return new LabelRegionRandomAccess(this, this.currentOffset);
    }

    public RandomAccess<BoolType> randomAccess(Interval interval) {
        this.update();
        if (Intervals.contains((Interval)this, (Interval)interval)) {
            return this.randomAccess();
        }
        return new OutOfBoundsConstantValue((Interval)this, (Object)new BoolType(false));
    }

    public BoolType getType() {
        return new BoolType();
    }

    @Override
    public PositionableIterableInterval<Void> inside() {
        return this.inside;
    }

    private long insideSize() {
        this.update();
        return this.insideSize;
    }

    @Override
    public double realMin(int d) {
        this.update();
        return super.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.update();
        super.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.update();
        super.realMin(min);
    }

    @Override
    public double realMax(int d) {
        this.update();
        return super.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.update();
        super.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.update();
        super.realMax(max);
    }

    @Override
    public long min(int d) {
        this.update();
        return super.min(d);
    }

    @Override
    public void min(long[] min) {
        this.update();
        super.min(min);
    }

    @Override
    public void min(Positionable min) {
        this.update();
        super.min(min);
    }

    @Override
    public long max(int d) {
        this.update();
        return super.max(d);
    }

    @Override
    public void max(long[] max) {
        this.update();
        super.max(max);
    }

    @Override
    public void max(Positionable max) {
        this.update();
        super.max(max);
    }

    @Override
    public void dimensions(long[] dimensions) {
        this.update();
        super.dimensions(dimensions);
    }

    @Override
    public long dimension(int d) {
        this.update();
        return super.dimension(d);
    }

    private final class LabelRegionIterable
    extends AbstractWrappedPositionableLocalizable<LabelRegion<T>>
    implements PositionableIterableInterval<Void> {
        LabelRegionIterable() {
            super((Positionable)LabelRegion.this);
        }

        public LabelRegionCursor cursor() {
            LabelRegion.this.update();
            return new LabelRegionCursor(LabelRegion.this.itcodes, LabelRegion.this.currentOffset);
        }

        public LabelRegionCursor localizingCursor() {
            return this.cursor();
        }

        public long size() {
            return LabelRegion.this.insideSize();
        }

        public Void firstElement() {
            return null;
        }

        public Void getType() {
            return null;
        }

        public Object iterationOrder() {
            return this;
        }

        public LabelRegionCursor iterator() {
            return this.cursor();
        }

        @Override
        public PositionableLocalizable origin() {
            return LabelRegion.this.origin();
        }

        @Override
        public PositionableIterableInterval<Void> copy() {
            return ((LabelRegion)LabelRegion.this.copy()).inside();
        }

        public long min(int d) {
            return LabelRegion.this.min(d);
        }

        public long max(int d) {
            return LabelRegion.this.max(d);
        }
    }
}

