/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;

public class RATSQuadtree {
    public boolean bverbose = false;
    public int[] dim;
    public int level = 0;
    public double[] minSzPx = new double[]{4.0, 4.0};
    private RATSQuadtree parent;
    private RATSQuadtree[][] qt = new RATSQuadtree[2][2];
    public double x0;
    public double y0;
    public double x1;
    public double y1;
    public float sum = 0.0f;

    public RATSQuadtree(int[] dim, double minSzPx) {
        this.dim = dim;
        this.minSzPx[0] = minSzPx;
        this.minSzPx[1] = minSzPx;
        this.level = 0;
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.x1 = (double)dim[0] - 1.0;
        this.y1 = (double)dim[1] - 1.0;
        this.parent = null;
        this.subdivide(this.qt);
    }

    public RATSQuadtree(int[] dim, double[] minSzPx) {
        this.dim = dim;
        this.minSzPx = minSzPx;
        this.level = 0;
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.x1 = (double)dim[0] - 1.0;
        this.y1 = (double)dim[1] - 1.0;
        this.parent = null;
        this.subdivide(this.qt);
    }

    public RATSQuadtree(int[] dim, double[] minSzPx, int level, double x0, double y0, double x1, double y1, RATSQuadtree theParent) {
        this.parent = theParent;
        this.dim = dim;
        this.minSzPx = minSzPx;
        this.level = level;
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.subdivide(this.qt);
    }

    private boolean subdivide(RATSQuadtree[][] qt) {
        boolean ok = true;
        double w = this.x1 - this.x0 + 1.0;
        double h = this.y1 - this.y0 + 1.0;
        if (w / 2.0 >= this.minSzPx[0] && h / 2.0 >= this.minSzPx[1]) {
            qt[0][0] = new RATSQuadtree(this.dim, this.minSzPx, this.level + 1, this.x0, this.y0, this.x0 + w / 2.0 - 1.0, this.y0 + h / 2.0 - 1.0, this);
            qt[0][1] = new RATSQuadtree(this.dim, this.minSzPx, this.level + 1, this.x0 + w / 2.0, this.y0, this.x0 + w - 1.0, this.y0 + h / 2.0 - 1.0, this);
            qt[1][0] = new RATSQuadtree(this.dim, this.minSzPx, this.level + 1, this.x0, this.y0 + h / 2.0, this.x0 + w / 2.0 - 1.0, this.y0 + h - 1.0, this);
            qt[1][1] = new RATSQuadtree(this.dim, this.minSzPx, this.level + 1, this.x0 + w / 2.0, this.y0 + h / 2.0, this.x0 + w - 1.0, this.y0 + h - 1.0, this);
        } else {
            ok = false;
        }
        return ok;
    }

    public void fillWithSums(ImageProcessor ip) {
        if (this.level == 0) {
            RATSQuadtree[][] q = this.getLevel(this.countLevels() - 1);
            for (int x = 0; x < q.length; ++x) {
                for (int y = 0; y < q[0].length; ++y) {
                    q[x][y].sum = q[x][y].getSumFloat(ip);
                }
            }
            for (int iL = this.countLevels() - 2; iL > -1; --iL) {
                q = this.getLevel(iL);
                for (int x = 0; x < q.length; ++x) {
                    for (int y = 0; y < q[0].length; ++y) {
                        q[x][y].sumChildren();
                    }
                }
            }
        }
    }

    private void sumChildren() {
        if (this.qt[0] != null) {
            this.sum = this.qt[0][0].sum + this.qt[0][1].sum + this.qt[1][0].sum + this.qt[1][1].sum;
        }
    }

    public int[] getDimInteger() {
        int[] c = this.getCoordsInteger();
        int[] dim = new int[]{c[2] - c[0] + 1, c[3] - c[1] + 1};
        return dim;
    }

    public double[] getDimDouble() {
        double[] c = this.getCoordsDouble();
        double[] dim = new double[]{c[2] - c[0] + 1.0, c[3] - c[1] + 1.0};
        return dim;
    }

    public double[] getCenter() {
        double[] c = this.getCoordsDouble();
        double[] d = this.getDimDouble();
        double[] r = new double[]{c[0] + d[0] / 2.0, c[1] + d[1] / 2.0};
        return r;
    }

    public int[] getCoordsInteger() {
        int[] c = new int[]{(int)Math.round(this.x0), (int)Math.round(this.y0), (int)Math.round(this.x1), (int)Math.round(this.y1)};
        return c;
    }

    public double[] getCoordsDouble() {
        double[] c = new double[]{this.x0, this.y0, this.x1, this.y1};
        return c;
    }

    public String getChildName(RATSQuadtree qc) {
        if (this.qt[0][0] == qc) {
            return "NW";
        }
        if (this.qt[0][1] == qc) {
            return "NE";
        }
        if (this.qt[1][0] == qc) {
            return "SW";
        }
        if (this.qt[1][1] == qc) {
            return "SE";
        }
        return "NA";
    }

    public String getName() {
        return this.parent == null ? "NA" : this.parent.getChildName(this);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean hasChildren() {
        return this.qt[0][0] != null;
    }

    public RATSQuadtree[][] getChildren() {
        return this.qt;
    }

    public RATSQuadtree getParent() {
        return this.parent;
    }

    public RATSQuadtree[][] getSiblings() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getChildren();
    }

    public RATSQuadtree[][] getLevel(int theLevel) {
        if (theLevel == this.level) {
            RATSQuadtree[][] self = new RATSQuadtree[1][1];
            self[0][0] = this;
            return self;
        }
        if (theLevel == this.level + 1) {
            return this.getChildren();
        }
        if (theLevel < this.level) {
            IJ.showMessage((String)"HBB_QUATREE", (String)("Unable to retrieve a level higher than my own: " + this.level));
            return new RATSQuadtree[0][0];
        }
        RATSQuadtree[][] qnw = this.qt[0][0].getLevel(theLevel);
        RATSQuadtree[][] qne = this.qt[0][1].getLevel(theLevel);
        RATSQuadtree[][] qsw = this.qt[1][0].getLevel(theLevel);
        RATSQuadtree[][] qse = this.qt[1][1].getLevel(theLevel);
        int ny = qnw.length;
        int nx = qnw[0].length;
        RATSQuadtree[][] q = new RATSQuadtree[ny * 2][nx * 2];
        for (int v = 0; v < ny; ++v) {
            for (int u = 0; u < nx; ++u) {
                q[v][u] = qnw[v][u];
                q[v][u + nx] = qne[v][u];
                q[v + ny][u] = qsw[v][u];
                q[v + ny][u + nx] = qse[v][u];
            }
        }
        return q;
    }

    public float getSumFloat(ImagePlus imp) {
        return this.getSumFloat(imp.getProcessor());
    }

    public float getSumFloat(ImageProcessor ip) {
        int[] xy = this.getCoordsInteger();
        int[] wh = this.getDimInteger();
        this.sum = 0.0f;
        for (int j = 0; j < wh[1]; ++j) {
            for (int i = 0; i < wh[0]; ++i) {
                this.sum += ip.getPixelValue(i + xy[0], j + xy[1]);
            }
        }
        return this.sum;
    }

    public float getSumFloat() {
        return this.sum;
    }

    public float[][] getSumArrayFloat(int theLevel, ImagePlus imp) {
        return this.getSumArrayFloat(theLevel, imp.getProcessor());
    }

    public float[][] getSumArrayFloat(int theLevel, ImageProcessor ip) {
        float[][] arr = this.makeArrayFloat(theLevel);
        RATSQuadtree[][] q = this.getLevel(theLevel);
        int[] wh = q[0][0].getDimInteger();
        for (int v = 0; v < q.length; ++v) {
            for (int u = 0; u < q[v].length; ++u) {
                double[] c = q[v][u].getCenter();
                int x = (int)c[0] / wh[0];
                int y = (int)c[1] / wh[1];
                arr[v][u] = q[v][u].getSumFloat(ip);
            }
        }
        return arr;
    }

    public float[] getPixelsFloat(ImagePlus imp) {
        return this.getPixelsFloat(imp.getProcessor());
    }

    public float[] getPixelsFloat(ImageProcessor ip) {
        int[] xy = this.getCoordsInteger();
        int[] wh = this.getDimInteger();
        float[] r = new float[wh[0] * wh[1]];
        for (int j = 0; j < wh[1]; ++j) {
            for (int i = 0; i < wh[0]; ++i) {
                r[j * wh[0] + i] = ip.getPixelValue(i + xy[0], j + xy[1]);
            }
        }
        return r;
    }

    public int countLeaflets(int level) {
        return (int)Math.pow(4.0, level);
    }

    public int countLevels() {
        int lvl = 1;
        if (this.qt[0][0] != null) {
            lvl += this.qt[0][0].countLevels();
        }
        return lvl;
    }

    public void drawBounds(ImagePlus imp) {
        double w = this.x1 - this.x0 + 1.0;
        double h = this.y1 - this.y0 + 1.0;
        boolean isLocked = imp.isLocked();
        if (isLocked) {
            imp.unlock();
        }
        IJ.run((String)"Specify...", (String)("width=" + Math.round(w) + " height=" + Math.round(h) + " x=" + Math.round(this.x0) + " y=" + Math.round(this.y0)));
        IJ.run((String)"Draw");
        if (isLocked) {
            imp.lock();
        }
        if (this.bverbose) {
            IJ.log((String)("w=" + w + " h=" + h + " x=" + this.x0 + " y=" + this.y0));
        }
    }

    public void drawCenter(ImagePlus imp) {
        double[] c = this.getCenter();
        boolean isLocked = imp.isLocked();
        if (isLocked) {
            imp.unlock();
        }
        IJ.setTool((int)7);
        IJ.makePoint((int)((int)Math.round(c[0])), (int)((int)Math.round(c[1])));
        IJ.run((String)"Draw");
        if (isLocked) {
            imp.lock();
        }
    }

    public void drawBounds(int drawLevel, ImagePlus imp) {
        if (this.level == drawLevel) {
            this.drawBounds(imp);
        } else if (this.qt[0][0] != null) {
            this.qt[0][0].drawBounds(drawLevel, imp);
            this.qt[0][1].drawBounds(drawLevel, imp);
            this.qt[1][0].drawBounds(drawLevel, imp);
            this.qt[1][1].drawBounds(drawLevel, imp);
        }
    }

    public float[][] makeArrayFloat(int theLevel) {
        int n = (int)Math.pow(2.0, theLevel);
        float[][] arr = new float[n][n];
        return arr;
    }

    public int[] getArrayDim(RATSQuadtree[][] arr) {
        int[] dim = new int[2];
        dim[1] = arr.length;
        dim[0] = arr[0].length;
        return dim;
    }

    public int[] getArrayDim(float[][] arr) {
        int[] dim = new int[2];
        dim[1] = arr.length;
        dim[0] = arr[0].length;
        return dim;
    }

    public int[] getDim(Object[][] arr) {
        int[] dim = new int[2];
        dim[1] = arr.length;
        dim[0] = arr[0].length;
        return dim;
    }
}

