/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.LineFunction;
import pal.math.MFWithGradient;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.NumericalDerivative;

public class ConjugateGradientSearch
extends MultivariateMinimum {
    public static final int FLETCHER_REEVES_UPDATE = 0;
    public static final int POLAK_RIBIERE_UPDATE = 1;
    public static final int BEALE_SORENSON_HESTENES_STIEFEL_UPDATE = 2;
    public int prin = 0;
    public double defaultStep = 1.0;
    public int conjugateGradientStyle = 2;
    private int numArgs;
    private int numGrad;
    private double lastStep;
    private double[] xvec;
    private double[] gvec;
    private double[] sdir;
    private MFWithGradient fgrad;

    public ConjugateGradientSearch() {
    }

    public ConjugateGradientSearch(int conGradStyle) {
        this.conjugateGradientStyle = conGradStyle;
    }

    @Override
    public void optimize(MultivariateFunction f, double[] x, double tolfx, double tolx) {
        double fx;
        boolean numericalGradient;
        this.xvec = x;
        this.numArgs = f.getNumArguments();
        if (f instanceof MFWithGradient) {
            numericalGradient = false;
            this.fgrad = (MFWithGradient)f;
        } else {
            numericalGradient = true;
            this.fgrad = null;
        }
        LineFunction lf = new LineFunction(f);
        lf.checkPoint(this.xvec);
        double[] xold = new double[this.numArgs];
        this.copy(xold, this.xvec);
        this.numFun = 0;
        this.numGrad = 0;
        this.gvec = new double[this.numArgs];
        if (numericalGradient) {
            fx = f.evaluate(this.xvec);
            ++this.numFun;
            NumericalDerivative.gradient(f, this.xvec, this.gvec);
            this.numFun += 2 * this.numArgs;
        } else {
            fx = this.fgrad.evaluate(this.xvec, this.gvec);
            ++this.numFun;
            ++this.numGrad;
        }
        double[] gold = new double[this.numArgs];
        this.copy(gold, this.gvec);
        this.stopCondition(fx, this.xvec, tolfx, tolx, true);
        boolean[] active = new boolean[this.numArgs];
        double numActive = lf.checkVariables(this.xvec, this.gvec, active);
        if (numActive == 0.0) {
            return;
        }
        this.sdir = new double[this.numArgs];
        this.steepestDescentDirection(this.sdir, this.gvec, active);
        lf.update(this.xvec, this.sdir);
        double slope = this.gradientProjection(this.sdir, this.gvec);
        if (this.prin > 0) {
            System.out.println("--- starting minimization ---");
            System.out.println("... current parameter settings ...");
            System.out.println("...   tolx   ... " + tolx);
            System.out.println("...   tolfx   ... " + tolfx);
            System.out.println("... maxFun  ... " + this.maxFun);
            System.out.println();
            this.printVec("... start vector ...", this.xvec);
            System.out.println();
            this.printVec("... start direction ...", this.sdir);
        }
        int numLin = 0;
        this.lastStep = this.defaultStep;
        while (true) {
            double step;
            this.lastStep = step = this.findStep(lf, fx, slope, numericalGradient);
            ++numLin;
            lf.getPoint(step, this.xvec);
            lf.checkPoint(this.xvec);
            if (numericalGradient) {
                fx = f.evaluate(this.xvec);
                ++this.numFun;
            } else {
                fx = this.fgrad.evaluate(this.xvec, this.gvec);
                ++this.numFun;
                ++this.numGrad;
            }
            if (this.stopCondition(fx, this.xvec, tolfx, tolx, false) || this.maxFun > 0 && this.numFun > this.maxFun) break;
            if (numericalGradient) {
                NumericalDerivative.gradient(f, this.xvec, this.gvec);
                this.numFun += 2 * this.numArgs;
            }
            if ((numActive = (double)lf.checkVariables(this.xvec, this.gvec, active)) == 0.0) break;
            this.conjugateGradientDirection(this.sdir, this.gvec, gold, active);
            lf.checkDirection(this.xvec, this.sdir);
            slope = this.gradientProjection(this.sdir, this.gvec);
            if (slope >= 0.0) {
                this.steepestDescentDirection(this.sdir, this.gvec, active);
                slope = this.gradientProjection(this.sdir, this.gvec);
                this.lastStep = this.defaultStep;
            }
            lf.update(this.xvec, this.sdir);
            this.copy(xold, this.xvec);
            this.copy(gold, this.gvec);
            if (this.prin <= 1) continue;
            System.out.println();
            System.out.println("Function value: " + f.evaluate(this.xvec));
            System.out.println();
            this.printVec("... new vector ...", this.xvec);
            System.out.println();
            this.printVec("... new direction ...", this.sdir);
            System.out.println("... numFun  ... " + this.numFun);
            if (!numericalGradient) {
                System.out.println("... numGrad  ... " + this.numGrad);
            }
            System.out.println("... numLin  ... " + numLin);
            System.out.println();
        }
        if (this.prin > 0) {
            System.out.println();
            this.printVec("... final vector ...", this.xvec);
            System.out.println("... numFun  ... " + this.numFun);
            System.out.println("... numLin  ... " + numLin);
            System.out.println();
            System.out.println("--- end of minimization ---");
        }
    }

    private double findStep(LineFunction lf, double f0, double s0, boolean numericalGradient) {
        double maxStep = lf.getUpperBound();
        if (maxStep <= 0.0 || s0 == 0.0) {
            return 0.0;
        }
        double g1 = 2.0;
        double g2 = 1.25;
        double g3 = 0.5;
        double x1 = 0.0;
        double s1 = s0;
        double x2 = this.lastStep * g2;
        if (x2 > maxStep) {
            x2 = maxStep * g3;
        }
        double s2 = this.computeDerivative(lf, x2, numericalGradient);
        boolean boundReached = false;
        while (s2 <= 0.0 && !boundReached) {
            x1 = x2;
            s1 = s2;
            if ((x2 *= g1) > maxStep) {
                x2 = maxStep;
                boundReached = true;
            }
            s2 = this.computeDerivative(lf, x2, numericalGradient);
        }
        double step = s2 <= 0.0 ? x2 : (x1 * s2 - x2 * s1) / (s2 - s1);
        if (step >= maxStep) {
            step = maxStep;
        }
        if (step < 0.0) {
            step = 0.0;
        }
        return step;
    }

    private double computeDerivative(LineFunction lf, double lambda, boolean numericalGradient) {
        if (numericalGradient) {
            this.numFun += 2;
            return NumericalDerivative.firstDerivative(lf, lambda);
        }
        double[] xtmp = new double[this.numArgs];
        this.copy(xtmp, this.xvec);
        lf.getPoint(lambda, xtmp);
        lf.checkPoint(xtmp);
        this.fgrad.computeGradient(xtmp, this.gvec);
        ++this.numGrad;
        return this.gradientProjection(this.sdir, this.gvec);
    }

    private void testStep(double f0, double s0, double f1, double s1, double step) {
        double mue = 1.0E-4;
        double eta = 0.9;
        if (f1 <= mue * s0 * step + f0) {
            System.out.println("<<< Sufficient decrease in function value");
        } else {
            System.out.println("<<< NO sufficient decrease in function value");
        }
        if (Math.abs(s1) <= eta * Math.abs(s0)) {
            System.out.println("<<< Sufficient decrease in slope");
        } else {
            System.out.println("<<< NO sufficient decrease in slope");
        }
    }

    private void conjugateGradientDirection(double[] sdir, double[] gvec, double[] gold, boolean[] active) {
        double gg = 0.0;
        double dgg = 0.0;
        block5: for (int i = 0; i < this.numArgs; ++i) {
            if (!active[i]) continue;
            switch (this.conjugateGradientStyle) {
                case 0: {
                    dgg += gvec[i] * gvec[i];
                    gg += gold[i] * gold[i];
                    continue block5;
                }
                case 1: {
                    dgg += gvec[i] * (gvec[i] - gold[i]);
                    gg += gold[i] * gold[i];
                    continue block5;
                }
                case 2: {
                    dgg += gvec[i] * (gvec[i] - gold[i]);
                    gg += sdir[i] * (gvec[i] - gold[i]);
                }
            }
        }
        double beta = dgg / gg;
        if (beta < 0.0 || gg == 0.0) {
            beta = 0.0;
        }
        for (int i = 0; i < this.numArgs; ++i) {
            sdir[i] = active[i] ? -gvec[i] + beta * sdir[i] : 0.0;
        }
    }

    private void steepestDescentDirection(double[] sdir, double[] gvec, boolean[] active) {
        for (int i = 0; i < this.numArgs; ++i) {
            sdir[i] = active[i] ? -gvec[i] : 0.0;
        }
    }

    private double gradientProjection(double[] sdir, double[] gvec) {
        double s = 0.0;
        double n = gvec.length;
        int i = 0;
        while ((double)i < n) {
            s += gvec[i] * sdir[i];
            ++i;
        }
        return s;
    }

    private void printVec(String s, double[] x) {
        System.out.println(s);
        for (int i = 0; i < x.length; ++i) {
            System.out.print(x[i] + "  ");
        }
        System.out.println();
    }
}

