/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.launcher;

import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.scijava.launcher.ClassLauncher;
import org.scijava.launcher.LookAndFeel;

public final class Dialogs {
    private Dialogs() {
    }

    public static Result ask(Component parent, String message, String yes, String no, String never) {
        Object[] options;
        LookAndFeel.init();
        String title = ClassLauncher.appName("SciJava App Launcher");
        int optionType = -1;
        int messageType = 3;
        Icon icon = null;
        ArrayList<String> optionsList = new ArrayList<String>();
        if (yes != null) {
            optionsList.add(yes);
        }
        if (no != null) {
            optionsList.add(no);
        }
        if (never != null) {
            optionsList.add(never);
        }
        if ((options = optionsList.toArray()).length == 0) {
            throw new IllegalArgumentException("At least one of yes, no, or never must be non-null");
        }
        String initial = no == null ? options[0] : no;
        CompletableFuture future = new CompletableFuture();
        SwingUtilities.invokeLater(() -> {
            Component parentComp = parent;
            boolean disposeParent = false;
            if (parentComp == null) {
                parentComp = new JFrame();
                ((JFrame)parentComp).setAlwaysOnTop(true);
                ((JFrame)parentComp).setLocationRelativeTo(null);
                disposeParent = true;
            }
            int result = JOptionPane.showOptionDialog(parentComp, message, title, optionType, messageType, icon, options, initial);
            if (disposeParent) {
                ((JFrame)parentComp).dispose();
            }
            future.complete(result);
        });
        int choice = 0;
        try {
            choice = (Integer)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            choice = -1;
        }
        switch (choice) {
            case 0: {
                return Result.YES;
            }
            case 1: {
                return Result.NO;
            }
            case 2: {
                return Result.NEVER;
            }
            case -1: {
                return Result.CANCELED;
            }
        }
        throw new RuntimeException("Unexpected value: " + choice);
    }

    public static void main(String[] args) {
        Result result = Dialogs.ask(null, "Do you like green eggs and ham?", "Yes", "I do not like green eggs and ham", "I do not like them, Sam-I-am");
        System.out.println((Object)result);
    }

    public static enum Result {
        YES,
        NO,
        NEVER,
        CANCELED;

    }
}

