/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import fiji.plugin.Multi_View_Deconvolution;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.spim.fusion.CombinedPixelWeightener;
import mpicbg.spim.fusion.CombinedPixelWeightenerFactory;
import mpicbg.spim.fusion.IsolatedPixelWeightener;
import mpicbg.spim.fusion.IsolatedPixelWeightenerFactory;
import mpicbg.spim.fusion.PreDeconvolutionFusionInterface;
import mpicbg.spim.fusion.PreDeconvolutionFusionSequential;
import mpicbg.spim.fusion.SPIMImageFusion;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.Java3d;
import mpicbg.spim.postprocessing.deconvolution.ExtractPSF;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import spim.vecmath.Point3d;

public class PreDeconvolutionFusion
extends SPIMImageFusion
implements PreDeconvolutionFusionInterface {
    final Image<FloatType>[] images;
    final Image<FloatType>[] weights;
    final Image<FloatType> overlap;
    final int numViews;
    final boolean normalize;
    final ExtractPSF extractPSF;

    public PreDeconvolutionFusion(ViewStructure viewStructure, ViewStructure referenceViewStructure, ArrayList<IsolatedPixelWeightenerFactory<?>> isolatedWeightenerFactories, ArrayList<CombinedPixelWeightenerFactory<?>> combinedWeightenerFactories) {
        super(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories);
        this.normalize = true;
        if (viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused image.");
        }
        ImageFactory imageFactory = new ImageFactory((Type)new FloatType(), this.conf.processImageFactory);
        this.numViews = viewStructure.getNumViews();
        if (this.conf.deconvolutionJustShowOverlap) {
            this.overlap = imageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "overlap");
            this.images = null;
            this.weights = null;
            this.extractPSF = null;
        } else {
            this.overlap = null;
            this.extractPSF = this.conf.extractPSF ? new ExtractPSF(viewStructure) : ExtractPSF.loadAndTransformPSF(this.conf.psfFiles, this.conf.transformPSFs, viewStructure);
            this.images = new Image[this.numViews];
            this.weights = new Image[this.numViews];
            if (this.extractPSF == null) {
                return;
            }
            for (int view = 0; view < this.numViews; ++view) {
                this.weights[view] = imageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "weights_" + view);
                this.images[view] = imageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "view_" + view);
                if (this.images[view] != null && this.weights[view] != null) continue;
                if (viewStructure.getDebugLevel() <= 2) {
                    IOFunctions.println("PreDeconvolutionFusion.constructor: Cannot create output image: " + this.conf.processImageFactory.getErrorMessage());
                }
                return;
            }
        }
    }

    public static void subtractBackground(Image<FloatType> img, float value) {
        for (FloatType t : img) {
            t.set(Math.max(0.0f, t.get() - value));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fuseSPIMImages(int channelIndex) {
        int ithread;
        final ArrayList<ViewDataBeads> views = new ArrayList<ViewDataBeads>();
        for (ViewDataBeads viewDataBeads : this.viewStructure.getViews()) {
            if (viewDataBeads.getChannelIndex() != channelIndex) continue;
            views.add(viewDataBeads);
        }
        final int numViews = views.size();
        if (this.conf.deconvolutionJustShowOverlap) {
            PreDeconvolutionFusionSequential.computeOverlap(this.overlap, views, this.viewStructure, this.cropOffsetX, this.cropOffsetY, this.cropOffsetZ, this.scale, this.min);
            return;
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Loading source images (Channel " + channelIndex + ").");
        }
        if (channelIndex > 0) {
            return;
        }
        for (ViewDataBeads view : views) {
            view.getImage();
            if (Multi_View_Deconvolution.subtractBackground == 0.0f) continue;
            if (this.viewStructure.getDebugLevel() <= 2) {
                IOFunctions.println("PreDeconvolutionFusionSequential(): Subtracting background of " + Multi_View_Deconvolution.subtractBackground + " from " + view.getName());
            }
            PreDeconvolutionFusion.subtractBackground(view.getImage(false), Multi_View_Deconvolution.subtractBackground);
            view.getImage(true);
        }
        if (this.viewStructure.getDebugLevel() <= 1 && this.isolatedWeightenerFactories.size() > 0) {
            void var4_8;
            String string = "(" + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(0)).getDescriptiveName();
            for (int i = 1; i < this.isolatedWeightenerFactories.size(); ++i) {
                String string2 = (String)var4_8 + ", " + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(i)).getDescriptiveName();
            }
            String string3 = (String)var4_8 + ")";
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Init isolated weighteners for all views " + string3);
        }
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.conf.numberOfThreads);
        final int numThreads = threads.length;
        IsolatedPixelWeightener[][] isoWinit = new IsolatedPixelWeightener[this.isolatedWeightenerFactories.size()][numViews];
        for (int j = 0; j < isoWinit.length; ++j) {
            final int i = j;
            final IsolatedPixelWeightener[][] isoW = isoWinit;
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = atomicInteger.getAndIncrement();
                        for (int view = 0; view < numViews; ++view) {
                            if (view % numThreads != myNumber) continue;
                            IOFunctions.println("Computing " + ((IsolatedPixelWeightenerFactory)PreDeconvolutionFusion.this.isolatedWeightenerFactories.get(i)).getDescriptiveName() + " for " + views.get(view));
                            isoW[i][view] = ((IsolatedPixelWeightenerFactory)PreDeconvolutionFusion.this.isolatedWeightenerFactories.get(i)).createInstance((ViewDataBeads)views.get(view));
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threads);
        }
        try {
            boolean successful = true;
            IsolatedPixelWeightener[][] i = isoWinit;
            int isoW = i.length;
            for (ithread = 0; ithread < isoW; ++ithread) {
                IsolatedPixelWeightener[] iso;
                for (IsolatedPixelWeightener i2 : iso = i[ithread]) {
                    if (i2 != null) continue;
                    successful = false;
                }
            }
            if (!successful) {
                IOFunctions.println("Not enough memory for computing the weights for the multi-view deconvolution.");
                isoWinit = new IsolatedPixelWeightener[0][0];
            }
        }
        catch (Exception e) {
            IOFunctions.println("Not enough memory for computing the weights for the multi-view deconvolution.");
            isoWinit = new IsolatedPixelWeightener[0][0];
        }
        final IsolatedPixelWeightener[][] isoW = isoWinit;
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing output image (Channel " + channelIndex + ").");
        }
        final boolean[] useView = new boolean[numViews];
        final AbstractAffineModel3D[] models = new AbstractAffineModel3D[numViews];
        for (int i = 0; i < numViews; ++i) {
            boolean bl = useView[i] = Math.max(views.get(i).getViewErrorStatistics().getNumConnectedViews(), views.get(i).getTile().getConnectedTiles().size()) > 0 || views.get(i).getViewStructure().getNumViews() == 1;
            if (!views.get(i).getUseForRegistration()) {
                int angle = views.get(i).getAcqusitionAngle();
                int timepoint = views.get(i).getViewStructure().getTimePoint();
                for (ViewDataBeads view2 : this.viewStructure.getViews()) {
                    if (view2.getAcqusitionAngle() != angle || timepoint != view2.getViewStructure().getTimePoint() || !view2.getUseForRegistration()) continue;
                    useView[i] = true;
                }
            }
            models[i] = (AbstractAffineModel3D)views.get(i).getTile().getModel();
        }
        final int[][] imageSizes = new int[numViews][];
        for (int i = 0; i < numViews; ++i) {
            imageSizes[i] = views.get(i).getImageSize();
        }
        atomicInteger.set(0);
        threads = SimpleMultiThreading.newThreads((int)numThreads);
        for (int ithread2 = 0; ithread2 < threads.length; ++ithread2) {
            threads[ithread2] = new Thread(new Runnable(){

                @Override
                public void run() {
                    block29: {
                        try {
                            int i;
                            int i2;
                            int myNumber = atomicInteger.getAndIncrement();
                            double[] tmp = new double[3];
                            if (PreDeconvolutionFusion.this.viewStructure.getDebugLevel() <= 1 && PreDeconvolutionFusion.this.combinedWeightenerFactories.size() > 0) {
                                String methods = "(" + ((CombinedPixelWeightenerFactory)PreDeconvolutionFusion.this.combinedWeightenerFactories.get(0)).getDescriptiveName();
                                for (i2 = 1; i2 < PreDeconvolutionFusion.this.combinedWeightenerFactories.size(); ++i2) {
                                    methods = methods + ", " + ((CombinedPixelWeightenerFactory)PreDeconvolutionFusion.this.combinedWeightenerFactories.get(i2)).getDescriptiveName();
                                }
                                methods = methods + ")";
                                if (myNumber == 0) {
                                    IOFunctions.println("Initialize combined weighteners for all views " + methods);
                                }
                            }
                            CombinedPixelWeightener[] combW = new CombinedPixelWeightener[PreDeconvolutionFusion.this.combinedWeightenerFactories.size()];
                            for (i2 = 0; i2 < combW.length; ++i2) {
                                combW[i2] = ((CombinedPixelWeightenerFactory)PreDeconvolutionFusion.this.combinedWeightenerFactories.get(i2)).createInstance(views);
                            }
                            LocalizableByDimCursor[][] isoIterators = new LocalizableByDimCursor[isoW.length][numViews];
                            for (int i3 = 0; i3 < isoW.length; ++i3) {
                                for (int view = 0; view < isoW[i3].length; ++view) {
                                    isoIterators[i3][view] = isoW[i3][view].getResultIterator();
                                }
                            }
                            Point3d[] tmpCoordinates = new Point3d[numViews];
                            int[][] loc = new int[numViews][3];
                            double[][] locd = new double[numViews][3];
                            boolean[] use = new boolean[numViews];
                            for (int i4 = 0; i4 < numViews; ++i4) {
                                tmpCoordinates[i4] = new Point3d();
                            }
                            LocalizableCursor[] outIntensity = new LocalizableCursor[numViews];
                            LocalizableCursor[] outWeights = new LocalizableCursor[numViews];
                            float[] tmpWeights = new float[numViews];
                            for (int i5 = 0; i5 < numViews; ++i5) {
                                outIntensity[i5] = PreDeconvolutionFusion.this.images[i5].createLocalizableCursor();
                                outWeights[i5] = PreDeconvolutionFusion.this.weights[i5].createLocalizableCursor();
                            }
                            LocalizableCursor firstCursor = outIntensity[0];
                            Interpolator[] interpolators = new Interpolator[numViews];
                            for (int view = 0; view < numViews; ++view) {
                                interpolators[view] = ((ViewDataBeads)views.get(view)).getImage().createInterpolator(PreDeconvolutionFusion.this.conf.interpolatorFactorOutput);
                            }
                            while (firstCursor.hasNext()) {
                                int view;
                                for (i = 0; i < numViews; ++i) {
                                    outIntensity[i].fwd();
                                    outWeights[i].fwd();
                                }
                                if (firstCursor.getPosition(2) % numThreads != myNumber) continue;
                                int x = firstCursor.getPosition(0) + PreDeconvolutionFusion.this.cropOffsetX;
                                int y = firstCursor.getPosition(1) + PreDeconvolutionFusion.this.cropOffsetY;
                                int z = firstCursor.getPosition(2) + PreDeconvolutionFusion.this.cropOffsetZ;
                                int num = 0;
                                for (int i6 = 0; i6 < numViews; ++i6) {
                                    if (!useView[i6]) continue;
                                    tmpCoordinates[i6].x = (float)(x * PreDeconvolutionFusion.this.scale) + PreDeconvolutionFusion.this.min.x;
                                    tmpCoordinates[i6].y = (float)(y * PreDeconvolutionFusion.this.scale) + PreDeconvolutionFusion.this.min.y;
                                    tmpCoordinates[i6].z = (float)(z * PreDeconvolutionFusion.this.scale) + PreDeconvolutionFusion.this.min.z;
                                    Java3d.applyInverseInPlace(models[i6], tmpCoordinates[i6], tmp);
                                    loc[i6][0] = (int)Util.round((double)tmpCoordinates[i6].x);
                                    loc[i6][1] = (int)Util.round((double)tmpCoordinates[i6].y);
                                    loc[i6][2] = (int)Util.round((double)tmpCoordinates[i6].z);
                                    locd[i6][0] = tmpCoordinates[i6].x;
                                    locd[i6][1] = tmpCoordinates[i6].y;
                                    locd[i6][2] = tmpCoordinates[i6].z;
                                    if (loc[i6][0] >= 0 && loc[i6][1] >= 0 && loc[i6][2] >= 0 && loc[i6][0] < imageSizes[i6][0] && loc[i6][1] < imageSizes[i6][1] && loc[i6][2] < imageSizes[i6][2]) {
                                        use[i6] = true;
                                        ++num;
                                        continue;
                                    }
                                    use[i6] = false;
                                }
                                if (num <= 0) continue;
                                if (combW.length > 0) {
                                    for (CombinedPixelWeightener w : combW) {
                                        w.updateWeights(locd, use);
                                    }
                                }
                                float sumWeights = 0.0f;
                                for (view = 0; view < numViews; ++view) {
                                    if (!use[view]) continue;
                                    float weight = 1.0f;
                                    if (combW.length > 0) {
                                        for (CombinedPixelWeightener w : combW) {
                                            weight = (float)((double)weight * w.getWeight(view));
                                        }
                                    }
                                    for (int i7 = 0; i7 < isoW.length; ++i7) {
                                        isoIterators[i7][view].setPosition(loc[view]);
                                        weight *= ((FloatType)isoIterators[i7][view].getType()).get();
                                    }
                                    tmp[0] = tmpCoordinates[view].x;
                                    tmp[1] = tmpCoordinates[view].y;
                                    tmp[2] = tmpCoordinates[view].z;
                                    interpolators[view].moveTo(tmp);
                                    if (PreDeconvolutionFusion.this.normalize) {
                                        sumWeights += weight;
                                        tmpWeights[view] = weight;
                                    } else {
                                        ((FloatType)outWeights[view].getType()).set(weight);
                                    }
                                    ((FloatType)outIntensity[view].getType()).set(((FloatType)interpolators[view].getType()).get());
                                }
                                if (!PreDeconvolutionFusion.this.normalize || !(sumWeights > 0.0f)) continue;
                                for (view = 0; view < numViews; ++view) {
                                    if (!use[view]) continue;
                                    if (sumWeights > 1.0f) {
                                        ((FloatType)outWeights[view].getType()).set(tmpWeights[view] / sumWeights);
                                        continue;
                                    }
                                    ((FloatType)outWeights[view].getType()).set(tmpWeights[view]);
                                }
                            }
                            for (i = 0; i < numViews; ++i) {
                                outIntensity[i].close();
                                outWeights[i].close();
                                interpolators[i].close();
                            }
                            for (i = 0; i < combW.length; ++i) {
                                combW[i].close();
                            }
                            for (i = 0; i < isoW.length; ++i) {
                                for (int view = 0; view < isoW[i].length; ++view) {
                                    isoIterators[i][view].close();
                                }
                            }
                        }
                        catch (NoninvertibleModelException e) {
                            if (PreDeconvolutionFusion.this.viewStructure.getDebugLevel() > 2) break block29;
                            IOFunctions.println("MappingFusionParalell(): Model not invertible for " + PreDeconvolutionFusion.this.viewStructure);
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Closing all input images (Channel " + channelIndex + ").");
        }
        if (this.conf.extractPSF) {
            if (this.viewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("Extracting all PSF's");
            }
            this.extractPSF.extract();
        }
        for (ViewDataBeads view : views) {
            view.closeImage();
        }
        try {
            for (int i = 0; i < isoW.length; ++i) {
                for (int view = 0; view < numViews; ++view) {
                    isoW[i][view].close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Done computing output image (Channel " + channelIndex + ").");
        }
    }

    @Override
    public Image<FloatType> getFusedImage() {
        return null;
    }

    @Override
    public Image<FloatType> getFusedImage(int index) {
        return this.images[index];
    }

    @Override
    public Image<FloatType> getWeightImage(int index) {
        return this.weights[index];
    }

    @Override
    public void closeImages() {
        for (ViewDataBeads view : this.viewStructure.getViews()) {
            view.closeImage();
        }
    }

    @Override
    public ArrayList<Image<FloatType>> getPointSpreadFunctions() {
        return this.extractPSF.getPSFs();
    }

    @Override
    public ExtractPSF getExtractPSFInstance() {
        return this.extractPSF;
    }

    @Override
    public Image<FloatType> getOverlapImage() {
        return this.overlap;
    }
}

