/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration;

import fiji.plugin.Multi_View_Deconvolution;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.gauss.DownSample;
import mpicbg.imglib.algorithm.mirror.MirrorImage;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.cell.CellContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.io.LOCI;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.TileSPIM;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.BeadStructure;
import mpicbg.spim.registration.bead.error.ViewErrorStatistics;
import mpicbg.spim.registration.segmentation.NucleusStructure;
import spim.Threads;
import spim.vecmath.Matrix4d;
import spim.vecmath.Transform3D;
import spimopener.SPIMExperiment;

public class ViewDataBeads
implements Comparable<ViewDataBeads> {
    public static float[] minmaxset = null;
    final AbstractAffineModel3D<?> uninitializedModel;
    protected ViewStructure viewStructure = null;
    protected BeadStructure beads;
    protected NucleusStructure nuclei;
    protected ViewErrorStatistics viewError = null;
    protected int id;
    protected int channel = 0;
    protected int channelIndex = 0;
    protected boolean useForRegistration = true;
    protected boolean useForFusion = true;
    protected float initialSigma = 1.8f;
    protected float minPeakValue = 0.01f;
    protected float minInitialPeakValue = 0.001f;
    protected int integralRadius1 = 2;
    protected int integralRadius2 = 4;
    protected float integralThreshold = 0.03f;
    protected int timePoint = 0;
    protected int angle;
    protected int illumination;
    private String fileName;
    private String shortName;
    private final TileSPIM tile;
    protected double zStretching = 1.0;
    protected int[] imageSize = null;
    protected int[] imageSizeOffset = null;
    private Image<FloatType> image = null;
    private boolean isNormalized;
    private float minValue = 0.0f;
    private float maxValue = 0.0f;
    protected Image<FloatType> downSampledImage = null;
    protected int currentDownSamplingFactor = -1;
    protected boolean mirrorVertically = false;
    protected boolean mirrorHorizontally = false;

    public <M extends AbstractAffineModel3D<M>> ViewDataBeads(int id, M model, String fileName, double zStretching) {
        this.setID(id);
        this.setFileName(fileName);
        this.setZStretching(zStretching);
        this.uninitializedModel = (AbstractAffineModel3D)model.copy();
        this.tile = new TileSPIM<AbstractAffineModel3D>((AbstractAffineModel3D)model.copy(), this);
        this.beads = new BeadStructure();
        this.nuclei = new NucleusStructure();
    }

    public AbstractAffineModel3D<?> getUninitializedModel() {
        return this.uninitializedModel;
    }

    public boolean isConnected() {
        return this.getViewErrorStatistics().getNumConnectedViews() > 0;
    }

    protected void setViewStructure(ViewStructure viewStructure) {
        this.viewStructure = viewStructure;
    }

    public ViewStructure getViewStructure() {
        return this.viewStructure;
    }

    public int getNumViews() {
        return this.getViewStructure().getViews().size();
    }

    public BeadStructure getBeadStructure() {
        return this.beads;
    }

    public void setBeadStructure(BeadStructure beads) {
        this.beads = beads;
    }

    public NucleusStructure getNucleiStructure() {
        return this.nuclei;
    }

    public void setNucleiStructure(NucleusStructure nuclei) {
        this.nuclei = nuclei;
    }

    public void initErrorStatistics() {
        this.viewError = new ViewErrorStatistics(this);
    }

    public ViewErrorStatistics getViewErrorStatistics() {
        return this.viewError;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public void setChannelIndex(int channelIndex) {
        this.channelIndex = channelIndex;
    }

    public int getTimePoint() {
        return this.timePoint;
    }

    public void setTimePoint(int timePoint) {
        this.timePoint = timePoint;
    }

    public boolean getUseForRegistration() {
        return this.useForRegistration;
    }

    public void setUseForRegistration(boolean useForRegistration) {
        this.useForRegistration = useForRegistration;
    }

    public boolean getUseForFusion() {
        return this.useForFusion;
    }

    public void setUseForFusion(boolean useForFusion) {
        this.useForFusion = useForFusion;
    }

    public void setIntegralRadius1(int r1) {
        this.integralRadius1 = r1;
    }

    public void setIntegralRadius2(int r2) {
        this.integralRadius2 = r2;
    }

    public void setIntegralThreshold(float threshold) {
        this.integralThreshold = threshold;
    }

    public void setInitialSigma(float s) {
        this.initialSigma = s;
    }

    public void setMinPeakValue(float m) {
        this.minPeakValue = m;
        this.minInitialPeakValue = m / 10.0f;
    }

    public void setMinInitialPeakValue(float m) {
        this.minInitialPeakValue = m;
    }

    public float getInitialSigma() {
        return this.initialSigma;
    }

    public float getMinPeakValue() {
        return this.minPeakValue;
    }

    public float getMinInitialPeakValue() {
        return this.minInitialPeakValue;
    }

    public int getIntegralRadius1() {
        return this.integralRadius1;
    }

    public int getIntegralRadius2() {
        return this.integralRadius2;
    }

    public float getIntegralThreshold() {
        return this.integralThreshold;
    }

    public int getAcqusitionAngle() {
        return this.angle;
    }

    public void setAcqusitionAngle(int angle) {
        this.angle = angle;
    }

    public int getIllumination() {
        return this.illumination;
    }

    public void setIllumination(int illumination) {
        this.illumination = illumination;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.shortName = IOFunctions.getShortName(fileName);
    }

    public String getName() {
        return this.shortName;
    }

    public void setName(String shortName) {
        this.shortName = shortName;
    }

    public TileSPIM getTile() {
        return this.tile;
    }

    public Transform3D getTransform3D() {
        Matrix4d matrix = new Matrix4d();
        double[] m = ((AbstractAffineModel3D)this.getTile().getModel()).getMatrix(null);
        matrix.m00 = m[0];
        matrix.m01 = m[1];
        matrix.m02 = m[2];
        matrix.m03 = m[3];
        matrix.m10 = m[4];
        matrix.m11 = m[5];
        matrix.m12 = m[6];
        matrix.m13 = m[7];
        matrix.m20 = m[8];
        matrix.m21 = m[9];
        matrix.m22 = m[10];
        matrix.m23 = m[11];
        matrix.m30 = 0.0;
        matrix.m31 = 0.0;
        matrix.m32 = 0.0;
        matrix.m33 = 1.0;
        return new Transform3D(matrix);
    }

    public double getZStretching() {
        return this.zStretching;
    }

    public void setZStretching(double zStretching) {
        this.zStretching = zStretching;
    }

    public int[] getImageSize() {
        if (this.imageSize == null) {
            this.loadDimensions();
        }
        return (int[])this.imageSize.clone();
    }

    public void setImageSize(int[] size) {
        this.imageSize = size;
    }

    public int[] getImageSizeOffset() {
        if (this.imageSizeOffset == null) {
            return new int[this.getImageSize().length];
        }
        return (int[])this.imageSizeOffset.clone();
    }

    public void setImageSizeOffset(int[] imageSizeOffset) {
        this.imageSizeOffset = imageSizeOffset;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public int getNumDimensions() {
        return this.getImageSize().length;
    }

    public float getMaxValueUnnormed() {
        return this.maxValue;
    }

    public Image<FloatType> getImage() {
        return this.getImage(true);
    }

    public Image<FloatType> getImage(boolean normalize) {
        return this.getImage(this.getViewStructure().getSPIMConfiguration().inputImageFactory, normalize);
    }

    public Image<FloatType> getDownSampledImage(int downSamplingFactor) {
        return this.getDownSampledImage(downSamplingFactor, true);
    }

    public Image<FloatType> getDownSampledImage(int downSamplingFactor, boolean normalize) {
        if (downSamplingFactor == 1) {
            return this.getImage();
        }
        if (this.downSampledImage != null && downSamplingFactor == this.currentDownSamplingFactor) {
            return this.downSampledImage;
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Computing " + downSamplingFactor + "x Downsampling for " + this.getName());
        }
        this.currentDownSamplingFactor = downSamplingFactor;
        Image<FloatType> img = this.getImage();
        DownSample downSample = new DownSample(img, 1.0f / (float)downSamplingFactor);
        if (!downSample.checkInput() || !downSample.process()) {
            IOFunctions.println("Error, cannot downSample image: " + downSample.getErrorMessage());
            return null;
        }
        this.downSampledImage = downSample.getResult();
        return this.downSampledImage;
    }

    public void setMirrorHorizontally(boolean state) {
        this.mirrorHorizontally = state;
    }

    public void setMirrorVertically(boolean state) {
        this.mirrorVertically = state;
    }

    public boolean getMirrorHorizontally() {
        return this.mirrorHorizontally;
    }

    public boolean getMirrorVertically() {
        return this.mirrorVertically;
    }

    public Image<FloatType> getImage(ContainerFactory imageFactory) {
        return this.getImage(imageFactory, true);
    }

    public Image<FloatType> getImage(ContainerFactory imageFactory, boolean normalize) {
        if (this.image == null) {
            MirrorImage mirror;
            if (this.getViewStructure().getSPIMConfiguration().isHuiskenFormat()) {
                ImagePlus imp;
                SPIMExperiment exp = this.getViewStructure().getSPIMConfiguration().getSpimExperiment();
                int s = exp.sampleStart;
                int r = exp.regionStart;
                int f = exp.frameStart;
                int zMin = exp.planeStart;
                int zMax = exp.planeEnd;
                boolean xMin = false;
                int xMax = exp.w - 1;
                boolean yMin = false;
                int yMax = exp.h - 1;
                if (this.getViewStructure().getSPIMConfiguration().hasAlternatingIllumination()) {
                    int zStep = 2;
                    imp = this.illumination == 0 ? exp.openNotProjected(s, this.timePoint, this.timePoint, r, this.angle, this.channel, zMin, zMax - 1, 2, f, f, 0, yMax, 0, xMax, 0, 1, 3, false) : exp.openNotProjected(s, this.timePoint, this.timePoint, r, this.angle, this.channel, zMin + 1, zMax, 2, f, f, 0, yMax, 0, xMax, 0, 1, 3, false);
                } else {
                    imp = exp.openNotProjected(s, this.timePoint, this.timePoint, r, this.angle, this.channel, zMin, zMax, f, f, 0, yMax, 0, xMax, 0, 1, 3, false);
                }
                this.image = ImageJFunctions.convertFloat((ImagePlus)imp);
                this.image.setCalibration(new float[]{1.0f, 1.0f, (float)this.getViewStructure().getSPIMConfiguration().getZStretchingHuisken()});
            } else {
                String s = this.getFileName();
                try {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Opening '" + s + "' [" + imageFactory.getClass().getSimpleName() + "]");
                    this.image = LOCI.openLOCIFloatType((String)s, (ContainerFactory)imageFactory);
                }
                catch (Exception e) {
                    this.image = null;
                }
                if (this.image == null) {
                    IOFunctions.println("Cannot open file: " + s);
                    File f = new File(s);
                    if (f.exists()) {
                        IJ.log((String)("File: " + f.getAbsolutePath() + " exists, trying to open with CellImg."));
                        this.image = LOCI.openLOCIFloatType((String)s, (ContainerFactory)new CellContainerFactory(256));
                        if (this.image == null) {
                            IJ.log((String)("Opening file: " + f.getAbsolutePath() + " with CellImg failed, too."));
                            return null;
                        }
                        this.getViewStructure().getSPIMConfiguration().inputImageFactory = this.image.getContainerFactory();
                        Multi_View_Deconvolution.defaultContainerInput = 1;
                    } else {
                        IJ.log((String)("File does not exist: " + f.getAbsolutePath()));
                        return null;
                    }
                }
            }
            if (this.getViewStructure().getSPIMConfiguration().overrideImageZStretching) {
                this.image.setCalibration(new float[]{1.0f, 1.0f, (float)this.getViewStructure().getSPIMConfiguration().zStretching});
            }
            if (this.getMirrorHorizontally()) {
                IOFunctions.println("Mirroring horizontally: " + this);
                mirror = new MirrorImage(this.image, 0);
                mirror.process();
            }
            if (this.getMirrorVertically()) {
                IOFunctions.println("Mirroring vertically: " + this);
                mirror = new MirrorImage(this.image, 1);
                mirror.process();
            }
            this.image.setName(this.getName());
            if (normalize) {
                float[] minmax = ViewDataBeads.normalizeImage(this.image, minmaxset);
                this.minValue = minmax[0];
                this.maxValue = minmax[1];
                this.isNormalized = true;
            } else {
                if (minmaxset == null) {
                    this.image.getDisplay().setMinMax();
                    this.minValue = (float)this.image.getDisplay().getMin();
                    this.maxValue = (float)this.image.getDisplay().getMax();
                } else {
                    this.minValue = minmaxset[0];
                    this.maxValue = minmaxset[1];
                }
                this.isNormalized = false;
            }
            this.setImageSize(this.image.getDimensions());
            IOFunctions.writeDim(this, this.getViewStructure().getSPIMConfiguration().registrationFiledirectory);
        }
        if (this.isNormalized && !normalize) {
            this.unnormalizeImage();
        }
        if (!this.isNormalized && normalize) {
            this.normalizeImage();
        }
        return this.image;
    }

    public void unnormalizeImage() {
        if (this.image == null) {
            this.getImage(false);
        } else if (this.isNormalized) {
            float diff = this.maxValue - this.minValue;
            for (FloatType f : this.image) {
                f.set(f.get() * diff + this.minValue);
            }
            this.isNormalized = false;
        }
    }

    public void normalizeImage() {
        if (this.image == null) {
            this.getImage(true);
        } else if (!this.isNormalized) {
            float diff = this.maxValue - this.minValue;
            for (FloatType f : this.image) {
                f.set((f.get() - this.minValue) / diff);
            }
            this.isNormalized = true;
        }
    }

    public static float[] normalizeImage(Image<FloatType> image) {
        return ViewDataBeads.normalizeImage(image, null);
    }

    public static float[] normalizeImage(final Image<FloatType> image, float[] minmax) {
        if (minmax == null || minmax.length < 2) {
            image.getDisplay().setMinMax();
        } else {
            image.getDisplay().setMinMax((double)minmax[0], (double)minmax[1]);
        }
        final float min = (float)image.getDisplay().getMin();
        float max = (float)image.getDisplay().getMax();
        final float diff = max - min;
        if (Float.isNaN(diff) || Float.isInfinite(diff) || diff == 0.0f) {
            IOFunctions.println("Cannot normalize image " + image.getName() + ", min=" + min + "  + max=" + max);
            return new float[]{min, max};
        }
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)image.getNumPixels(), (int)Threads.numThreads());
        int numThreads = threadChunks.size();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    long loopSize = myChunk.getLoopSize();
                    Cursor cursor = image.createCursor();
                    cursor.fwd(myChunk.getStartPosition());
                    for (long l = 0L; l < loopSize; ++l) {
                        cursor.fwd();
                        float value = ((FloatType)cursor.getType()).get();
                        float norm = (value - min) / diff;
                        ((FloatType)cursor.getType()).set(norm);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        image.getDisplay().setMinMax(0.0, 1.0);
        return new float[]{min, max};
    }

    public void closeImage() {
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    public String toString() {
        return this.getName() + " (id = " + this.getID() + ")";
    }

    public boolean loadRegistration() {
        String dir;
        boolean readReg;
        if (this.getViewStructure().debugLevel <= 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading " + this + " registration");
        }
        if (!(readReg = IOFunctions.readRegistration(this, (dir = this.getViewStructure().getSPIMConfiguration().registrationFiledirectory) + this.getName() + ".registration"))) {
            if (this.getViewStructure().debugLevel <= 2) {
                IOFunctions.println("Cannot read registration for " + this);
            }
            return false;
        }
        return true;
    }

    public boolean loadRegistrationTimePoint(int referenceTimePoint) {
        String dir;
        boolean readReg;
        if (this.getViewStructure().debugLevel <= 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading " + this + " registration relative to time point " + referenceTimePoint);
        }
        if (!(readReg = IOFunctions.readRegistration(this, (dir = this.getViewStructure().getSPIMConfiguration().registrationFiledirectory) + this.getName() + ".registration.to_" + referenceTimePoint))) {
            if (this.getViewStructure().debugLevel <= 2) {
                IOFunctions.println("Cannot read registration for " + this + " relative to time point " + referenceTimePoint);
            }
            return false;
        }
        return true;
    }

    public boolean writeRegistration() {
        if (this.getViewStructure().debugLevel <= 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Writing " + this + " registration");
        }
        return IOFunctions.writeRegistration(this, this.getViewStructure().getSPIMConfiguration().registrationFiledirectory);
    }

    public boolean writeRegistrationTimeLapse(int referenceTimePoint) {
        if (this.getViewStructure().debugLevel <= 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Writing " + this + " registration relative to time point " + referenceTimePoint);
        }
        return IOFunctions.writeRegistration(this, this.getViewStructure().getSPIMConfiguration().registrationFiledirectory, ".to_" + referenceTimePoint);
    }

    public boolean loadSegmentation() {
        if (this.getViewStructure().debugLevel <= 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading " + this + " segmentation");
        }
        boolean readSeg = IOFunctions.readSegmentation(this, this.getViewStructure().getSPIMConfiguration().registrationFiledirectory, this.getViewStructure().getSPIMConfiguration());
        if (this.viewStructure.getDebugLevel() <= 0) {
            if (this.getBeadStructure() != null) {
                IOFunctions.println("Loaded " + this.getBeadStructure().getDetectionList().size() + " beads for " + this.getName() + "[" + this.getImageSize()[0] + "x" + this.getImageSize()[1] + "x" + this.getImageSize()[2] + "]");
            } else {
                IOFunctions.println("Detection loading FAILED for " + this.getName() + "[" + this.getImageSize()[0] + "x" + this.getImageSize()[1] + "x" + this.getImageSize()[2] + "]");
            }
        }
        if (!readSeg) {
            if (this.getViewStructure().debugLevel <= 2) {
                IOFunctions.println("Cannot read segmentation for " + this);
            }
            return false;
        }
        return true;
    }

    public boolean writeSegmentation() {
        if (this.getViewStructure().debugLevel <= 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Writing " + this + " registration");
        }
        return IOFunctions.writeSegmentation(this, this.getViewStructure().getSPIMConfiguration().registrationFiledirectory);
    }

    public boolean loadDimensions() {
        boolean readDim;
        if (this.getViewStructure().getDebugLevel() <= 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading " + this + " dimensions");
        }
        if (!(readDim = IOFunctions.readDim(this, this.getViewStructure().getSPIMConfiguration().registrationFiledirectory))) {
            if (this.getViewStructure().debugLevel <= 2) {
                IOFunctions.println("Cannot read dimensions for " + this + ", trying to open image to determine them.");
            }
            if (this.getImage() == null) {
                return false;
            }
            this.closeImage();
            if (this.getImageSize() != null) {
                return true;
            }
        }
        return readDim;
    }

    @Override
    public int compareTo(ViewDataBeads o) {
        if (this.getID() < o.getID()) {
            return -1;
        }
        if (o.getID() == this.getID()) {
            return 0;
        }
        return 1;
    }
}

