/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.segmentation;

import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.Model;
import mpicbg.models.RigidModel3D;
import mpicbg.pointdescriptor.model.FixedModel;
import mpicbg.pointdescriptor.model.TranslationInvariantFixedModel;

public class NucleiConfiguration {
    public boolean readNuclei = true;
    public boolean readRegistration = false;
    public boolean registerOnly = true;
    public boolean reComputeGlobalOptimizationAndReadRANSACCorrespondences = false;
    public AbstractAffineModel3D<?> ransacModel = new AffineModel3D();
    public AbstractAffineModel3D<?> globalModel = new AffineModel3D();
    public AbstractAffineModel3D<?> icpModel = new AffineModel3D();
    public RotationAxis rotationAxis = RotationAxis.XAxis;
    public int maxAngleDifference = 360;
    public int timePointIndex = 0;
    public int timePoint = 0;
    public int neighbors = 3;
    public int neighborsRange = 4;
    public int maxEpsilon = 6;
    public float minInlierRatio = 0.1f;
    public float nTimesBetter = 5.0f;
    public float minPeakValue = 0.03f;
    public float sigma = 2.153f;
    public boolean lookForMaxima = true;

    public TranslationInvariantFixedModel getFixedModel(Model ransacModel) {
        TranslationInvariantFixedModel fixedModel;
        System.out.println(ransacModel);
        if (ransacModel instanceof RigidModel3D) {
            RigidModel3D model = (RigidModel3D)ransacModel;
            double[] m = model.getMatrix(null);
            fixedModel = new TranslationInvariantFixedModel(m[0], m[1], m[2], m[4], m[5], m[6], m[8], m[9], m[10]);
        } else {
            AffineModel3D model = (AffineModel3D)ransacModel;
            double[] m = model.getMatrix(null);
            fixedModel = new TranslationInvariantFixedModel(m[0], m[1], m[2], m[4], m[5], m[6], m[8], m[9], m[10]);
        }
        return fixedModel;
    }

    public FixedModel getFixedTranslationModel(Model ransacModel) {
        FixedModel fixedModel;
        System.out.println(ransacModel);
        if (ransacModel instanceof RigidModel3D) {
            RigidModel3D model = (RigidModel3D)ransacModel;
            double[] m = model.getMatrix(null);
            fixedModel = new FixedModel(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]);
        } else {
            AffineModel3D model = (AffineModel3D)ransacModel;
            double[] m = model.getMatrix(null);
            fixedModel = new FixedModel(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]);
        }
        return fixedModel;
    }

    public static enum RotationAxis {
        XAxis,
        YAxis,
        NoRotation;

    }
}

