/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.removedetections.InteractiveProjections;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class Interactive_Remove_Detections
implements PlugIn {
    public static int defaultAngleChoice = 0;
    public static int defaultChannelChoice = 0;
    public static int defaultIlluminationChoice = 0;
    public static int defaultTimepointChoice = 0;
    public static int defaultProjectionChoice = 0;
    public static int defaultLabel = 0;
    public static String defaultNewLabel = "Manually removed";
    protected static String[] projectionChoice = new String[]{"XY (Z-Projection)", "XZ (Y-Projection)", "YZ (X-Projection)"};

    public void run(String arg0) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("Interactively remove detections", false, false, false, false)) {
            return;
        }
        GenericDialog gd = new GenericDialog("Select View");
        List<TimePoint> timepoints = result.getTimePointsToProcess();
        String[] timepointNames = new String[timepoints.size()];
        for (int i = 0; i < timepointNames.length; ++i) {
            timepointNames[i] = result.getTimePointsToProcess().get(i).getName();
        }
        List angles = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getAllAnglesOrdered();
        String[] angleNames = new String[angles.size()];
        for (int i = 0; i < angles.size(); ++i) {
            angleNames[i] = ((Angle)angles.get(i)).getName();
        }
        List channels = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getAllChannelsOrdered();
        String[] channelNames = new String[channels.size()];
        for (int i = 0; i < channels.size(); ++i) {
            channelNames[i] = ((Channel)channels.get(i)).getName();
        }
        List illuminations = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getAllIlluminationsOrdered();
        String[] illuminationNames = new String[illuminations.size()];
        for (int i = 0; i < illuminations.size(); ++i) {
            illuminationNames[i] = ((Illumination)illuminations.get(i)).getName();
        }
        gd.addChoice("Angle", angleNames, angleNames[defaultAngleChoice]);
        gd.addChoice("Channel", channelNames, channelNames[defaultChannelChoice]);
        gd.addChoice("Illumination", illuminationNames, illuminationNames[defaultIlluminationChoice]);
        gd.addChoice("Timepoint", timepointNames, timepointNames[defaultTimepointChoice]);
        gd.addMessage("");
        gd.addChoice("Projection", projectionChoice, projectionChoice[defaultProjectionChoice]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        defaultAngleChoice = gd.getNextChoiceIndex();
        Angle angle = (Angle)angles.get(defaultAngleChoice);
        defaultChannelChoice = gd.getNextChoiceIndex();
        Channel channel = (Channel)channels.get(defaultChannelChoice);
        defaultIlluminationChoice = gd.getNextChoiceIndex();
        Illumination illumination = (Illumination)illuminations.get(defaultIlluminationChoice);
        defaultTimepointChoice = gd.getNextChoiceIndex();
        TimePoint tp = timepoints.get(defaultTimepointChoice);
        int projection = defaultProjectionChoice = gd.getNextChoiceIndex();
        ViewId viewId = SpimData2.getViewId((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription(), tp, channel, angle, illumination);
        String name = "angle: " + angle.getName() + " channel: " + channel.getName() + " illum: " + illumination.getName() + " timepoint: " + tp.getName();
        if (viewId == null) {
            IOFunctions.println("This ViewSetup is not present for this timepoint: angle: " + name);
            return;
        }
        ViewDescription viewDescription = ((SequenceDescription)((SpimData2)((Object)result.getData())).getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
        if (!viewDescription.isPresent()) {
            IOFunctions.println("This ViewSetup is not present for this timepoint: angle: " + name);
            return;
        }
        int projectionDim = 2 - projection;
        Pair<String, String> labels = Interactive_Remove_Detections.queryLabelAndNewLabel((SpimData2)((Object)result.getData()), viewDescription);
        if (labels == null) {
            return;
        }
        if (!Interactive_Remove_Detections.removeDetections((SpimData2)((Object)result.getData()), viewDescription, projectionDim, (String)labels.getA(), (String)labels.getB())) {
            return;
        }
        SpimData2.saveXML((SpimData2)((Object)result.getData()), result.getXMLFileName(), result.getClusterExtension());
    }

    public static Pair<String, String> queryLabelAndNewLabel(SpimData2 spimData, ViewDescription vd) {
        ViewInterestPoints interestPoints = spimData.getViewInterestPoints();
        ViewInterestPointLists lists = interestPoints.getViewInterestPointLists((ViewId)vd);
        if (lists.getHashMap().keySet().size() == 0) {
            IOFunctions.println("No interest points available for angle: " + ((ViewSetup)vd.getViewSetup()).getAngle().getName() + " channel: " + ((ViewSetup)vd.getViewSetup()).getChannel().getName() + " illum: " + ((ViewSetup)vd.getViewSetup()).getIllumination().getName() + " timepoint: " + vd.getTimePoint().getName());
            return null;
        }
        Object[] labels = new String[lists.getHashMap().keySet().size()];
        int i = 0;
        for (String string : lists.getHashMap().keySet()) {
            labels[i++] = string;
        }
        if (defaultLabel >= labels.length) {
            defaultLabel = 0;
        }
        Arrays.sort(labels);
        GenericDialog gd = new GenericDialog("Select Interest Points To Remove");
        gd.addChoice("Interest_Point_Label", (String[])labels, (String)labels[defaultLabel]);
        gd.addStringField("New_Label", defaultNewLabel, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        defaultLabel = gd.getNextChoiceIndex();
        Object object = labels[defaultLabel];
        String newLabel = gd.getNextString();
        return new ValuePair(object, (Object)newLabel);
    }

    public static boolean removeDetections(SpimData2 spimData, ViewDescription vd, int projectionDim, String label, String newLabel) {
        ViewInterestPoints interestPoints = spimData.getViewInterestPoints();
        ViewInterestPointLists lists = interestPoints.getViewInterestPointLists((ViewId)vd);
        InteractiveProjections ip = new InteractiveProjections(spimData, vd, label, newLabel, projectionDim);
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (ip.isRunning());
        if (ip.wasCanceled()) {
            return false;
        }
        List<InterestPoint> ipList = ip.getInterestPointList();
        if (ipList.size() == 0) {
            IOFunctions.println("No detections remaining. Quitting.");
            return false;
        }
        InterestPointList newIpl = new InterestPointList(lists.getInterestPointList(label).getBaseDir(), new File(lists.getInterestPointList(label).getFile().getParentFile(), "tpId_" + vd.getTimePointId() + "_viewSetupId_" + vd.getViewSetupId() + "." + newLabel));
        newIpl.setInterestPoints(ipList);
        newIpl.setParameters("manually removed detections from '" + label + "'");
        newIpl.saveInterestPoints();
        lists.addInterestPointList(newLabel, newIpl);
        return true;
    }

    public static void main(String[] args) {
        new ImageJ();
        new Interactive_Remove_Detections().run(null);
    }
}

