/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.util;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;

public class GUIHelper {
    public static Color good = new Color(0, 139, 14);
    public static Color warning = new Color(255, 100, 0);
    public static Color error = new Color(255, 0, 0);
    public static Color neutral = new Color(0, 0, 0);
    public static Font largestatusfont = new Font("SansSerif", 3, 14);
    public static Font largefont = new Font("SansSerif", 1, 14);
    public static Font mediumstatusfont = new Font("SansSerif", 3, 12);
    public static Font headline = new Font("SansSerif", 1, 12);
    public static Font smallStatusFont = new Font("SansSerif", 2, 11);
    public static Font staticfont = new Font("Monospaced", 0, 12);
    public static final String myURL = "http://www.preibisch.net/";
    public static final String paperURL = "http://www.nature.com/nmeth/journal/v7/n6/full/nmeth0610-418.html";
    public static final String messagePaper = "Please note that the SPIM Registration is based on a publication.\nIf you use it successfully for your research please be so kind to cite our work:\nPreibisch et al., Nature Methods (2010), 7(6):418-419\n";
    public static final String messageWebsite = "This plugin is written and maintained by Stephan Preibisch (click for webpage)\n";

    public static void addNatMethBeadsPaper(GenericDialog gd) {
        GUIHelper.addNatMethBeadsPaper(gd, messagePaper);
    }

    public static void addNatMethBeadsPaper(GenericDialog gd, String msg) {
        GUIHelper.addHyperLink(gd, msg, paperURL);
    }

    public static void addWebsite(GenericDialog gd) {
        GUIHelper.addWebsite(gd, messageWebsite);
    }

    public static void addWebsite(GenericDialog gd, String msg) {
        GUIHelper.addHyperLink(gd, msg, myURL);
    }

    public static final void addHyperLink(GenericDialog gd, String msg, String url) {
        gd.addMessage(msg, new Font("SansSerif", 3, 12));
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, url);
    }

    public static final void addPreibischLabWebsite(GenericDialog gd) {
        gd.addMessage("This software is developed by the Preibisch Lab in collaboration with the ImgLib2 and Fiji team\nhttp://preibischlab.mdc-berlin.de/", new Font("SansSerif", 1, 12));
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://preibischlab.github.io/preibisch-labsite");
    }

    public static void displayRegistrationNames(GenericDialog gd, HashMap<String, Integer> names) {
        if (names.keySet().size() == 0) {
            gd.addMessage("View Registrations could not be read. This should not happen.");
            return;
        }
        gd.addMessage("Title of last View Registrations", headline);
        ArrayList<String> n = new ArrayList<String>();
        for (String name : names.keySet()) {
            n.add(name + " (" + names.get(name) + " views)");
        }
        Collections.sort(n);
        String text = (String)n.get(0);
        for (int i = 1; i < n.size(); ++i) {
            text = text + "\n" + (String)n.get(i);
        }
        gd.addMessage(text, smallStatusFont);
    }

    public static HashMap<String, Integer> assembleRegistrationNames(SpimData data, List<ViewId> viewIds) {
        ViewRegistrations vr = data.getViewRegistrations();
        SequenceDescription sd = (SequenceDescription)data.getSequenceDescription();
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        for (ViewId viewId : viewIds) {
            ViewRegistration r;
            String rName;
            ViewDescription vd = sd.getViewDescription(viewId);
            if (!vd.isPresent() || (rName = ((ViewTransform)(r = vr.getViewRegistration((ViewId)vd)).getTransformList().get(0)).getName()) == null) continue;
            if (names.containsKey(rName)) {
                names.put(rName, names.get(rName) + 1);
                continue;
            }
            names.put(rName, 1);
        }
        return names;
    }

    public static final void addHyperLinkListener(final MultiLineLabel text, final String myURL) {
        if (text != null && myURL != null) {
            text.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        BrowserLauncher.openURL((String)myURL);
                    }
                    catch (Exception ex) {
                        IJ.log((String)("" + ex));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    text.setForeground(Color.BLUE);
                    text.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    text.setForeground(Color.BLACK);
                    text.setCursor(new Cursor(0));
                }
            });
        }
    }

    public static void addScrollBars(Container pane) {
        GridBagLayout layout = (GridBagLayout)pane.getLayout();
        int count = pane.getComponentCount();
        Component[] c = new Component[count];
        GridBagConstraints[] gbc = new GridBagConstraints[count];
        for (int i = 0; i < count; ++i) {
            c[i] = pane.getComponent(i);
            gbc[i] = layout.getConstraints(c[i]);
        }
        pane.removeAll();
        layout.invalidateLayout(pane);
        Panel newPane = new Panel();
        GridBagLayout newLayout = new GridBagLayout();
        newPane.setLayout(newLayout);
        for (int i = 0; i < count; ++i) {
            newLayout.setConstraints(c[i], gbc[i]);
            newPane.add(c[i]);
        }
        Frame f = new Frame();
        f.setLayout(new BorderLayout());
        f.add((Component)newPane, "Center");
        f.pack();
        final Dimension size = newPane.getSize();
        f.remove(newPane);
        f.dispose();
        size.width += 25;
        size.height += 15;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int maxWidth = 7 * screen.width / 8;
        int maxHeight = 3 * screen.height / 4;
        if (size.width > maxWidth) {
            size.width = maxWidth;
        }
        if (size.height > maxHeight) {
            size.height = maxHeight;
        }
        ScrollPane scroll = new ScrollPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return size;
            }
        };
        scroll.add(newPane);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        layout.setConstraints(scroll, constraints);
        pane.add(scroll);
    }

    public static String removeBrackets(String entry) {
        return GUIHelper.removeSequences(entry, new String[]{"(", ")", "{", "}", "[", "]", "<", ">"});
    }

    public static String removeSequences(String entry, String[] sequences) {
        while (GUIHelper.contains(entry, sequences)) {
            for (String s : sequences) {
                int index = entry.indexOf(s);
                if (index == 0) {
                    entry = entry.substring(s.length(), entry.length());
                    continue;
                }
                if (index == entry.length() - s.length()) {
                    entry = entry.substring(0, entry.length() - s.length());
                    continue;
                }
                if (index <= 0) continue;
                entry = entry.substring(0, index) + entry.substring(index + s.length(), entry.length());
            }
        }
        return entry;
    }

    public static boolean contains(String entry, String[] sequences) {
        for (String seq : sequences) {
            if (!entry.contains(seq)) continue;
            return true;
        }
        return false;
    }
}

