/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apposed.appose.SharedMemory;
import org.apposed.appose.ShmFactory;
import org.apposed.appose.shm.CLibrary;
import org.apposed.appose.shm.MacosHelpers;
import org.apposed.appose.shm.ShmBase;
import org.apposed.appose.shm.ShmUtils;

public class ShmMacOS
implements ShmFactory {
    @Override
    public SharedMemory create(String name, boolean create, int size) {
        if (ShmUtils.os != ShmUtils.OS.OSX) {
            return null;
        }
        return new SharedMemoryMacOS(name, create, size);
    }

    private static class SharedMemoryMacOS
    extends ShmBase<Integer> {
        private SharedMemoryMacOS(String name, boolean create, int size) {
            super(SharedMemoryMacOS.prepareShm(name, create, size));
        }

        @Override
        protected void doUnlink() {
            CLibrary.INSTANCE.shm_unlink(this.name());
        }

        @Override
        protected void doClose() {
            if (this.pointer() != Pointer.NULL && CLibrary.INSTANCE.munmap(this.pointer(), this.size()) == -1) {
                throw new RuntimeException("munmap failed. Errno: " + Native.getLastError());
            }
            if (CLibrary.INSTANCE.close((Integer)this.info.handle) == -1) {
                throw new RuntimeException("close failed. Errno: " + Native.getLastError());
            }
        }

        private static ShmBase.ShmInfo<Integer> prepareShm(String name, boolean create, int size) {
            String shm_name;
            long prevSize;
            if (name == null) {
                while ((prevSize = SharedMemoryMacOS.getSHMSize(shm_name = ShmUtils.make_filename(14, "/psm_"))) >= 0L) {
                }
            } else {
                shm_name = ShmUtils.withLeadingSlash(name);
                prevSize = SharedMemoryMacOS.getSHMSize(shm_name);
            }
            ShmUtils.checkSize(shm_name, prevSize, size);
            int shmFd = MacosHelpers.INSTANCE.create_shared_memory(shm_name, size);
            if (shmFd < 0) {
                throw new RuntimeException("shm_open failed, errno: " + Native.getLastError());
            }
            int shm_size = (int)SharedMemoryMacOS.getSHMSize(shmFd);
            Pointer pointer = CLibrary.INSTANCE.mmap(Pointer.NULL, shm_size, ShmUtils.PROT_READ | ShmUtils.PROT_WRITE, ShmUtils.MAP_SHARED, shmFd, 0);
            if (pointer == Pointer.NULL) {
                CLibrary.INSTANCE.close(shmFd);
                CLibrary.INSTANCE.shm_unlink(shm_name);
                throw new RuntimeException("mmap failed, errno: " + Native.getLastError());
            }
            ShmBase.ShmInfo<Integer> info = new ShmBase.ShmInfo<Integer>();
            info.size = shm_size;
            info.name = ShmUtils.withoutLeadingSlash(shm_name);
            info.pointer = pointer;
            info.handle = shmFd;
            info.unlinkOnClose = create;
            return info;
        }

        private static long getSHMSize(String name) {
            int shmFd = CLibrary.INSTANCE.shm_open(name, ShmUtils.O_RDONLY, 448);
            if (shmFd < 0) {
                return -1L;
            }
            return SharedMemoryMacOS.getSHMSize(shmFd);
        }

        private static long getSHMSize(int shmFd) {
            if (shmFd < 0) {
                throw new RuntimeException("Invalid shmFd. It should be bigger than 0.");
            }
            long size = MacosHelpers.INSTANCE.get_shared_memory_size(shmFd);
            if (size == -1L) {
                throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
            }
            return size;
        }
    }
}

