/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiOutputStream
extends OutputStream {
    private final List<OutputStream> streams;

    public MultiOutputStream(OutputStream ... os) {
        this.streams = new CopyOnWriteArrayList<OutputStream>(os);
    }

    public void addOutputStream(OutputStream os) {
        this.streams.add(os);
    }

    public void removeOutputStream(OutputStream os) {
        this.streams.remove(os);
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(b);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        for (OutputStream stream : this.streams) {
            stream.write(buf, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream stream : this.streams) {
            stream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream stream : this.streams) {
            stream.flush();
        }
    }
}

