/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script.run;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.script.ScriptException;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.run.AbstractCodeRunner;
import org.scijava.run.CodeRunner;
import org.scijava.script.ScriptService;

@Plugin(type=CodeRunner.class)
public class ScriptCodeRunner
extends AbstractCodeRunner {
    @Parameter
    private ScriptService scriptService;

    @Override
    public void run(Object code, Object ... args) throws InvocationTargetException {
        try {
            this.waitFor(this.scriptService.run(this.getScript(code), true, args));
        }
        catch (FileNotFoundException exc) {
            throw new InvocationTargetException(exc);
        }
        catch (ScriptException exc) {
            throw new InvocationTargetException(exc);
        }
    }

    @Override
    public void run(Object code, Map<String, Object> inputMap) throws InvocationTargetException {
        try {
            this.waitFor(this.scriptService.run(this.getScript(code), true, inputMap));
        }
        catch (FileNotFoundException exc) {
            throw new InvocationTargetException(exc);
        }
        catch (ScriptException exc) {
            throw new InvocationTargetException(exc);
        }
    }

    @Override
    public boolean supports(Object code) {
        return this.getScript(code) != null;
    }

    private File getScript(Object code) {
        File scriptFile;
        if (code instanceof File) {
            scriptFile = (File)code;
        } else if (code instanceof String) {
            scriptFile = new File((String)code);
        } else {
            return null;
        }
        if (!scriptFile.exists()) {
            return null;
        }
        if (!this.scriptService.canHandleFile(scriptFile)) {
            return null;
        }
        return scriptFile;
    }
}

