/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLine;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxSpline;
import com.mxgraph.util.mxSpline1D;
import com.mxgraph.util.mxUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class mxCurve {
    protected Map<String, mxPoint[]> points;
    protected double minXBounds = 1.0E7;
    protected double maxXBounds = 0.0;
    protected double minYBounds = 1.0E7;
    protected double maxYBounds = 0.0;
    protected Map<String, double[]> intervals;
    protected Map<String, Double> curveLengths;
    public static String CORE_CURVE = "Center_curve";
    public static String LABEL_CURVE = "Label_curve";
    public static mxLine INVALID_POSITION = new mxLine(new mxPoint(0.0, 0.0), new mxPoint(1.0, 0.0));
    protected double labelBuffer = mxConstants.DEFAULT_LABEL_BUFFER;
    public List<mxPoint> guidePoints = new ArrayList<mxPoint>();
    protected boolean valid = false;

    public void setLabelBuffer(double buffer) {
        this.labelBuffer = buffer;
    }

    public mxRectangle getBounds() {
        if (!this.valid) {
            this.createCoreCurve();
        }
        return new mxRectangle(this.minXBounds, this.minYBounds, this.maxXBounds - this.minXBounds, this.maxYBounds - this.minYBounds);
    }

    public mxCurve() {
    }

    public mxCurve(List<mxPoint> points) {
        boolean nullPoints = false;
        for (mxPoint point : points) {
            if (point != null) continue;
            nullPoints = true;
            break;
        }
        if (!nullPoints) {
            this.guidePoints = new ArrayList<mxPoint>(points);
        }
    }

    protected int getLowerIndexOfSegment(String index, double distance) {
        double[] curveIntervals = this.getIntervals(index);
        if (curveIntervals == null) {
            return 0;
        }
        int numIntervals = curveIntervals.length;
        if (distance <= 0.0 || numIntervals < 3) {
            return 0;
        }
        if (distance >= 1.0) {
            return numIntervals - 2;
        }
        int testIndex = (int)((double)numIntervals * distance);
        if (testIndex >= numIntervals) {
            testIndex = numIntervals - 1;
        }
        int lowerLimit = -1;
        int upperLimit = numIntervals;
        for (int i = 0; i < numIntervals; ++i) {
            double segmentDistance = curveIntervals[testIndex];
            double multiplier = 0.5;
            if (distance < segmentDistance) {
                upperLimit = Math.min(upperLimit, testIndex);
                multiplier = -0.5;
            } else if (distance > segmentDistance) {
                lowerLimit = Math.max(lowerLimit, testIndex);
            } else if (testIndex == 0) {
                lowerLimit = 0;
                upperLimit = 1;
            } else {
                lowerLimit = testIndex - 1;
                upperLimit = testIndex;
            }
            int indexDifference = upperLimit - lowerLimit;
            if (indexDifference == 1) break;
            if ((testIndex = (int)((double)testIndex + (double)indexDifference * multiplier)) == lowerLimit) {
                testIndex = lowerLimit + 1;
            }
            if (testIndex != upperLimit) continue;
            testIndex = upperLimit - 1;
        }
        if (lowerLimit != upperLimit - 1) {
            return -1;
        }
        return lowerLimit;
    }

    public mxLine getCurveParallel(String index, double distance) {
        mxPoint[] pointsCurve = this.getCurvePoints(index);
        double[] curveIntervals = this.getIntervals(index);
        if (pointsCurve != null && pointsCurve.length > 0 && curveIntervals != null && distance >= 0.0 && distance <= 1.0) {
            if (pointsCurve.length == 1) {
                mxPoint point = pointsCurve[0];
                return new mxLine(point.getX(), point.getY(), new mxPoint(1.0, 0.0));
            }
            int lowerLimit = this.getLowerIndexOfSegment(index, distance);
            mxPoint firstPointOfSeg = pointsCurve[lowerLimit];
            double segVectorX = pointsCurve[lowerLimit + 1].getX() - firstPointOfSeg.getX();
            double segVectorY = pointsCurve[lowerLimit + 1].getY() - firstPointOfSeg.getY();
            double distanceAlongSeg = (distance - curveIntervals[lowerLimit]) / (curveIntervals[lowerLimit + 1] - curveIntervals[lowerLimit]);
            double segLength = Math.sqrt(segVectorX * segVectorX + segVectorY * segVectorY);
            double startPointX = firstPointOfSeg.getX() + segVectorX * distanceAlongSeg;
            double startPointY = firstPointOfSeg.getY() + segVectorY * distanceAlongSeg;
            mxPoint endPoint = new mxPoint(segVectorX / segLength, segVectorY / segLength);
            return new mxLine(startPointX, startPointY, endPoint);
        }
        return INVALID_POSITION;
    }

    public mxPoint[] getCurveSection(String index, double start, double end) {
        mxPoint[] pointsCurve = this.getCurvePoints(index);
        double[] curveIntervals = this.getIntervals(index);
        if (pointsCurve != null && pointsCurve.length > 0 && curveIntervals != null && start >= 0.0 && start <= 1.0 && end >= 0.0 && end <= 1.0) {
            if (pointsCurve.length == 1) {
                mxPoint point = pointsCurve[0];
                return new mxPoint[]{new mxPoint(point.getX(), point.getY())};
            }
            int lowerLimit = this.getLowerIndexOfSegment(index, start);
            mxPoint firstPointOfSeg = pointsCurve[lowerLimit];
            double segVectorX = pointsCurve[lowerLimit + 1].getX() - firstPointOfSeg.getX();
            double segVectorY = pointsCurve[lowerLimit + 1].getY() - firstPointOfSeg.getY();
            double distanceAlongSeg = (start - curveIntervals[lowerLimit]) / (curveIntervals[lowerLimit + 1] - curveIntervals[lowerLimit]);
            mxPoint startPoint = new mxPoint(firstPointOfSeg.getX() + segVectorX * distanceAlongSeg, firstPointOfSeg.getY() + segVectorY * distanceAlongSeg);
            ArrayList<mxPoint> result = new ArrayList<mxPoint>();
            result.add(startPoint);
            double current = start;
            current = curveIntervals[++lowerLimit];
            while (current <= end) {
                mxPoint nextPointOfSeg = pointsCurve[lowerLimit];
                result.add(nextPointOfSeg);
                current = curveIntervals[++lowerLimit];
            }
            if (lowerLimit > 0 && lowerLimit < pointsCurve.length && end > curveIntervals[lowerLimit - 1]) {
                firstPointOfSeg = pointsCurve[lowerLimit - 1];
                segVectorX = pointsCurve[lowerLimit].getX() - firstPointOfSeg.getX();
                segVectorY = pointsCurve[lowerLimit].getY() - firstPointOfSeg.getY();
                distanceAlongSeg = (end - curveIntervals[lowerLimit - 1]) / (curveIntervals[lowerLimit] - curveIntervals[lowerLimit - 1]);
                mxPoint endPoint = new mxPoint(firstPointOfSeg.getX() + segVectorX * distanceAlongSeg, firstPointOfSeg.getY() + segVectorY * distanceAlongSeg);
                result.add(endPoint);
            }
            mxPoint[] resultArray = new mxPoint[result.size()];
            return result.toArray(resultArray);
        }
        return null;
    }

    public boolean intersectsRect(Rectangle rect) {
        if (!this.getBounds().getRectangle().intersects(rect)) {
            return false;
        }
        mxPoint[] pointsCurve = this.getCurvePoints(CORE_CURVE);
        if (pointsCurve != null && pointsCurve.length > 1) {
            int i;
            mxRectangle mxRect = new mxRectangle(rect);
            for (i = 1; i < pointsCurve.length; ++i) {
                if (!mxRect.contains(pointsCurve[i].getX(), pointsCurve[i].getY()) && !mxRect.contains(pointsCurve[i - 1].getX(), pointsCurve[i - 1].getY())) continue;
                return true;
            }
            for (i = 1; i < pointsCurve.length; ++i) {
                if (mxRect.intersectLine(pointsCurve[i].getX(), pointsCurve[i].getY(), pointsCurve[i - 1].getX(), pointsCurve[i - 1].getY()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public mxPoint intersectsRectPerimeter(String index, mxRectangle rect) {
        int crossingSeg;
        mxPoint result = null;
        mxPoint[] pointsCurve = this.getCurvePoints(index);
        if (pointsCurve != null && pointsCurve.length > 1 && (crossingSeg = this.intersectRectPerimeterSeg(index, rect)) != -1) {
            result = this.intersectRectPerimeterPoint(index, rect, crossingSeg);
        }
        return result;
    }

    public double intersectsRectPerimeterDist(String index, mxRectangle rect) {
        double result = -1.0;
        mxPoint[] pointsCurve = this.getCurvePoints(index);
        double[] curveIntervals = this.getIntervals(index);
        if (pointsCurve != null && pointsCurve.length > 1) {
            int segIndex = this.intersectRectPerimeterSeg(index, rect);
            mxPoint intersectPoint = null;
            if (segIndex != -1) {
                intersectPoint = this.intersectRectPerimeterPoint(index, rect, segIndex);
            }
            if (intersectPoint != null) {
                double startSegX = pointsCurve[segIndex - 1].getX();
                double startSegY = pointsCurve[segIndex - 1].getY();
                double distToStartSeg = curveIntervals[segIndex - 1] * this.getCurveLength(index);
                double intersectOffsetX = intersectPoint.getX() - startSegX;
                double intersectOffsetY = intersectPoint.getY() - startSegY;
                double lenToIntersect = Math.sqrt(intersectOffsetX * intersectOffsetX + intersectOffsetY * intersectOffsetY);
                result = distToStartSeg + lenToIntersect;
            }
        }
        return result;
    }

    public mxPoint collisionMove(String index, mxRectangle rect, double buffer) {
        int hitSeg = this.intersectRectPerimeterSeg(index, rect);
        if (hitSeg == -1) {
            return null;
        }
        mxPoint[] pointsCurve = this.getCurvePoints(index);
        double x0 = pointsCurve[hitSeg - 1].getX();
        double y0 = pointsCurve[hitSeg - 1].getY();
        double x1 = pointsCurve[hitSeg].getX();
        double y1 = pointsCurve[hitSeg].getY();
        double x = rect.getX();
        double y = rect.getY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        boolean horizIncident = false;
        mxPoint hitPoint = mxUtils.intersection(x, y, x + width, y, x0, y0, x1, y1);
        if (hitPoint != null) {
            horizIncident = true;
        } else {
            hitPoint = mxUtils.intersection(x + width, y, x + width, y + height, x0, y0, x1, y1);
        }
        if (hitPoint == null) {
            hitPoint = mxUtils.intersection(x + width, y + height, x, y + height, x0, y0, x1, y1);
            if (hitPoint != null) {
                horizIncident = true;
            } else {
                hitPoint = mxUtils.intersection(x, y, x, y + height, x0, y0, x1, y1);
            }
        }
        if (hitPoint != null) {
            // empty if block
        }
        return null;
    }

    protected int intersectRectPerimeterSeg(String index, mxRectangle rect) {
        return this.intersectRectPerimeterSeg(index, rect, 1);
    }

    protected int intersectRectPerimeterSeg(String index, mxRectangle rect, int startSegment) {
        mxPoint[] pointsCurve = this.getCurvePoints(index);
        if (pointsCurve != null && pointsCurve.length > 1) {
            for (int i = startSegment; i < pointsCurve.length; ++i) {
                if (rect.intersectLine(pointsCurve[i].getX(), pointsCurve[i].getY(), pointsCurve[i - 1].getX(), pointsCurve[i - 1].getY()) == null) continue;
                return i;
            }
        }
        return -1;
    }

    protected mxPoint intersectRectPerimeterPoint(String curveIndex, mxRectangle rect, int indexSeg) {
        mxPoint result = null;
        mxPoint[] pointsCurve = this.getCurvePoints(curveIndex);
        if (pointsCurve != null && pointsCurve.length > 1 && indexSeg >= 0 && indexSeg < pointsCurve.length) {
            double p1X = pointsCurve[indexSeg - 1].getX();
            double p1Y = pointsCurve[indexSeg - 1].getY();
            double p2X = pointsCurve[indexSeg].getX();
            double p2Y = pointsCurve[indexSeg].getY();
            result = rect.intersectLine(p1X, p1Y, p2X, p2Y);
        }
        return result;
    }

    public mxRectangle getRelativeFromAbsPoint(mxPoint absPoint, String index) {
        mxPoint[] currentCurve = this.getCurvePoints(index);
        double[] currentIntervals = this.getIntervals(index);
        int closestSegment = 0;
        double closestSegDistSq = 1.0E7;
        mxLine segment = new mxLine(currentCurve[0], currentCurve[1]);
        for (int i = 1; i < currentCurve.length; ++i) {
            segment.setPoints(currentCurve[i - 1], currentCurve[i]);
            double segDistSq = segment.ptSegDistSq(absPoint);
            if (!(segDistSq < closestSegDistSq)) continue;
            closestSegDistSq = segDistSq;
            closestSegment = i - 1;
        }
        mxPoint startSegPt = currentCurve[closestSegment];
        mxPoint endSegPt = currentCurve[closestSegment + 1];
        mxLine closestSeg = new mxLine(startSegPt, endSegPt);
        double lineDistSq = closestSeg.ptLineDistSq(absPoint);
        double orthogonalOffset = Math.sqrt(Math.min(lineDistSq, closestSegDistSq));
        double segX = endSegPt.getX() - startSegPt.getX();
        double segY = endSegPt.getY() - startSegPt.getY();
        double segDist = Math.sqrt(segX * segX + segY * segY);
        double segNormX = segX / segDist;
        double segNormY = segY / segDist;
        double candidateOffX1 = absPoint.getX() - segNormY * orthogonalOffset - endSegPt.getX();
        double candidateOffY1 = absPoint.getY() + segNormX * orthogonalOffset - endSegPt.getY();
        double candidateOffX2 = absPoint.getX() + segNormY * orthogonalOffset - endSegPt.getX();
        double candidateOffY2 = absPoint.getY() - segNormX * orthogonalOffset - endSegPt.getY();
        double candidateDist1 = candidateOffX1 * candidateOffX1 + candidateOffY1 * candidateOffY1;
        double candidateDist2 = candidateOffX2 * candidateOffX2 + candidateOffY2 * candidateOffY2;
        double orthOffsetPointX = 0.0;
        double orthOffsetPointY = 0.0;
        if (candidateDist2 < candidateDist1) {
            orthogonalOffset = -orthogonalOffset;
        }
        orthOffsetPointX = absPoint.getX() - segNormY * orthogonalOffset;
        orthOffsetPointY = absPoint.getY() + segNormX * orthogonalOffset;
        double distAlongEdge = 0.0;
        double cartOffsetX = 0.0;
        double cartOffsetY = 0.0;
        if (Math.abs(closestSegDistSq - lineDistSq) > 1.0E-4) {
            double distToEndPoint;
            double distToStartPoint = Math.abs(orthOffsetPointX - startSegPt.getX()) + Math.abs(orthOffsetPointY - startSegPt.getY());
            if (distToStartPoint < (distToEndPoint = Math.abs(orthOffsetPointX - endSegPt.getX()) + Math.abs(orthOffsetPointY - endSegPt.getY()))) {
                distAlongEdge = currentIntervals[closestSegment];
                cartOffsetX = orthOffsetPointX - startSegPt.getX();
                cartOffsetY = orthOffsetPointY - startSegPt.getY();
            } else {
                distAlongEdge = currentIntervals[closestSegment + 1];
                cartOffsetX = orthOffsetPointX - endSegPt.getX();
                cartOffsetY = orthOffsetPointY - endSegPt.getY();
            }
        } else {
            double segmentLen = Math.sqrt((endSegPt.getX() - startSegPt.getX()) * (endSegPt.getX() - startSegPt.getX()) + (endSegPt.getY() - startSegPt.getY()) * (endSegPt.getY() - startSegPt.getY()));
            double offsetLen = Math.sqrt((orthOffsetPointX - startSegPt.getX()) * (orthOffsetPointX - startSegPt.getX()) + (orthOffsetPointY - startSegPt.getY()) * (orthOffsetPointY - startSegPt.getY()));
            double proportionAlongSeg = offsetLen / segmentLen;
            double segProportingDiff = currentIntervals[closestSegment + 1] - currentIntervals[closestSegment];
            distAlongEdge = currentIntervals[closestSegment] + segProportingDiff * proportionAlongSeg;
        }
        if (distAlongEdge > 1.0) {
            distAlongEdge = 1.0;
        }
        return new mxRectangle(distAlongEdge, orthogonalOffset, cartOffsetX, cartOffsetY);
    }

    protected void createCoreCurve() {
        this.valid = false;
        if (this.guidePoints == null || this.guidePoints.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.guidePoints.size(); ++i) {
            if (this.guidePoints.get(i) != null) continue;
            return;
        }
        this.minYBounds = 1.0E7;
        this.minXBounds = 1.0E7;
        this.maxYBounds = 0.0;
        this.maxXBounds = 0.0;
        mxSpline spline = new mxSpline(this.guidePoints);
        double lengthSpline = spline.getLength();
        if (Double.isNaN(lengthSpline) || !spline.checkValues() || lengthSpline < 1.0) {
            return;
        }
        mxSpline1D splineX = spline.getSplineX();
        mxSpline1D splineY = spline.getSplineY();
        double baseInterval = 12.0 / lengthSpline;
        double minInterval = 1.0 / lengthSpline;
        double interval = baseInterval;
        double minDeviation = 0.15;
        double maxDeviation = 0.3;
        double preferedDeviation = (maxDeviation + minDeviation) / 2.0;
        double x1 = -1.0;
        double x2 = -1.0;
        double y1 = -1.0;
        double y2 = -1.0;
        double intervalChange = 1.0;
        ArrayList<mxPoint> coreCurve = new ArrayList<mxPoint>();
        ArrayList<Double> coreIntervals = new ArrayList<Double>();
        boolean twoLoopsComplete = false;
        for (double t = 0.0; t <= 1.5; t += interval) {
            if (t > 1.0) {
                t = 1.0001;
                mxPoint endControlPoint = this.guidePoints.get(this.guidePoints.size() - 1);
                mxPoint finalPoint = new mxPoint(endControlPoint.getX(), endControlPoint.getY());
                coreCurve.add(finalPoint);
                coreIntervals.add(t);
                this.updateBounds(endControlPoint.getX(), endControlPoint.getY());
                break;
            }
            boolean currentPointAccepted = true;
            double newX = splineX.getFastValue(t);
            double newY = splineY.getFastValue(t);
            if (x1 != -1.0 && twoLoopsComplete && t != 1.0001) {
                double diffX = Math.abs((x2 - x1) * intervalChange + x2 - newX);
                double diffY = Math.abs((y2 - y1) * intervalChange + y2 - newY);
                if ((diffX > maxDeviation || diffY > maxDeviation) && interval != minInterval) {
                    double overshootProportion = maxDeviation / Math.max(diffX, diffY);
                    intervalChange = interval * overshootProportion <= minInterval ? minInterval / interval : overshootProportion;
                    t -= interval;
                    interval *= intervalChange;
                    currentPointAccepted = false;
                } else if (diffX < minDeviation && diffY < minDeviation) {
                    intervalChange = 1.4;
                    interval *= intervalChange;
                } else {
                    double errorRatio = preferedDeviation / Math.max(diffX, diffY);
                    intervalChange = errorRatio / 4.0;
                    interval *= intervalChange;
                }
                if (currentPointAccepted) {
                    x1 = x2;
                    y1 = y2;
                    x2 = newX;
                    y2 = newY;
                }
            } else if (x1 == -1.0) {
                x1 = x2 = newX;
                y1 = y2 = newY;
            } else if (x1 == x2 && y1 == y2) {
                x2 = newX;
                y2 = newY;
                twoLoopsComplete = true;
            }
            if (!currentPointAccepted) continue;
            mxPoint newPoint = new mxPoint(newX, newY);
            coreCurve.add(newPoint);
            coreIntervals.add(t);
            this.updateBounds(newX, newY);
        }
        if (coreCurve.size() < 2) {
            return;
        }
        mxPoint[] corePoints = new mxPoint[coreCurve.size()];
        int count = 0;
        for (mxPoint point : coreCurve) {
            corePoints[count++] = point;
        }
        this.points = new Hashtable<String, mxPoint[]>();
        this.curveLengths = new Hashtable<String, Double>();
        this.points.put(CORE_CURVE, corePoints);
        this.curveLengths.put(CORE_CURVE, lengthSpline);
        double[] coreIntervalsArray = new double[coreIntervals.size()];
        count = 0;
        for (Double tempInterval : coreIntervals) {
            coreIntervalsArray[count++] = tempInterval;
        }
        this.intervals = new Hashtable<String, double[]>();
        this.intervals.put(CORE_CURVE, coreIntervalsArray);
        this.valid = true;
    }

    public boolean isLabelReversed() {
        double changeX;
        mxPoint[] centralCurve;
        return this.valid && (centralCurve = this.getCurvePoints(CORE_CURVE)) != null && (changeX = centralCurve[centralCurve.length - 1].getX() - centralCurve[0].getX()) < 0.0;
    }

    protected void createLabelCurve() {
        mxPoint[] currentCurve = this.getBaseLabelCurve();
        boolean labelReversed = this.isLabelReversed();
        ArrayList<mxPoint> labelCurvePoints = new ArrayList<mxPoint>();
        for (int i = 1; i < currentCurve.length; ++i) {
            int currentIndex = i;
            int lastIndex = i - 1;
            if (labelReversed) {
                currentIndex = currentCurve.length - i - 1;
                lastIndex = currentCurve.length - i;
            }
            mxPoint segStartPoint = currentCurve[currentIndex];
            mxPoint segEndPoint = currentCurve[lastIndex];
            double segVectorX = segEndPoint.getX() - segStartPoint.getX();
            double segVectorY = segEndPoint.getY() - segStartPoint.getY();
            double segVectorLength = Math.sqrt(segVectorX * segVectorX + segVectorY * segVectorY);
            double normSegVectorX = segVectorX / segVectorLength;
            double normSegVectorY = segVectorY / segVectorLength;
            double centerSegX = (segEndPoint.getX() + segStartPoint.getX()) / 2.0;
            double centerSegY = (segEndPoint.getY() + segStartPoint.getY()) / 2.0;
            if (i == 1) {
                mxPoint startPoint = new mxPoint(segEndPoint.getX() - normSegVectorY * this.labelBuffer, segEndPoint.getY() + normSegVectorX * this.labelBuffer);
                labelCurvePoints.add(startPoint);
                this.updateBounds(startPoint.getX(), startPoint.getY());
            }
            double pointX = centerSegX - normSegVectorY * this.labelBuffer;
            double pointY = centerSegY + normSegVectorX * this.labelBuffer;
            mxPoint labelCurvePoint = new mxPoint(pointX, pointY);
            this.updateBounds(pointX, pointY);
            labelCurvePoints.add(labelCurvePoint);
            if (i != currentCurve.length - 1) continue;
            mxPoint endPoint = new mxPoint(segStartPoint.getX() - normSegVectorY * this.labelBuffer, segStartPoint.getY() + normSegVectorX * this.labelBuffer);
            labelCurvePoints.add(endPoint);
            this.updateBounds(endPoint.getX(), endPoint.getY());
        }
        mxPoint[] tmpPoints = new mxPoint[labelCurvePoints.size()];
        this.points.put(LABEL_CURVE, labelCurvePoints.toArray(tmpPoints));
        this.populateIntervals(LABEL_CURVE);
    }

    protected mxPoint[] getBaseLabelCurve() {
        return this.getCurvePoints(CORE_CURVE);
    }

    protected void populateIntervals(String index) {
        mxPoint[] currentCurve = this.points.get(index);
        double[] newIntervals = new double[currentCurve.length];
        double totalLength = 0.0;
        newIntervals[0] = 0.0;
        for (int i = 0; i < currentCurve.length - 1; ++i) {
            double changeX = currentCurve[i + 1].getX() - currentCurve[i].getX();
            double changeY = currentCurve[i + 1].getY() - currentCurve[i].getY();
            double segLength = Math.sqrt(changeX * changeX + changeY * changeY);
            newIntervals[i + 1] = totalLength += segLength;
        }
        for (int j = 0; j < newIntervals.length; ++j) {
            newIntervals[j] = j == newIntervals.length - 1 ? 1.0001 : newIntervals[j] / totalLength;
        }
        this.intervals.put(index, newIntervals);
        this.curveLengths.put(index, totalLength);
    }

    public void updateCurve(List<mxPoint> newPoints) {
        boolean pointsChanged = false;
        for (mxPoint point : newPoints) {
            if (point != null) continue;
            return;
        }
        if (newPoints.size() != this.guidePoints.size()) {
            pointsChanged = true;
        } else if (newPoints.size() == this.guidePoints.size() && newPoints.size() > 1 && this.guidePoints.size() > 1) {
            boolean constantTranslation = true;
            boolean trivialTranslation = true;
            mxPoint newPoint0 = newPoints.get(0);
            mxPoint oldPoint0 = this.guidePoints.get(0);
            double transX = newPoint0.getX() - oldPoint0.getX();
            double transY = newPoint0.getY() - oldPoint0.getY();
            if (Math.abs(transX) > 0.01 || Math.abs(transY) > 0.01) {
                trivialTranslation = false;
            }
            for (int i = 1; i < newPoints.size(); ++i) {
                double nextTransX = newPoints.get(i).getX() - this.guidePoints.get(i).getX();
                double nextTransY = newPoints.get(i).getY() - this.guidePoints.get(i).getY();
                if (Math.abs(transX - nextTransX) > 0.01 || Math.abs(transY - nextTransY) > 0.01) {
                    constantTranslation = false;
                }
                if (!(Math.abs(nextTransX) > 0.01) && !(Math.abs(nextTransY) > 0.01)) continue;
                trivialTranslation = false;
            }
            if (trivialTranslation) {
                pointsChanged = false;
            } else if (constantTranslation) {
                pointsChanged = false;
                Collection<mxPoint[]> curves = this.points.values();
                for (mxPoint[] curve : curves) {
                    for (int i = 0; i < curve.length; ++i) {
                        curve[i].setX(curve[i].getX() + transX);
                        curve[i].setY(curve[i].getY() + transY);
                    }
                }
                this.guidePoints = new ArrayList<mxPoint>(newPoints);
                this.minXBounds += transX;
                this.minYBounds += transY;
                this.maxXBounds += transX;
                this.maxYBounds += transY;
            } else {
                pointsChanged = true;
            }
        }
        if (pointsChanged) {
            this.guidePoints = new ArrayList<mxPoint>(newPoints);
            this.points = new Hashtable<String, mxPoint[]>();
            this.valid = false;
        }
    }

    public mxPoint[] getCurvePoints(String index) {
        if (this.validateCurve()) {
            if (this.points.get(LABEL_CURVE) == null && index == LABEL_CURVE) {
                this.createLabelCurve();
            }
            return this.points.get(index);
        }
        return null;
    }

    public double[] getIntervals(String index) {
        if (this.validateCurve()) {
            if (this.points.get(LABEL_CURVE) == null && index == LABEL_CURVE) {
                this.createLabelCurve();
            }
            return this.intervals.get(index);
        }
        return null;
    }

    public double getCurveLength(String index) {
        if (this.validateCurve()) {
            if (this.intervals.get(index) == null) {
                this.createLabelCurve();
            }
            return this.curveLengths.get(index);
        }
        return 0.0;
    }

    protected boolean validateCurve() {
        if (!this.valid) {
            this.createCoreCurve();
        }
        return this.valid;
    }

    protected void updateBounds(double pointX, double pointY) {
        this.minXBounds = Math.min(this.minXBounds, pointX);
        this.maxXBounds = Math.max(this.maxXBounds, pointX);
        this.minYBounds = Math.min(this.minYBounds, pointY);
        this.maxYBounds = Math.max(this.maxYBounds, pointY);
    }

    public List<mxPoint> getGuidePoints() {
        return this.guidePoints;
    }
}

