/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.util.List;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpRef;
import org.scijava.ValidityProblem;
import org.scijava.command.CommandInfo;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;

public class OpCandidate {
    private final OpEnvironment ops;
    private final OpRef ref;
    private final OpInfo info;
    private Module module;
    private StatusCode code;
    private String message;
    private ModuleItem<?> item;
    private Object[] args;

    public OpCandidate(OpEnvironment ops, OpRef ref, OpInfo info) {
        this.ops = ops;
        this.ref = ref;
        this.info = info;
    }

    public OpEnvironment ops() {
        return this.ops;
    }

    public OpRef getRef() {
        return this.ref;
    }

    public OpInfo opInfo() {
        return this.info;
    }

    public CommandInfo cInfo() {
        return this.info.cInfo();
    }

    public List<ModuleItem<?>> inputs() {
        return this.opInfo().inputs();
    }

    public List<ModuleItem<?>> outputs() {
        return this.opInfo().outputs();
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public void setStatus(StatusCode code) {
        this.setStatus(code, null, null);
    }

    public void setStatus(StatusCode code, String message) {
        this.setStatus(code, message, null);
    }

    public void setStatus(StatusCode code, String message, ModuleItem<?> item) {
        this.code = code;
        this.message = message;
        this.item = item;
    }

    public StatusCode getStatusCode() {
        return this.code;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public ModuleItem<?> getStatusItem() {
        return this.item;
    }

    public String getStatus() {
        StatusCode statusCode = this.getStatusCode();
        if (statusCode == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        switch (statusCode) {
            case MATCH: {
                sb.append("MATCH");
                break;
            }
            case INVALID_MODULE: {
                sb.append("Invalid op: " + this.info.cInfo().getDelegateClassName());
                List problems = this.info.cInfo().getProblems();
                int problemCount = problems.size();
                if (problemCount > 0) {
                    sb.append(" (");
                }
                int no = 0;
                for (ValidityProblem problem : problems) {
                    if (no++ > 0) {
                        sb.append("; ");
                    }
                    if (problemCount > 1) {
                        sb.append(no + ". ");
                    }
                    sb.append(problem.getMessage());
                }
                if (problemCount <= 0) break;
                sb.append(")");
                break;
            }
            case TOO_FEW_OUTPUTS: {
                sb.append("Too few outputs");
                break;
            }
            case OUTPUT_TYPES_DO_NOT_MATCH: {
                sb.append("Output types do not match");
                break;
            }
            case TOO_MANY_ARGS: {
                sb.append("Too many arguments");
                break;
            }
            case TOO_FEW_ARGS: {
                sb.append("Not enough arguments");
                break;
            }
            case ARG_TYPES_DO_NOT_MATCH: {
                sb.append("Argument types do not match");
                break;
            }
            case REQUIRED_ARG_IS_NULL: {
                sb.append("Missing required argument");
                break;
            }
            case CANNOT_CONVERT: {
                sb.append("Inconvertible type");
                break;
            }
            case DOES_NOT_CONFORM: {
                sb.append("Inputs do not conform to op rules");
                break;
            }
            default: {
                return this.getStatusMessage();
            }
        }
        String msg = this.getStatusMessage();
        if (msg != null) {
            sb.append(": " + msg);
        }
        return sb.toString();
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public String toString() {
        return this.info.toString();
    }

    public static enum StatusCode {
        MATCH,
        INVALID_MODULE,
        TOO_FEW_OUTPUTS,
        OUTPUT_TYPES_DO_NOT_MATCH,
        TOO_MANY_ARGS,
        TOO_FEW_ARGS,
        ARG_TYPES_DO_NOT_MATCH,
        REQUIRED_ARG_IS_NULL,
        CANNOT_CONVERT,
        DOES_NOT_CONFORM,
        OTHER;

    }
}

