/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.convert.scale;

import net.imagej.ops.Ops;
import net.imagej.ops.convert.RealTypeConverter;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Convert.Scale.class)
public class ScaleRealTypes<I extends RealType<I>, O extends RealType<O>>
extends RealTypeConverter<I, O>
implements Ops.Convert.Scale {
    protected double inMin;
    protected double outMin;
    protected double factor;

    @Override
    public void compute(I input, O output) {
        output.setReal((input.getRealDouble() - this.inMin) / this.factor + this.outMin);
    }

    @Override
    public void checkInput(I inType, O outType) {
        this.inMin = inType.getMinValue();
        this.outMin = outType.getMinValue();
        this.factor = (inType.getMaxValue() - this.inMin) / (outType.getMaxValue() - this.outMin);
    }
}

