/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocPXPlusY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.SumEntropy.class, label="Haralick: Sum Entropy")
public class DefaultSumEntropy<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.SumEntropy {
    private static final double EPSILON = Double.MIN_NORMAL;
    private UnaryFunctionOp<double[][], double[]> coocPXPlusFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocPXPlusFunc = Functions.unary(this.ops(), CoocPXPlusY.class, double[].class, double[][].class, new Object[0]);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double[] pxplusy = this.coocPXPlusFunc.calculate(matrix);
        int nrGrayLevels = matrix.length;
        double res = 0.0;
        for (int i = 2; i <= 2 * nrGrayLevels; ++i) {
            res += pxplusy[i] * Math.log(pxplusy[i] + Double.MIN_NORMAL);
        }
        output.set(-res);
    }
}

