/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.bilateral;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.Bilateral.class, priority=0.0)
public class DefaultBilateral<I extends RealType<I>, O extends RealType<O>>
extends AbstractUnaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>>
implements Ops.Filter.Bilateral,
Contingent {
    public static final int MIN_DIMS = 2;
    public static final int MAX_DIMS = 2;
    @Parameter
    private double sigmaR;
    @Parameter
    private double sigmaS;
    @Parameter
    private int radius;

    private static double gauss(double x, double sigma) {
        double mu = 0.0;
        return 1.0 / (sigma * Math.sqrt(Math.PI * 2)) * Math.exp(-0.5 * (x - 0.0) * (x - 0.0) / (sigma * sigma));
    }

    private double getDistance(long[] x, long[] y) {
        double distance = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double separation = x[i] - y[i];
            if (separation == 0.0) continue;
            distance += separation * separation;
        }
        return Math.sqrt(distance);
    }

    @Override
    public void compute(RandomAccessibleInterval<I> input, RandomAccessibleInterval<O> output) {
        long[] size = new long[input.numDimensions()];
        input.dimensions(size);
        RandomAccess outputRA = output.randomAccess();
        Cursor inputCursor = Views.iterable(input).localizingCursor();
        long[] currentPos = new long[input.numDimensions()];
        long[] neighborhoodPos = new long[input.numDimensions()];
        long[] neighborhoodMin = new long[input.numDimensions()];
        long[] neighborhoodMax = new long[input.numDimensions()];
        RectangleNeighborhoodFactory fac = RectangleNeighborhood.factory();
        while (inputCursor.hasNext()) {
            inputCursor.fwd();
            inputCursor.localize(currentPos);
            inputCursor.localize(neighborhoodMin);
            inputCursor.localize(neighborhoodMax);
            neighborhoodMin[0] = Math.max(0L, neighborhoodMin[0] - (long)this.radius);
            neighborhoodMin[1] = Math.max(0L, neighborhoodMin[1] - (long)this.radius);
            neighborhoodMax[0] = Math.min(input.max(0), neighborhoodMax[0] + (long)this.radius);
            neighborhoodMax[1] = Math.min(input.max(1), neighborhoodMax[1] + (long)this.radius);
            FinalInterval interval = new FinalInterval(neighborhoodMin, neighborhoodMax);
            Neighborhood neighborhood = fac.create(currentPos, neighborhoodMin, neighborhoodMax, (Interval)interval, input.randomAccess());
            Cursor neighborhoodCursor = neighborhood.localizingCursor();
            double v = 0.0;
            double w = 0.0;
            do {
                neighborhoodCursor.fwd();
                neighborhoodCursor.localize(neighborhoodPos);
                double distance = this.getDistance(currentPos, neighborhoodPos);
                double weight = DefaultBilateral.gauss(distance, this.sigmaS);
                distance = Math.abs(((RealType)inputCursor.get()).getRealDouble() - ((RealType)neighborhoodCursor.get()).getRealDouble());
                v += (weight *= DefaultBilateral.gauss(distance, this.sigmaR)) * ((RealType)neighborhoodCursor.get()).getRealDouble();
                w += weight;
            } while (neighborhoodCursor.hasNext());
            outputRA.setPosition(currentPos);
            ((RealType)outputRA.get()).setReal(v / w);
        }
    }

    @Override
    public boolean conforms() {
        return Intervals.equalDimensions((Interval)((Interval)this.in()), (Interval)((Interval)this.out()));
    }
}

