/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.ArrayList;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.GeomUtils;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.SmallestEnclosingBoundingBox.class, label="Geometric (2D): Smallest Enclosing Rectangle")
public class DefaultSmallestEnclosingRectangle
extends AbstractUnaryFunctionOp<Polygon2D, Polygon2D>
implements Contingent,
Ops.Geometric.SmallestEnclosingBoundingBox {
    private UnaryFunctionOp<Polygon2D, Polygon2D> convexHullFunc;
    private UnaryFunctionOp<Polygon2D, RealLocalizable> centroidFunc;
    private UnaryFunctionOp<Polygon2D, DoubleType> areaFunc;
    private UnaryFunctionOp<Polygon2D, Polygon2D> boundingBoxFunc;

    @Override
    public void initialize() {
        this.convexHullFunc = Functions.unary(this.ops(), Ops.Geometric.ConvexHull.class, Polygon2D.class, this.in(), new Object[0]);
        this.centroidFunc = Functions.unary(this.ops(), Ops.Geometric.Centroid.class, RealLocalizable.class, this.in(), new Object[0]);
        this.areaFunc = Functions.unary(this.ops(), Ops.Geometric.Size.class, DoubleType.class, this.in(), new Object[0]);
        this.boundingBoxFunc = Functions.unary(this.ops(), Ops.Geometric.BoundingBox.class, Polygon2D.class, this.in(), new Object[0]);
    }

    private Polygon2D rotate(Polygon2D inPoly, double angle, RealLocalizable center) {
        ArrayList<RealPoint> out = new ArrayList<RealPoint>();
        for (RealLocalizable RealPoint2 : GeomUtils.vertices(inPoly)) {
            double cosTheta = Math.cos(angle);
            double sinTheta = Math.sin(angle);
            double x = cosTheta * (RealPoint2.getDoublePosition(0) - center.getDoublePosition(0)) - sinTheta * (RealPoint2.getDoublePosition(1) - center.getDoublePosition(1)) + center.getDoublePosition(0);
            double y = sinTheta * (RealPoint2.getDoublePosition(0) - center.getDoublePosition(0)) + cosTheta * (RealPoint2.getDoublePosition(1) - center.getDoublePosition(1)) + center.getDoublePosition(1);
            out.add(new RealPoint(new double[]{x, y}));
        }
        return new DefaultWritablePolygon2D(out);
    }

    @Override
    public Polygon2D calculate(Polygon2D input) {
        Polygon2D ch = this.convexHullFunc.calculate(input);
        RealLocalizable cog = this.centroidFunc.calculate(ch);
        Polygon2D minBounds = input;
        double minArea = Double.POSITIVE_INFINITY;
        for (int i = 1; i < ch.numVertices() - 1; ++i) {
            double angle = Math.atan2(ch.vertex(i).getDoublePosition(1) - ch.vertex(i - 1).getDoublePosition(1), ch.vertex(i).getDoublePosition(0) - ch.vertex(i - 1).getDoublePosition(0));
            Polygon2D rotatedPoly = this.rotate(ch, -angle, cog);
            Polygon2D bounds = this.boundingBoxFunc.calculate(rotatedPoly);
            double area = this.areaFunc.calculate(bounds).get();
            if (!(area < minArea)) continue;
            minArea = area;
            minBounds = this.rotate(bounds, angle, cog);
        }
        double angle = Math.atan2(ch.vertex(0).getDoublePosition(1) - ch.vertex(ch.numVertices() - 1).getDoublePosition(1), ch.vertex(0).getDoublePosition(0) - ch.vertex(ch.numVertices() - 1).getDoublePosition(0));
        Polygon2D rotatedPoly = this.rotate(ch, -angle, cog);
        Polygon2D bounds = this.boundingBoxFunc.calculate(rotatedPoly);
        double area = this.areaFunc.calculate(bounds).get();
        if (area < minArea) {
            minArea = area;
            minBounds = this.rotate(bounds, angle, cog);
        }
        return minBounds;
    }

    @Override
    public boolean conforms() {
        return this.in() != null;
    }
}

