/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.StdDev.class, label="Statistics: Standard Deviation", priority=10000.0)
public class IterableStandardDeviation<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.StdDev {
    @Override
    public void compute(Iterable<I> input, O output) {
        double sum = 0.0;
        double sumSqr = 0.0;
        int n = 0;
        for (RealType in : input) {
            double px = in.getRealDouble();
            ++n;
            sum += px;
            sumSqr += px * px;
        }
        output.setReal(Math.sqrt((sumSqr - sum * sum / (double)n) / (double)(n - 1)));
    }
}

