/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.minError;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imagej.ops.threshold.Thresholds;
import net.imagej.ops.threshold.mean.ComputeMeanThreshold;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.MinError.class, priority=100.0)
public class ComputeMinErrorThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.MinError {
    @Parameter(type=ItemIO.OUTPUT)
    private String errMsg = null;

    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        int threshold = (int)new ComputeMeanThreshold<T>().computeBin(hist);
        int Tprev = -2;
        while (threshold != Tprev) {
            double w2;
            double w0;
            double tau2;
            double mu = Thresholds.B(histogram, threshold) / Thresholds.A(histogram, threshold);
            double nu = (Thresholds.B(histogram, histogram.length - 1) - Thresholds.B(histogram, threshold)) / (Thresholds.A(histogram, histogram.length - 1) - Thresholds.A(histogram, threshold));
            double p = Thresholds.A(histogram, threshold) / Thresholds.A(histogram, histogram.length - 1);
            double q = (Thresholds.A(histogram, histogram.length - 1) - Thresholds.A(histogram, threshold)) / Thresholds.A(histogram, histogram.length - 1);
            double sigma2 = Thresholds.C(histogram, threshold) / Thresholds.A(histogram, threshold) - mu * mu;
            double w1 = mu / sigma2 - nu / (tau2 = (Thresholds.C(histogram, histogram.length - 1) - Thresholds.C(histogram, threshold)) / (Thresholds.A(histogram, histogram.length - 1) - Thresholds.A(histogram, threshold)) - nu * nu);
            double sqterm = w1 * w1 - (w0 = 1.0 / sigma2 - 1.0 / tau2) * (w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log10(sigma2 * (q * q) / (tau2 * (p * p))));
            if (sqterm < 0.0) {
                this.errMsg = "MinError(I): not converging. Try 'Ignore black/white' options";
                return threshold;
            }
            Tprev = threshold;
            double temp = (w1 + Math.sqrt(sqterm)) / w0;
            if (Double.isNaN(temp)) {
                this.errMsg = "MinError(I): NaN, not converging. Try 'Ignore black/white' options";
                threshold = Tprev;
                continue;
            }
            threshold = (int)Math.floor(temp);
        }
        return threshold;
    }
}

