/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.transform.scaleView;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Transform.ScaleView.class, priority=101.0)
public class DefaultScaleView<T>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.Transform.ScaleView,
Contingent {
    @Parameter
    private double[] scaleFactors;
    @Parameter
    private InterpolatorFactory<T, RandomAccessible<T>> interpolator;
    @Parameter(required=false)
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);

    @Override
    public RandomAccessibleInterval<T> calculate(RandomAccessibleInterval<T> input) {
        long[] newDims = Intervals.dimensionsAsLongArray((Dimensions)((Dimensions)this.in()));
        for (int i = 0; i < Math.min(this.scaleFactors.length, ((RandomAccessibleInterval)this.in()).numDimensions()); ++i) {
            newDims[i] = Math.round((double)((RandomAccessibleInterval)this.in()).dimension(i) * this.scaleFactors[i]);
        }
        IntervalView interval = Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)RealViews.affineReal((RealRandomAccessible)Views.interpolate((EuclideanSpace)Views.extendMirrorSingle(input), this.interpolator), (AffineGet)new Scale(this.scaleFactors))), (Interval)new FinalInterval(newDims));
        return interval;
    }

    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == this.scaleFactors.length;
    }
}

