/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.BigDataViewer;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.export.ProgressWriter;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.imagestack.ImageStackImageLoader;
import bdv.img.virtualstack.VirtualStackImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.ConverterSetups;
import bdv.viewer.DisplayMode;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerState;
import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.process.LUT;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Open Current Image")
public class OpenImagePlusPlugIn
implements Command {
    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        new ImageJ();
        IJ.run((String)"Confocal Series (2.2MB)");
        new OpenImagePlusPlugIn().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        int nImages = WindowManager.getImageCount();
        ImagePlus curr = WindowManager.getCurrentImage();
        if (curr == null) {
            IJ.showMessage((String)"Please open an image first.");
            return;
        }
        ArrayList<ImagePlus> inputImgList = new ArrayList<ImagePlus>();
        if (nImages > 1) {
            ImagePlus imp;
            int i;
            int[] idList = WindowManager.getIDList();
            String[] nameList = new String[nImages];
            GenericDialog gd = new GenericDialog("Images to open");
            for (i = 0; i < nImages; ++i) {
                imp = WindowManager.getImage((int)idList[i]);
                nameList[i] = imp.getTitle();
                gd.addCheckbox(nameList[i], imp == curr);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            for (i = 0; i < nImages; ++i) {
                if (!gd.getNextBoolean()) continue;
                imp = WindowManager.getImage((int)idList[i]);
                inputImgList.add(imp);
            }
        } else {
            inputImgList.add(curr);
        }
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        CacheControl.CacheControls cache = new CacheControl.CacheControls();
        int nTimepoints = 1;
        int setup_id_offset = 0;
        ArrayList<ImagePlus> imgList = new ArrayList<ImagePlus>();
        boolean is2D = true;
        for (ImagePlus imp : inputImgList) {
            AbstractSpimData<?> spimData;
            if (imp.getNSlices() > 1) {
                is2D = false;
            }
            if ((spimData = this.load(imp, converterSetups, sources, setup_id_offset)) == null) continue;
            imgList.add(imp);
            cache.addCacheControl(((ViewerImgLoader)spimData.getSequenceDescription().getImgLoader()).getCacheControl());
            setup_id_offset += imp.getNChannels();
            nTimepoints = Math.max(nTimepoints, imp.getNFrames());
        }
        if (!imgList.isEmpty()) {
            SynchronizedViewerState state;
            BigDataViewer bdv = BigDataViewer.open(converterSetups, sources, (int)nTimepoints, (CacheControl)cache, (String)"BigDataViewer", (ProgressWriter)new ProgressWriterIJ(), (ViewerOptions)ViewerOptions.options().is2D(is2D));
            SynchronizedViewerState synchronizedViewerState = state = bdv.getViewer().state();
            synchronized (synchronizedViewerState) {
                int channelOffset = 0;
                int numActiveChannels = 0;
                for (ImagePlus imp : imgList) {
                    numActiveChannels += this.transferChannelVisibility(channelOffset, imp, (ViewerState)state);
                    this.transferChannelSettings(channelOffset, imp, (ViewerState)state, bdv.getConverterSetups());
                    channelOffset += imp.getNChannels();
                }
                state.setDisplayMode(numActiveChannels > 1 ? DisplayMode.FUSED : DisplayMode.SINGLE);
            }
        }
    }

    protected AbstractSpimData<?> load(ImagePlus imp, ArrayList<ConverterSetup> converterSetups, ArrayList<SourceAndConverter<?>> sources, int setup_id_offset) {
        Object imgLoader;
        switch (imp.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                IJ.showMessage((String)(imp.getShortTitle() + ": Only 8, 16, 32-bit images and RGB images are supported currently!"));
                return null;
            }
        }
        double pw = imp.getCalibration().pixelWidth;
        double ph = imp.getCalibration().pixelHeight;
        double pd = imp.getCalibration().pixelDepth;
        String punit = imp.getCalibration().getUnit();
        if (punit == null || punit.isEmpty()) {
            punit = "px";
        }
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(punit, new double[]{pw, ph, pd});
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getNSlices();
        FinalDimensions size = new FinalDimensions(new int[]{w, h, d});
        if (imp.getStack().isVirtual()) {
            switch (imp.getType()) {
                case 0: {
                    imgLoader = VirtualStackImageLoader.createUnsignedByteInstance(imp, setup_id_offset);
                    break;
                }
                case 1: {
                    imgLoader = VirtualStackImageLoader.createUnsignedShortInstance(imp, setup_id_offset);
                    break;
                }
                case 2: {
                    imgLoader = VirtualStackImageLoader.createFloatInstance(imp, setup_id_offset);
                    break;
                }
                default: {
                    imgLoader = VirtualStackImageLoader.createARGBInstance(imp, setup_id_offset);
                    break;
                }
            }
        } else {
            switch (imp.getType()) {
                case 0: {
                    imgLoader = ImageStackImageLoader.createUnsignedByteInstance(imp, setup_id_offset);
                    break;
                }
                case 1: {
                    imgLoader = ImageStackImageLoader.createUnsignedShortInstance(imp, setup_id_offset);
                    break;
                }
                case 2: {
                    imgLoader = ImageStackImageLoader.createFloatInstance(imp, setup_id_offset);
                    break;
                }
                default: {
                    imgLoader = ImageStackImageLoader.createARGBInstance(imp, setup_id_offset);
                }
            }
        }
        int numTimepoints = imp.getNFrames();
        int numSetups = imp.getNChannels();
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        for (int s = 0; s < numSetups; ++s) {
            BasicViewSetup setup = new BasicViewSetup(setup_id_offset + s, String.format(imp.getTitle() + " channel %d", s + 1), (Dimensions)size, (VoxelDimensions)voxelSize);
            setup.setAttribute((Entity)new Channel(s + 1));
            setups.put(setup_id_offset + s, setup);
        }
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        for (int t = 0; t < numTimepoints; ++t) {
            timepoints.add(new TimePoint(t));
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, imgLoader, null);
        AffineTransform3D sourceTransform = new AffineTransform3D();
        sourceTransform.set(pw, 0.0, 0.0, 0.0, 0.0, ph, 0.0, 0.0, 0.0, 0.0, pd, 0.0);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int t = 0; t < numTimepoints; ++t) {
            for (int s = 0; s < numSetups; ++s) {
                registrations.add(new ViewRegistration(t, setup_id_offset + s, sourceTransform));
            }
        }
        File basePath = new File(".");
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, seq, new ViewRegistrations(registrations));
        WrapBasicImgLoader.wrapImgLoaderIfNecessary((AbstractSpimData)spimData);
        BigDataViewer.initSetups((AbstractSpimData)spimData, converterSetups, sources);
        return spimData;
    }

    protected int transferChannelVisibility(int channelOffset, ImagePlus imp, ViewerState state) {
        int nChannels = imp.getNChannels();
        CompositeImage ci = imp.isComposite() ? (CompositeImage)imp : null;
        List sources = state.getSources();
        if (ci != null && ci.getCompositeMode() == 1) {
            boolean[] activeChannels = ci.getActiveChannels();
            int numActiveChannels = 0;
            for (int i = 0; i < Math.min(activeChannels.length, nChannels); ++i) {
                SourceAndConverter source = (SourceAndConverter)sources.get(channelOffset + i);
                state.setSourceActive(source, activeChannels[i]);
                state.setCurrentSource(source);
                numActiveChannels += activeChannels[i] ? 1 : 0;
            }
            return numActiveChannels;
        }
        int activeChannel = imp.getChannel() - 1;
        for (int i = 0; i < nChannels; ++i) {
            state.setSourceActive((SourceAndConverter)sources.get(channelOffset + i), i == activeChannel);
        }
        state.setCurrentSource((SourceAndConverter)sources.get(channelOffset + activeChannel));
        return 1;
    }

    protected void transferChannelSettings(int channelOffset, ImagePlus imp, ViewerState state, ConverterSetups converterSetups) {
        int nChannels = imp.getNChannels();
        CompositeImage ci = imp.isComposite() ? (CompositeImage)imp : null;
        List sources = state.getSources();
        if (ci != null) {
            int mode = ci.getCompositeMode();
            boolean transferColor = mode == 1 || mode == 2;
            for (int c = 0; c < nChannels; ++c) {
                LUT lut = ci.getChannelLut(c + 1);
                ConverterSetup setup = converterSetups.getConverterSetup((SourceAndConverter)sources.get(channelOffset + c));
                if (transferColor) {
                    setup.setColor(new ARGBType(lut.getRGB(255)));
                }
                setup.setDisplayRange(lut.min, lut.max);
            }
        } else {
            double displayRangeMin = imp.getDisplayRangeMin();
            double displayRangeMax = imp.getDisplayRangeMax();
            for (int i = 0; i < nChannels; ++i) {
                ConverterSetup setup = converterSetups.getConverterSetup((SourceAndConverter)sources.get(channelOffset + i));
                LUT[] luts = imp.getLuts();
                if (luts.length != 0) {
                    setup.setColor(new ARGBType(luts[0].getRGB(255)));
                }
                setup.setDisplayRange(displayRangeMin, displayRangeMax);
            }
        }
    }
}

