/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;

public interface GsonN5Reader
extends N5Reader {
    public Gson getGson();

    @Override
    default public Map<String, Class<?>> listAttributes(String pathName) throws N5Exception {
        return GsonUtils.listAttributes(this.getAttributes(pathName));
    }

    @Override
    default public DatasetAttributes getDatasetAttributes(String pathName) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(pathName);
        JsonElement attributes = this.getAttributes(normalPath);
        return this.createDatasetAttributes(attributes);
    }

    default public DatasetAttributes createDatasetAttributes(JsonElement attributes) {
        try {
            long[] dimensions = GsonUtils.readAttribute(attributes, "dimensions", long[].class, this.getGson());
            if (dimensions == null) {
                return null;
            }
            DataType dataType = GsonUtils.readAttribute(attributes, "dataType", DataType.class, this.getGson());
            if (dataType == null) {
                return null;
            }
            int[] blockSize = GsonUtils.readAttribute(attributes, "blockSize", int[].class, this.getGson());
            Compression compression = GsonUtils.readAttribute(attributes, "compression", Compression.class, this.getGson());
            String compressionVersion0Name = compression == null ? GsonUtils.readAttribute(attributes, "compressionType", String.class, this.getGson()) : null;
            return DatasetAttributes.from(dimensions, dataType, blockSize, compression, compressionVersion0Name);
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            return null;
        }
    }

    @Override
    default public <T> T getAttribute(String pathName, String key, Class<T> clazz) throws N5Exception {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        String normalizedAttributePath = N5URI.normalizeAttributePath(key);
        JsonElement attributes = this.getAttributes(normalPathName);
        try {
            return GsonUtils.readAttribute(attributes, normalizedAttributePath, clazz, this.getGson());
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
    }

    @Override
    default public <T> T getAttribute(String pathName, String key, Type type) throws N5Exception {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        String normalizedAttributePath = N5URI.normalizeAttributePath(key);
        JsonElement attributes = this.getAttributes(normalPathName);
        try {
            return GsonUtils.readAttribute(attributes, normalizedAttributePath, type, this.getGson());
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
    }

    public JsonElement getAttributes(String var1) throws N5Exception;
}

