/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.janelia.saalfeldlab.n5.LinkedAttributePathToken;
import org.janelia.saalfeldlab.n5.N5Exception;

public class N5URI {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Pattern ARRAY_INDEX = Pattern.compile("\\[([0-9]+)]");
    final URI uri;
    private final String scheme;
    private final String container;
    private final String group;
    private final String attribute;

    public N5URI(String uri) throws URISyntaxException {
        this(N5URI.encodeAsUri(uri));
    }

    public N5URI(URI uri) {
        this.uri = uri;
        this.scheme = uri.getScheme() == null ? null : uri.getScheme();
        String schemeSpecificPartWithoutQuery = this.getSchemeSpecificPartWithoutQuery();
        this.container = uri.getScheme() == null ? schemeSpecificPartWithoutQuery.replaceFirst("//", "") : uri.getScheme() + ":" + schemeSpecificPartWithoutQuery;
        this.group = uri.getQuery();
        this.attribute = N5URI.decodeFragment(uri.getRawFragment());
    }

    public String getContainerPath() {
        return this.container;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getGroupPath() {
        return this.group != null ? this.group : "/";
    }

    public String normalizeGroupPath() {
        return N5URI.normalizeGroupPath(this.getGroupPath());
    }

    public String getAttributePath() {
        return this.attribute != null ? this.attribute : "/";
    }

    public String normalizeAttributePath() {
        return N5URI.normalizeAttributePath(this.getAttributePath());
    }

    public LinkedAttributePathToken<?> getAttributePathTokens() {
        return N5URI.getAttributePathTokens(this.normalizeAttributePath());
    }

    public static LinkedAttributePathToken<?> getAttributePathTokens(String normalizedAttributePath) {
        String[] attributePathParts = normalizedAttributePath.replaceAll("^/", "").split("(?<!\\\\)/");
        if (attributePathParts.length == 0 || Arrays.stream(attributePathParts).allMatch(String::isEmpty)) {
            return null;
        }
        AtomicReference firstTokenRef = new AtomicReference();
        AtomicReference currentTokenRef = new AtomicReference();
        Consumer<LinkedAttributePathToken> updateCurrentToken = newToken -> {
            if (firstTokenRef.get() == null) {
                firstTokenRef.set(newToken);
                currentTokenRef.set(firstTokenRef.get());
            } else {
                LinkedAttributePathToken currentToken = (LinkedAttributePathToken)currentTokenRef.get();
                currentToken.childToken = newToken;
                currentTokenRef.set(newToken);
            }
        };
        for (String pathPart : attributePathParts) {
            LinkedAttributePathToken newToken2;
            Matcher matcher = ARRAY_INDEX.matcher(pathPart);
            if (matcher.matches()) {
                int index = Integer.parseInt(matcher.group().replace("[", "").replace("]", ""));
                newToken2 = new LinkedAttributePathToken.ArrayAttributeToken(index);
            } else {
                String pathPartUnEscaped = pathPart.replaceAll("\\\\/", "/").replaceAll("\\\\\\[", "[");
                newToken2 = new LinkedAttributePathToken.ObjectAttributeToken(pathPartUnEscaped);
            }
            updateCurrentToken.accept(newToken2);
        }
        return (LinkedAttributePathToken)firstTokenRef.get();
    }

    private String getSchemePart() {
        return this.scheme == null ? "" : this.scheme + "://";
    }

    private String getContainerPart() {
        return this.container;
    }

    private String getGroupPart() {
        return this.group == null ? "" : "?" + this.group;
    }

    private String getAttributePart() {
        return this.attribute == null ? "" : "#" + this.attribute;
    }

    public String toString() {
        return this.getContainerPart() + this.getGroupPart() + this.getAttributePart();
    }

    private String getSchemeSpecificPartWithoutQuery() {
        return this.uri.getSchemeSpecificPart().replace("?" + this.uri.getQuery(), "");
    }

    public boolean isAbsolute() {
        if (this.scheme != null) {
            return true;
        }
        String path = this.uri.getPath();
        if (!path.isEmpty()) {
            char char0 = path.charAt(0);
            return char0 == '/' || path.length() >= 2 && path.charAt(1) == ':' && char0 >= 'A' && char0 <= 'Z';
        }
        return false;
    }

    public N5URI resolve(N5URI relativeN5Url) throws URISyntaxException {
        String path;
        URI thisUri = this.uri;
        URI relativeUri = relativeN5Url.uri;
        StringBuilder newUri = new StringBuilder();
        if (relativeUri.getScheme() != null) {
            return relativeN5Url;
        }
        String thisScheme = thisUri.getScheme();
        if (thisScheme != null) {
            newUri.append(thisScheme).append(":");
        }
        if (relativeUri.getAuthority() != null) {
            newUri.append(relativeUri.getAuthority()).append(relativeUri.getPath()).append(relativeN5Url.getGroupPart()).append(relativeN5Url.getAttributePart());
            return new N5URI(newUri.toString());
        }
        String thisAuthority = thisUri.getAuthority();
        if (thisAuthority != null) {
            newUri.append("//").append(thisAuthority);
        }
        if (!(path = relativeUri.getPath()).isEmpty()) {
            if (!relativeN5Url.isAbsolute()) {
                newUri.append(thisUri.getPath()).append('/');
            }
            newUri.append(path).append(relativeN5Url.getGroupPart()).append(relativeN5Url.getAttributePart());
            return new N5URI(newUri.toString());
        }
        newUri.append(thisUri.getPath());
        String query = relativeUri.getQuery();
        if (query != null) {
            if (query.charAt(0) != '/' && thisUri.getQuery() != null) {
                newUri.append(this.getGroupPart()).append('/');
                newUri.append(relativeUri.getQuery());
            } else {
                newUri.append(relativeN5Url.getGroupPart());
            }
            newUri.append(relativeN5Url.getAttributePart());
            return new N5URI(newUri.toString());
        }
        newUri.append(this.getGroupPart());
        String fragment = relativeUri.getFragment();
        if (fragment != null) {
            if (fragment.charAt(0) != '/' && thisUri.getFragment() != null) {
                newUri.append(this.getAttributePart()).append('/');
            } else {
                newUri.append(relativeN5Url.getAttributePart());
            }
            return new N5URI(newUri.toString());
        }
        newUri.append(this.getAttributePart());
        return new N5URI(newUri.toString());
    }

    public N5URI resolve(URI relativeUri) throws URISyntaxException {
        return this.resolve(new N5URI(relativeUri));
    }

    public N5URI resolve(String relativeString) throws URISyntaxException {
        return this.resolve(new N5URI(relativeString));
    }

    private static String normalizePath(String path) {
        path = path == null ? "" : path;
        char[] pathChars = path.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder curToken = new StringBuilder();
        boolean escape = false;
        for (char character : pathChars) {
            if (escape) {
                escape = false;
                curToken.append(character);
                continue;
            }
            if (character == '\\') {
                escape = true;
                continue;
            }
            if (character == '/') {
                String newToken;
                if (tokens.isEmpty() && curToken.length() == 0) {
                    curToken.append(character);
                }
                if (!(newToken = curToken.toString()).isEmpty()) {
                    if (newToken.equals("..")) {
                        tokens.remove(tokens.size() - 1);
                    } else {
                        tokens.add(newToken);
                    }
                }
                curToken.setLength(0);
                continue;
            }
            curToken.append(character);
        }
        String lastToken = curToken.toString();
        if (!lastToken.isEmpty()) {
            if (lastToken.equals("..")) {
                tokens.remove(tokens.size() - 1);
            } else {
                tokens.add(lastToken);
            }
        }
        if (tokens.isEmpty()) {
            return "";
        }
        String root = "";
        if (((String)tokens.get(0)).equals("/")) {
            tokens.remove(0);
            root = "/";
        }
        return root + tokens.stream().filter(it -> !it.equals(".")).filter(it -> !it.isEmpty()).reduce((l, r) -> l + "/" + r).orElse("");
    }

    public static String normalizeGroupPath(String path) {
        return N5URI.normalizePath(path.startsWith("/") || path.startsWith("\\") ? path.substring(1) : path);
    }

    public static String normalizeAttributePath(String attributePath) {
        if (!attributePath.matches(".*((?<!\\\\)(/|\\[[0-9]+])).*")) {
            return attributePath;
        }
        String attrPathPlusFirstIndexSeparator = attributePath.replaceAll("^(?<array>\\[[0-9]+])", "${array}/");
        String attrPathPlusIndexSeparators = attrPathPlusFirstIndexSeparator.replaceAll("((?<!(^|\\\\))(?<array>\\[[0-9]+]))", "/${array}/");
        Pattern relativePathPattern = Pattern.compile("((?<=/)/+|(?<=(/|^))(\\./)+|((/|(?<=/))\\.)$|(?<!(^|\\\\))/$|((?<=^/)|^|(?<=(/|^))[^/]+(?<!(/|(/|^)\\.\\.))/)\\.\\./?)");
        int prevStringLenth = 0;
        String resolvedAttributePath = attrPathPlusIndexSeparators;
        while (prevStringLenth != resolvedAttributePath.length()) {
            prevStringLenth = resolvedAttributePath.length();
            resolvedAttributePath = relativePathPattern.matcher(resolvedAttributePath).replaceAll("");
        }
        return resolvedAttributePath;
    }

    public static URI getAsUri(String uri) throws N5Exception {
        try {
            return URI.create(uri);
        }
        catch (Exception ignore) {
            try {
                return N5URI.encodeAsUri(uri);
            }
            catch (URISyntaxException e) {
                throw new N5Exception("Could not encode as URI: " + uri, e);
            }
        }
    }

    public static URI encodeAsUriPath(String path) {
        try {
            return new URI(null, null, path, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not encode as URI path component:  " + path, e);
        }
    }

    public static URI encodeAsUri(String uri) throws URISyntaxException {
        String fragment;
        String uriWithoutFragment;
        if (uri.trim().length() == 0) {
            return new URI(uri);
        }
        int fragmentIdx = uri.lastIndexOf(35);
        if (fragmentIdx >= 0) {
            uriWithoutFragment = uri.substring(0, fragmentIdx);
            fragment = uri.substring(fragmentIdx + 1);
        } else {
            uriWithoutFragment = uri;
            fragment = null;
        }
        URI _n5Uri = uriWithoutFragment.length() == 0 && fragment != null && fragment.length() > 0 ? new URI("N5Internal", "//STAND_IN", fragment) : new URI("N5Internal", uriWithoutFragment, fragment);
        URI n5Uri = fragment == null ? new URI(_n5Uri.getRawSchemeSpecificPart()) : (Objects.equals(_n5Uri.getPath(), "") && Objects.equals(_n5Uri.getAuthority(), "STAND_IN") ? new URI("#" + _n5Uri.getRawFragment()) : new URI(_n5Uri.getRawSchemeSpecificPart() + "#" + _n5Uri.getRawFragment()));
        return n5Uri;
    }

    public static N5URI from(String container, String group, String attribute) throws URISyntaxException {
        String containerPart = container != null ? container : "";
        String groupPart = group != null ? "?" + group : "";
        String attributePart = attribute != null ? "#" + attribute : "";
        return new N5URI(containerPart + groupPart + attributePart);
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        assert (false);
        return -1;
    }

    private static byte decode(char c1, char c2) {
        return (byte)((N5URI.decode(c1) & 0xF) << 4 | (N5URI.decode(c2) & 0xF) << 0);
    }

    private static String decodeFragment(String rawFragment) {
        if (rawFragment == null) {
            return rawFragment;
        }
        int n = rawFragment.length();
        if (n == 0) {
            return rawFragment;
        }
        if (rawFragment.indexOf(37) < 0) {
            return rawFragment;
        }
        StringBuffer sb = new StringBuffer(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        CharBuffer cb = CharBuffer.allocate(n);
        CharsetDecoder dec = UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char c = rawFragment.charAt(0);
        int i = 0;
        while (i < n) {
            assert (c == rawFragment.charAt(i));
            if (c != '%') {
                sb.append(c);
                if (++i >= n) break;
                c = rawFragment.charAt(i);
                continue;
            }
            bb.clear();
            do {
                assert (n - i >= 2);
                bb.put(N5URI.decode(rawFragment.charAt(++i), rawFragment.charAt(++i)));
            } while (++i < n && (c = rawFragment.charAt(i)) == '%');
            bb.flip();
            cb.clear();
            dec.reset();
            CoderResult cr = dec.decode(bb, cb, true);
            assert (cr.isUnderflow());
            cr = dec.flush(cb);
            assert (cr.isUnderflow());
            sb.append(cb.flip());
        }
        return sb.toString();
    }
}

