/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccessible;
import net.imglib2.concatenate.ConcatenateUtils;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;
import net.imglib2.realtransform.AffineRealRandomAccessible;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRandomAccessible;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale2D;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.realtransform.ScaleAndTranslationGet;
import net.imglib2.realtransform.ScaleGet;
import net.imglib2.realtransform.Translation;
import net.imglib2.realtransform.Translation2D;
import net.imglib2.realtransform.Translation3D;
import net.imglib2.realtransform.TranslationGet;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;

public class RealViewsSimplifyUtils {
    public static boolean isExclusiveScaleAndTranslation(AffineGet affineGet) {
        if (affineGet instanceof ScaleAndTranslationGet) {
            return true;
        }
        int n = affineGet.numDimensions();
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n + 1; ++c) {
                if (affineGet.get(r, c) == 0.0 || r == c || c == n) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isExclusiveScale(AffineGet affineGet) {
        if (affineGet instanceof ScaleGet) {
            return true;
        }
        int n = affineGet.numDimensions();
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n + 1; ++c) {
                if (affineGet.get(r, c) == 0.0 || r == c) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isExlusiveTranslation(AffineGet affineGet) {
        if (affineGet instanceof TranslationGet) {
            return true;
        }
        int n = affineGet.numDimensions();
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n + 1; ++c) {
                double val = affineGet.get(r, c);
                if (val == 0.0 || (r != c || val == 1.0) && (c == n || val == 1.0)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentity(AffineGet affineGet) {
        int n = affineGet.numDimensions();
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n + 1; ++c) {
                double val = affineGet.get(r, c);
                if ((r != c || val == 1.0) && (r == c || val == 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> RealRandomAccessible<T> simplifyReal(RealRandomAccessible<T> source) {
        Pair<RealRandomAccessible<T>, RealTransform> tmp = RealViewsSimplifyUtils.findSourceAndSimplifyTransforms(source);
        if (tmp.getB() == null) {
            return (RealRandomAccessible)tmp.getA();
        }
        return RealViewsSimplifyUtils.createRealRandomAccessible((RealRandomAccessible)tmp.getA(), (RealTransform)tmp.getB());
    }

    public static <T> RandomAccessible<T> simplify(RealRandomAccessible<T> source) {
        Pair<RealRandomAccessible<T>, RealTransform> tmp = RealViewsSimplifyUtils.findSourceAndSimplifyTransforms(source);
        if (tmp.getB() == null) {
            if (tmp.getA() instanceof RandomAccessible) {
                return (RandomAccessible)tmp.getA();
            }
            return new RandomAccessibleOnRealRandomAccessible(source);
        }
        return RealViewsSimplifyUtils.createRandomAccessible((RealRandomAccessible)tmp.getA(), (RealTransform)tmp.getB());
    }

    protected static RealTransform simplifyRealTransform(RealTransform transform) {
        RealTransform tmp = transform instanceof InverseRealTransform ? ((InverseRealTransform)transform).inverse().inverse() : transform;
        if (transform instanceof AffineGet) {
            return RealViewsSimplifyUtils.simplifyAffineGet((AffineGet)tmp);
        }
        return tmp;
    }

    private static AffineGet simplifyAffineGet(AffineGet affineGet) {
        int n = affineGet.numDimensions();
        if (RealViewsSimplifyUtils.isExlusiveTranslation(affineGet)) {
            double[] translations = new double[n];
            for (int d = 0; d < n; ++d) {
                translations[d] = affineGet.get(d, n);
            }
            if (n == 2) {
                return new Translation2D(translations);
            }
            if (n == 3) {
                return new Translation3D(translations);
            }
            return new Translation(translations);
        }
        if (RealViewsSimplifyUtils.isExclusiveScale(affineGet)) {
            double[] scalings = new double[n];
            for (int d = 0; d < n; ++d) {
                scalings[d] = affineGet.get(d, d);
            }
            if (n == 2) {
                return new Scale2D(scalings);
            }
            if (n == 3) {
                return new Scale3D(scalings);
            }
            return new Scale(scalings);
        }
        if (RealViewsSimplifyUtils.isExclusiveScaleAndTranslation(affineGet)) {
            double[] s = new double[n];
            double[] t = new double[n];
            for (int d = 0; d < n; ++d) {
                t[d] = affineGet.get(d, n);
                s[d] = affineGet.get(d, d);
            }
            return new ScaleAndTranslation(s, t);
        }
        return affineGet.copy();
    }

    private static <T> RandomAccessible<T> createRandomAccessible(RealRandomAccessible<T> rra, RealTransform t) {
        if (t instanceof AffineGet) {
            return new AffineRandomAccessible<T, AffineGet>(rra, (AffineGet)t);
        }
        return new RealTransformRandomAccessible<T, RealTransform>(rra, t);
    }

    private static <T> RealRandomAccessible<T> createRealRandomAccessible(RealRandomAccessible<T> rra, RealTransform t) {
        if (!t.isIdentity()) {
            if (t instanceof AffineGet) {
                return new AffineRealRandomAccessible<T, AffineGet>(rra, (AffineGet)t);
            }
            return new RealTransformRealRandomAccessible<T, RealTransform>(rra, t);
        }
        return rra;
    }

    private static <T> Pair<RealRandomAccessible<T>, RealTransform> findSourceAndSimplifyTransforms(RealRandomAccessible<T> source) {
        LinkedList<RealTransform> transforms = new LinkedList<RealTransform>();
        RealRandomAccessible<T> tmp = source;
        if (tmp instanceof RealTransformRealRandomAccessible) {
            transforms.add((RealTransform)((RealTransformRealRandomAccessible)tmp).getTransformToSource());
            tmp = ((RealTransformRealRandomAccessible)tmp).getSource();
            while (tmp instanceof RealTransformRealRandomAccessible) {
                transforms.add(((RealTransformRealRandomAccessible)tmp).getTransformToSource().copy());
                tmp = ((RealTransformRealRandomAccessible)tmp).getSource();
            }
            RealViewsSimplifyUtils.simplifyRealTransforms(transforms);
            for (int i = 0; i < transforms.size() - 1; ++i) {
                tmp = RealViewsSimplifyUtils.createRealRandomAccessible(tmp, (RealTransform)transforms.get(i));
            }
            if (transforms.size() > 0) {
                return new ValuePair(tmp, transforms.get(transforms.size() - 1));
            }
        }
        return new ValuePair(tmp, null);
    }

    private static void simplifyRealTransforms(List<RealTransform> transforms) {
        int oldSize = transforms.size() + 1;
        Collections.reverse(transforms);
        while (transforms.size() < oldSize && transforms.size() > 0) {
            oldSize = transforms.size();
            Iterator<RealTransform> it = transforms.iterator();
            int i = 0;
            while (it.hasNext()) {
                RealTransform simplified = RealViewsSimplifyUtils.simplifyRealTransform(it.next());
                if (!simplified.isIdentity()) {
                    transforms.set(i, simplified);
                } else {
                    it.remove();
                    --i;
                }
                ++i;
            }
            ConcatenateUtils.join(transforms);
        }
    }
}

