/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.inverse;

import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;

public abstract class AbstractDifferentiableRealTransform
implements DifferentiableRealTransform {
    @Override
    public abstract AffineTransform jacobian(double[] var1);

    @Override
    public void directionToward(double[] displacement, double[] x, double[] y) {
        AbstractDifferentiableRealTransform.directionToward(this.jacobian(x), displacement, x, y);
    }

    public static void directionToward(AffineTransform jacobian, double[] displacement, double[] x, double[] y) {
        int i;
        double[] err = new double[x.length];
        for (int i2 = 0; i2 < x.length; ++i2) {
            err[i2] = y[i2] - x[i2];
        }
        double[] dir = new double[x.length];
        AbstractDifferentiableRealTransform.matrixTranspose(jacobian).apply(err, dir);
        double norm = 0.0;
        for (i = 0; i < dir.length; ++i) {
            norm += dir[i] * dir[i];
        }
        norm = Math.sqrt(norm);
        i = 0;
        while (i < dir.length) {
            int n = i++;
            dir[n] = dir[n] / norm;
        }
        System.arraycopy(dir, 0, displacement, 0, dir.length);
    }

    public static AffineTransform matrixTranspose(AffineTransform a) {
        int nd = a.numDimensions();
        AffineTransform aT = new AffineTransform(nd);
        double[][] mtx = new double[nd][nd + 1];
        for (int i = 0; i < nd; ++i) {
            for (int j = 0; j < nd; ++j) {
                mtx[j][i] = a.get(i, j);
            }
        }
        aT.set(mtx);
        return aT;
    }
}

