/*
 * Decompiled with CFR 0.152.
 */
package org.siox;

import java.util.ArrayList;

class ColorSignature {
    private static ArrayList clusters1 = new ArrayList();
    private static ArrayList clusters2 = new ArrayList();

    ColorSignature() {
    }

    private static void stageone(float[][] points, int depth, ArrayList clusters, float[] limits, int length) {
        if (length < 1) {
            return;
        }
        int dims = points[0].length;
        int curdim = depth % dims;
        float min = points[0][curdim];
        float max = points[0][curdim];
        for (int i = 1; i < length; ++i) {
            if (min > points[i][curdim]) {
                min = points[i][curdim];
            }
            if (!(max < points[i][curdim])) continue;
            max = points[i][curdim];
        }
        if (max - min > limits[curdim]) {
            float pivotvalue = (max - min) / 2.0f + min;
            int countsm = 0;
            int countgr = 0;
            for (int i = 0; i < length; ++i) {
                if (points[i][curdim] <= pivotvalue) {
                    ++countsm;
                    continue;
                }
                ++countgr;
            }
            float[][] smallerpoints = new float[countsm][dims];
            float[][] biggerpoints = new float[countgr][dims];
            int smallc = 0;
            int bigc = 0;
            for (int i = 0; i < length; ++i) {
                if (points[i][curdim] <= pivotvalue) {
                    smallerpoints[smallc++] = points[i];
                    continue;
                }
                biggerpoints[bigc++] = points[i];
            }
            ColorSignature.stageone(smallerpoints, depth + 1, clusters, limits, smallerpoints.length);
            ColorSignature.stageone(biggerpoints, depth + 1, clusters, limits, biggerpoints.length);
        } else {
            clusters.add(points);
        }
    }

    private static void stagetwo(float[][] points, int depth, ArrayList clusters, float[] limits, int total, float threshold) {
        if (points.length < 1) {
            return;
        }
        int dims = points[0].length - 1;
        int curdim = depth % dims;
        float min = points[0][curdim];
        float max = points[0][curdim];
        for (int i = 1; i < points.length; ++i) {
            if (min > points[i][curdim]) {
                min = points[i][curdim];
            }
            if (!(max < points[i][curdim])) continue;
            max = points[i][curdim];
        }
        if (max - min > limits[curdim]) {
            float pivotvalue = (max - min) / 2.0f + min;
            int countsm = 0;
            int countgr = 0;
            for (int i = 0; i < points.length; ++i) {
                if (points[i][curdim] <= pivotvalue) {
                    ++countsm;
                    continue;
                }
                ++countgr;
            }
            float[][] smallerpoints = new float[countsm][dims];
            float[][] biggerpoints = new float[countgr][dims];
            int smallc = 0;
            int bigc = 0;
            for (int i = 0; i < points.length; ++i) {
                if (points[i][curdim] <= pivotvalue) {
                    smallerpoints[smallc++] = points[i];
                    continue;
                }
                biggerpoints[bigc++] = points[i];
            }
            ColorSignature.stagetwo(smallerpoints, depth + 1, clusters, limits, total, threshold);
            ColorSignature.stagetwo(biggerpoints, depth + 1, clusters, limits, total, threshold);
        } else {
            int sum = 0;
            for (int i = 0; i < points.length; ++i) {
                sum = (int)((float)sum + points[i][points[i].length - 1]);
            }
            if ((double)sum * 100.0 / (double)total >= (double)threshold) {
                float[] point = new float[points[0].length];
                for (int i = 0; i < points.length; ++i) {
                    for (int j = 0; j < points[0].length; ++j) {
                        int n = j;
                        point[n] = point[n] + points[i][j];
                    }
                }
                int j = 0;
                while (j < points[0].length - 1) {
                    int n = j++;
                    point[n] = point[n] / (float)points.length;
                }
                clusters.add(point);
            }
        }
    }

    static float[][] createSignature(float[][] input, int length, float[] limits, float threshold) {
        clusters1.clear();
        clusters2.clear();
        ColorSignature.stageone(input, 0, clusters1, limits, length);
        float[][] centroids = new float[clusters1.size()][];
        for (int i = 0; i < clusters1.size(); ++i) {
            float[][] cluster = (float[][])clusters1.get(i);
            float[] centroid = new float[cluster[0].length + 1];
            for (int k = 0; k < cluster.length; ++k) {
                for (int j = 0; j < cluster[k].length; ++j) {
                    int n = j;
                    centroid[n] = centroid[n] + cluster[k][j];
                }
            }
            int j = 0;
            while (j < cluster[0].length) {
                int n = j++;
                centroid[n] = centroid[n] / (float)cluster.length;
            }
            centroid[cluster[0].length] = cluster.length;
            centroids[i] = centroid;
        }
        ColorSignature.stagetwo(centroids, 0, clusters2, limits, length, threshold);
        float[][] res = (float[][])clusters2.toArray((T[])new float[0][0]);
        return res;
    }
}

