/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class ImageConverter<S extends Type<S>, T extends Type<T>>
implements OutputAlgorithm<T>,
MultiThreaded,
Benchmark {
    final Image<S> image;
    final Image<T> output;
    final Converter<S, T> converter;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public ImageConverter(Image<S> image, Image<T> output, Converter<S, T> converter) {
        this.image = image;
        this.output = output;
        this.converter = converter;
        this.setNumThreads();
    }

    public ImageConverter(Image<S> image, ImageFactory<T> factory, Converter<S, T> converter) {
        this(image, ImageConverter.createImageFromFactory(factory, image.getDimensions()), converter);
    }

    @Override
    public Image<T> getResult() {
        return this.output;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ImageCalculator: [Image<S> image1] is null.";
            return false;
        }
        if (this.output == null) {
            this.errorMessage = "ImageCalculator: [Image<T> output] is null.";
            return false;
        }
        if (this.converter == null) {
            this.errorMessage = "ImageCalculator: [Converter<S,T>] is null.";
            return false;
        }
        if (!this.image.getContainer().compareStorageContainerDimensions(this.output.getContainer())) {
            this.errorMessage = "ImageCalculator: Images have different dimensions, not supported: Image: " + Util.printCoordinates(this.image.getDimensions()) + " Output: " + Util.printCoordinates(this.output.getDimensions());
            return false;
        }
        return true;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        long imageSize = this.image.getNumPixels();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, this.numThreads);
        final boolean isCompatible = this.image.getContainer().compareStorageContainerCompatibility(this.output.getContainer());
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    if (isCompatible) {
                        ImageConverter.this.computeSimple(myChunk.getStartPosition(), myChunk.getLoopSize());
                    } else {
                        ImageConverter.this.computeAdvanced(myChunk.getStartPosition(), myChunk.getLoopSize());
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void computeSimple(long startPos, long loopSize) {
        Cursor<S> cursorIn = this.image.createCursor();
        Cursor<T> cursorOut = this.output.createCursor();
        cursorIn.fwd(startPos);
        cursorOut.fwd(startPos);
        for (long j = 0L; j < loopSize; ++j) {
            cursorIn.fwd();
            cursorOut.fwd();
            this.converter.convert(cursorIn.getType(), cursorOut.getType());
        }
        cursorIn.close();
        cursorOut.close();
    }

    protected void computeAdvanced(long startPos, long loopSize) {
        LocalizableByDimCursor<S> cursorIn = this.image.createLocalizableByDimCursor();
        LocalizableCursor<T> cursorOut = this.output.createLocalizableCursor();
        cursorOut.fwd(startPos);
        for (long j = 0L; j < loopSize; ++j) {
            cursorOut.fwd();
            cursorIn.setPosition(cursorOut);
            this.converter.convert(cursorIn.getType(), cursorOut.getType());
        }
        cursorIn.close();
        cursorOut.close();
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    protected static <T extends Type<T>> Image<T> createImageFromFactory(ImageFactory<T> factory, int[] size) {
        if (factory == null || size == null) {
            return null;
        }
        return factory.createImage(size);
    }
}

