/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.function.SubtractNorm;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution2;
import mpicbg.imglib.algorithm.math.ImageCalculatorInPlace;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.function.Function;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.NumericType;

public class DifferenceOfGaussian<A extends Type<A>, B extends NumericType<B> & Comparable<B>>
implements Algorithm,
MultiThreaded,
Benchmark {
    protected final Image<A> image;
    protected Image<B> dogImage;
    protected final ImageFactory<B> factory;
    protected final OutOfBoundsStrategyFactory<B> outOfBoundsFactory;
    final double[] sigma1;
    final double[] sigma2;
    final B normalizationFactor;
    final B minPeakValue;
    final B negMinPeakValue;
    final B zero;
    final B one;
    final B minusOne;
    protected final ArrayList<DifferenceOfGaussianPeak<B>> peaks = new ArrayList();
    protected final Converter<A, B> converter;
    boolean computeConvolutionsParalell = true;
    boolean keepDoGImage;
    long processingTime = -1L;
    int numThreads;
    String errorMessage = "";

    private static final double[] asArray(int nDim, double sigma) {
        double[] s = new double[nDim];
        for (int i = 0; i < nDim; ++i) {
            s[i] = sigma;
        }
        return s;
    }

    public DifferenceOfGaussian(Image<A> img, ImageFactory<B> factory, Converter<A, B> converter, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, double sigma1, double sigma2, B minPeakValue, B normalizationFactor) {
        this(img, factory, converter, outOfBoundsFactory, DifferenceOfGaussian.asArray(img.getNumDimensions(), sigma1), DifferenceOfGaussian.asArray(img.getNumDimensions(), sigma2), minPeakValue, normalizationFactor);
    }

    public DifferenceOfGaussian(Image<A> img, ImageFactory<B> factory, Converter<A, B> converter, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, double[] sigma1, double[] sigma2, B minPeakValue, B normalizationFactor) {
        this.setNumThreads();
        this.image = img;
        this.factory = factory;
        this.outOfBoundsFactory = outOfBoundsFactory;
        this.converter = converter;
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.normalizationFactor = normalizationFactor;
        this.minPeakValue = minPeakValue;
        this.zero = (NumericType)factory.createType();
        this.zero.setZero();
        this.one = (NumericType)factory.createType();
        this.one.setOne();
        this.minusOne = (NumericType)factory.createType();
        this.minusOne.setZero();
        this.minusOne.sub(this.one);
        this.negMinPeakValue = (NumericType)minPeakValue.copy();
        this.negMinPeakValue.mul(this.minusOne);
        this.dogImage = null;
        this.keepDoGImage = false;
    }

    public void setMinPeakValue(B value) {
        this.minPeakValue.set(value);
    }

    public B getMinPeakValue() {
        return (B)((NumericType)this.minPeakValue.copy());
    }

    public Image<B> getDoGImage() {
        return this.dogImage;
    }

    public void setKeepDoGImage(boolean keepDoGImage) {
        this.keepDoGImage = keepDoGImage;
    }

    public boolean getKeepDoGImage() {
        return this.keepDoGImage;
    }

    public ArrayList<DifferenceOfGaussianPeak<B>> getPeaks() {
        return this.peaks;
    }

    public void setComputeConvolutionsParalell(boolean paralell) {
        this.computeConvolutionsParalell = paralell;
    }

    public boolean getComputeConvolutionsParalell() {
        return this.computeConvolutionsParalell;
    }

    protected OutputAlgorithm<B> getGaussianConvolution(double[] sigma, int nThreads) {
        GaussianConvolution2<A, B> gauss = new GaussianConvolution2<A, B>(this.image, this.factory, this.outOfBoundsFactory, this.converter, sigma);
        return gauss;
    }

    protected Function<B, B, B> getNormalizedSubtraction() {
        return new SubtractNorm<B>(this.normalizationFactor);
    }

    protected boolean isPeakHighEnough(B value) {
        if (((Comparable)value).compareTo(this.zero) >= 0) {
            return ((Comparable)value).compareTo(this.minPeakValue) >= 0;
        }
        return ((Comparable)value).compareTo(this.negMinPeakValue) <= 0;
    }

    protected SpecialPoint isSpecialPoint(LocalNeighborhoodCursor<B> neighborhoodCursor, B centerValue) {
        boolean isMax;
        NumericType value;
        boolean isMin = true;
        for (isMax = true; (isMax || isMin) && neighborhoodCursor.hasNext(); isMin &= ((Comparable)((Object)value)).compareTo(centerValue) >= 0, isMax &= ((Comparable)((Object)value)).compareTo(centerValue) <= 0) {
            neighborhoodCursor.fwd();
            value = (NumericType)neighborhoodCursor.getType();
        }
        if (isMin) {
            return SpecialPoint.MAX;
        }
        if (isMax) {
            return SpecialPoint.MIN;
        }
        return SpecialPoint.INVALID;
    }

    @Override
    public boolean process() {
        Thread[] threads;
        long startTime = System.currentTimeMillis();
        int divisor = this.computeConvolutionsParalell ? 2 : 1;
        final OutputAlgorithm<B> conv1 = this.getGaussianConvolution(this.sigma1, Math.max(1, this.getNumThreads() / divisor));
        final OutputAlgorithm<B> conv2 = this.getGaussianConvolution(this.sigma2, Math.max(1, this.getNumThreads() / divisor));
        if (conv1.checkInput() && conv2.checkInput()) {
            final AtomicInteger ai = new AtomicInteger(0);
            threads = SimpleMultiThreading.newThreads(divisor);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        if (!(myNumber != 0 && DifferenceOfGaussian.this.computeConvolutionsParalell || conv1.process())) {
                            System.out.println("Cannot compute gaussian convolution 1: " + conv1.getErrorMessage());
                        }
                        if (!(myNumber != 1 && DifferenceOfGaussian.this.computeConvolutionsParalell || conv2.process())) {
                            System.out.println("Cannot compute gaussian convolution 2: " + conv2.getErrorMessage());
                        }
                    }
                });
            }
        } else {
            this.errorMessage = "Cannot compute gaussian convolutions: " + conv1.getErrorMessage() + " & " + conv2.getErrorMessage();
            Object gauss2 = null;
            Object gauss1 = null;
            return false;
        }
        SimpleMultiThreading.startAndJoin(threads);
        if (conv1.getErrorMessage().length() != 0 || conv2.getErrorMessage().length() != 0) {
            Object gauss2 = null;
            Object gauss1 = null;
            return false;
        }
        Image<B> gauss1 = conv1.getResult();
        Image<B> gauss2 = conv2.getResult();
        Function<B, B, B> function = this.getNormalizedSubtraction();
        ImageCalculatorInPlace<B, B> imageCalc = new ImageCalculatorInPlace<B, B>(gauss2, gauss1, function);
        imageCalc.setNumThreads(this.getNumThreads());
        if (!imageCalc.checkInput() || !imageCalc.process()) {
            this.errorMessage = "Cannot subtract images: " + imageCalc.getErrorMessage();
            gauss1.close();
            gauss2.close();
            return false;
        }
        gauss1.close();
        this.peaks.clear();
        this.peaks.addAll(this.findPeaks(gauss2));
        if (this.keepDoGImage) {
            this.dogImage = gauss2;
        } else {
            gauss2.close();
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    public ArrayList<DifferenceOfGaussianPeak<B>> findPeaks(final Image<B> laPlace) {
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final int nThreads = threads.length;
        final int numDimensions = laPlace.getNumDimensions();
        final Vector threadPeaksList = new Vector();
        for (int i = 0; i < nThreads; ++i) {
            threadPeaksList.add(new ArrayList());
        }
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    ArrayList myPeaks = (ArrayList)threadPeaksList.get(myNumber);
                    LocalizableByDimCursor cursor = laPlace.createLocalizableByDimCursor();
                    LocalNeighborhoodCursor neighborhoodCursor = LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(cursor);
                    int[] position = new int[numDimensions];
                    int[] dimensionsMinus2 = laPlace.getDimensions();
                    int d = 0;
                    while (d < numDimensions) {
                        int n = d++;
                        dimensionsMinus2[n] = dimensionsMinus2[n] - 2;
                    }
                    block1: while (cursor.hasNext()) {
                        cursor.fwd();
                        cursor.getPosition(position);
                        if (position[0] % nThreads != myNumber) continue;
                        for (d = 0; d < numDimensions; ++d) {
                            int pos = position[d];
                            if (pos < 1 || pos > dimensionsMinus2[d]) continue block1;
                        }
                        NumericType currentValue = (NumericType)((NumericType)cursor.getType()).copy();
                        if (!DifferenceOfGaussian.this.isPeakHighEnough(currentValue)) continue;
                        neighborhoodCursor.update();
                        SpecialPoint specialPoint = DifferenceOfGaussian.this.isSpecialPoint(neighborhoodCursor, currentValue);
                        if (specialPoint != SpecialPoint.INVALID) {
                            myPeaks.add(new DifferenceOfGaussianPeak<NumericType>(position, currentValue, specialPoint));
                        }
                        neighborhoodCursor.reset();
                    }
                    cursor.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        ArrayList<DifferenceOfGaussianPeak<B>> dogPeaks = new ArrayList<DifferenceOfGaussianPeak<B>>();
        for (ArrayList arrayList : threadPeaksList) {
            dogPeaks.addAll(arrayList);
        }
        return dogPeaks;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "DifferenceOfGaussian: [Image<A> img] is null.";
            return false;
        }
        if (this.factory == null) {
            this.errorMessage = "DifferenceOfGaussian: [ImageFactory<B> img] is null.";
            return false;
        }
        if (this.outOfBoundsFactory == null) {
            this.errorMessage = "DifferenceOfGaussian: [OutOfBoundsStrategyFactory<B>] is null.";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    public static enum SpecialPoint {
        INVALID,
        MIN,
        MAX;

    }
}

