/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.basictypecontainer.array.FakeArray;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

public class ArrayLocalizableByDimCursor<T extends Type<T>>
extends ArrayLocalizableCursor<T>
implements LocalizableByDimCursor<T> {
    protected final int[] step;
    final int[] tmp;
    int numNeighborhoodCursors = 0;

    public ArrayLocalizableByDimCursor(Array<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.step = Array.createAllocationSteps(container.getDimensions());
        this.tmp = new int[this.numDimensions];
    }

    public static ArrayLocalizableByDimCursor<FakeType> createLinearByDimCursor(int[] dim) {
        Array array = new Array(null, new FakeArray(), dim, 1);
        return new ArrayLocalizableByDimCursor<FakeType>(array, null, new FakeType());
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.out.println("ArrayLocalizableByDimCursor.createLocalNeighborhoodCursor(): There is only one one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] offset, int[] size) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, offset, size);
        }
        System.out.println("ArrayLocalizableByDimCursor.createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd(int dim) {
        this.type.incIndex(this.step[dim]);
        int n = dim;
        this.position[n] = this.position[n] + 1;
    }

    @Override
    public void move(int steps, int dim) {
        this.type.incIndex(this.step[dim] * steps);
        int n = dim;
        this.position[n] = this.position[n] + steps;
    }

    @Override
    public void bck(int dim) {
        this.type.decIndex(this.step[dim]);
        int n = dim;
        this.position[n] = this.position[n] - 1;
    }

    @Override
    public void moveRel(int[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.move(vector[d], d);
        }
    }

    @Override
    public void moveTo(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int dist = position[d] - this.getPosition(d);
            if (dist == 0) continue;
            this.move(dist, d);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.moveTo(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int[] position) {
        this.type.updateIndex(this.container.getPos(position));
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int dim) {
        this.position[dim] = position;
        this.type.updateIndex(this.container.getPos(this.position));
    }
}

