/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.nearestneighbor;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator3D;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class NearestNeighborInterpolator3D<T extends Type<T>>
extends NearestNeighborInterpolator<T>
implements Interpolator3D<T> {
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;

    protected NearestNeighborInterpolator3D(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory);
    }

    @Override
    public Image<T> getImage() {
        return this.img;
    }

    @Override
    public void getPosition(float[] pos) {
        pos[0] = this.x;
        pos[1] = this.y;
        pos[2] = this.z;
    }

    @Override
    public float[] getPosition() {
        return new float[]{this.x, this.y, this.z};
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public void moveTo(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        int ix = Util.round(x);
        int iy = Util.round(y);
        int iz = Util.round(z);
        this.cursor.move(ix - this.cursor.getPosition(0), 0);
        this.cursor.move(iy - this.cursor.getPosition(1), 1);
        this.cursor.move(iz - this.cursor.getPosition(2), 2);
    }

    @Override
    public void moveTo(float[] pos) {
        this.moveTo(pos[0], pos[1], pos[2]);
    }

    @Override
    public void moveTo(double[] pos) {
        this.moveTo((float)pos[0], (float)pos[1], (float)pos[2]);
    }

    @Override
    public void moveRel(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.cursor.move(Util.round(this.x) - this.cursor.getPosition(0), 0);
        this.cursor.move(Util.round(this.y) - this.cursor.getPosition(1), 1);
        this.cursor.move(Util.round(this.z) - this.cursor.getPosition(2), 2);
    }

    @Override
    public void moveRel(float[] vector) {
        this.moveRel(vector[0], vector[1], vector[2]);
    }

    @Override
    public void moveRel(double[] vector) {
        this.moveRel((float)vector[0], (float)vector[1], (float)vector[2]);
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.cursor.setPosition(Util.round(x), 0);
        this.cursor.setPosition(Util.round(y), 1);
        this.cursor.setPosition(Util.round(z), 2);
    }

    @Override
    public void setPosition(float[] pos) {
        this.setPosition(pos[0], pos[1], pos[2]);
    }

    @Override
    public void setPosition(double[] pos) {
        this.setPosition((float)pos[0], (float)pos[1], (float)pos[2]);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }
}

