/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm.fn;

import mpicbg.imglib.algorithm.roi.StatisticalOperation;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.algorithm.fn.AlgorithmUtil;

public abstract class Morph<T extends RealType<T>>
extends Image<T> {
    public static final Shape BALL = Shape.BALL;
    public static final Shape CUBE = Shape.CUBE;
    public static final Shape BAR = Shape.BAR;

    private Morph(Image<T> img) {
        super(img.getContainer(), img.createType());
    }

    public Morph(Object fn, Class<?> c, Shape s, int shapeLength, int lengthDim, float outside) throws Exception {
        this(Morph.process(c, fn, s, shapeLength, lengthDim, outside));
    }

    private static final <R extends RealType<R>> Image<R> process(Class<?> c, Object fn, Shape s, int shapeLength, int lengthDim, float outside) throws Exception {
        StructuringElement strel;
        Image img = AlgorithmUtil.wrap(fn);
        switch (s) {
            case BALL: {
                strel = StructuringElement.createBall(img.getNumDimensions(), shapeLength);
                break;
            }
            case BAR: {
                strel = StructuringElement.createBar(img.getNumDimensions(), shapeLength, lengthDim);
                break;
            }
            default: {
                strel = StructuringElement.createCube(img.getNumDimensions(), shapeLength);
            }
        }
        RealType t = (RealType)img.createType();
        t.setReal(outside);
        StatisticalOperation morph = (StatisticalOperation)c.getConstructor(Image.class, StructuringElement.class, OutOfBoundsStrategyFactory.class).newInstance(img, strel, new OutOfBoundsStrategyValueFactory<RealType>(t));
        if (!morph.process()) {
            throw new Exception(morph.getClass().getSimpleName() + ": " + morph.getErrorMessage());
        }
        return morph.getResult();
    }

    public static enum Shape {
        BALL,
        CUBE,
        BAR;

    }
}

