/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.util;

public class NumberedStringSorter {
    public static void sort(String[] a) {
        if (!NumberedStringSorter.alreadySorted(a)) {
            NumberedStringSorter.sort(a, 0, a.length - 1);
        }
    }

    static void sort(String[] a, int from, int to) {
        int i = from;
        int j = to;
        String center = a[(from + to) / 2];
        while (true) {
            if (i < to && NumberedStringSorter.compareNumberedStrings(center, a[i]) > 0) {
                ++i;
                continue;
            }
            while (j > from && NumberedStringSorter.compareNumberedStrings(center, a[j]) < 0) {
                --j;
            }
            if (i < j) {
                String temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
            if (i <= j) {
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (from < j) {
            NumberedStringSorter.sort(a, from, j);
        }
        if (i < to) {
            NumberedStringSorter.sort(a, i, to);
        }
    }

    static boolean alreadySorted(String[] a) {
        for (int i = 1; i < a.length; ++i) {
            if (NumberedStringSorter.compareNumberedStrings(a[i], a[i - 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    static int compareNumberedStrings(String first, String second) {
        int i1 = 0;
        int i2 = 0;
        int N1 = first.length();
        int N2 = second.length();
        while (i1 < N1 && i2 < N2) {
            char c1 = first.charAt(i1);
            char c2 = second.charAt(i2);
            if (c1 >= '0' && c1 <= '9') {
                if ('9' < c2) {
                    return -1;
                }
                if ('0' > c2) {
                    return 1;
                }
                String num1 = "";
                String num2 = "";
                do {
                    num1 = num1 + c1;
                    if (++i1 >= N1) continue;
                    c1 = first.charAt(i1);
                } while (i1 < N1 && c1 >= '0' && c1 <= '9');
                int int1 = Integer.parseInt(num1);
                do {
                    num2 = num2 + c2;
                    if (++i2 >= N2) continue;
                    c2 = second.charAt(i2);
                } while (i2 < N2 && c2 >= '0' && c2 <= '9');
                int int2 = Integer.parseInt(num2);
                if (int1 < int2) {
                    return -1;
                }
                if (int1 <= int2) continue;
                return 1;
            }
            if (c1 < c2) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            ++i1;
            ++i2;
        }
        if (N1 < N2) {
            return -1;
        }
        if (N1 > N2) {
            return 1;
        }
        return 0;
    }
}

